/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.EntityMock;
import java.util.UUID;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TNTPrimedMock
extends EntityMock
implements TNTPrimed {
    private int fuseTicks = 80;
    private Entity source;
    private float explosionYield = 4.0f;
    private boolean incendiary = false;

    protected TNTPrimedMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public void setFuseTicks(int fuseTicks) {
        this.fuseTicks = fuseTicks;
    }

    public int getFuseTicks() {
        return this.fuseTicks;
    }

    @Nullable
    public Entity getSource() {
        return this.source;
    }

    public void setSource(@Nullable Entity source) {
        this.source = source instanceof LivingEntity ? source : null;
    }

    public void setBlockData(@NotNull BlockData blockData) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BlockData getBlockData() {
        throw new UnimplementedOperationException();
    }

    public void setYield(float explosionYield) {
        this.explosionYield = explosionYield;
    }

    public float getYield() {
        return this.explosionYield;
    }

    public void setIsIncendiary(boolean incendiary) {
        this.incendiary = incendiary;
    }

    public boolean isIncendiary() {
        return this.incendiary;
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.PRIMED_TNT;
    }

    public void tick(int ticks) {
        this.setFuseTicks(this.getFuseTicks() - ticks);
        if (this.getFuseTicks() <= 0) {
            this.explode();
            this.remove();
        }
    }

    public void tick() {
        this.tick(1);
    }

    private void explode() {
        ExplosionPrimeEvent event = new ExplosionPrimeEvent((Explosive)this);
        this.server.getPluginManager().callEvent((Event)event);
    }
}

