/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.FishMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Tadpole;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TadpoleMock
extends FishMock
implements Tadpole {
    private int age = 0;
    private boolean agelock;

    public TadpoleMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    @NotNull
    public ItemStack getBaseBucketItem() {
        return new ItemStack(Material.TADPOLE_BUCKET);
    }

    @Override
    @NotNull
    public Sound getPickupSound() {
        return Sound.ITEM_BUCKET_FILL_TADPOLE;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        Preconditions.checkArgument((this.age + age < 24000 ? 1 : 0) != 0, (Object)"Tadpole age can't be greater than 24000");
        this.age = age;
    }

    public void setAgeLock(boolean lock) {
        this.agelock = lock;
    }

    public boolean getAgeLock() {
        return this.agelock;
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.TADPOLE;
    }
}

