/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.OfflinePlayerMock;
import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import be.seeseemelk.mockbukkit.profile.PlayerProfileMock;
import com.destroystokyo.paper.profile.PlayerProfile;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkullMetaMock
extends ItemMetaMock
implements SkullMeta {
    private static final int MAX_OWNER_LENGTH = 16;
    @Nullable
    private PlayerProfile playerProfile;

    public SkullMetaMock() {
    }

    public SkullMetaMock(@NotNull SkullMeta meta) {
        super((ItemMeta)meta);
        this.playerProfile = meta.getPlayerProfile();
    }

    @Override
    @NotNull
    public SkullMetaMock clone() {
        SkullMetaMock mock = (SkullMetaMock)super.clone();
        if (this.playerProfile != null) {
            mock.setOwner(this.playerProfile.getName());
            mock.setPlayerProfile(this.playerProfile);
        }
        return mock;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + (this.playerProfile == null ? 0 : this.playerProfile.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SkullMeta)) {
            return false;
        }
        SkullMeta other = (SkullMeta)obj;
        return Objects.equals(this.playerProfile.getName(), other.getOwningPlayer().getName());
    }

    @Deprecated(since="1.13")
    public String getOwner() {
        return this.hasOwner() ? this.playerProfile.getName() : null;
    }

    public boolean hasOwner() {
        return this.playerProfile != null && !this.playerProfile.getName().isEmpty();
    }

    @Deprecated(since="1.13")
    public boolean setOwner(String name) {
        if (name != null && name.length() > 16) {
            return false;
        }
        if (name == null) {
            this.setPlayerProfile(null);
        } else {
            Player player = Bukkit.getPlayer((String)name);
            if (player != null) {
                this.setPlayerProfile(player.getPlayerProfile());
            } else {
                this.setPlayerProfile(new PlayerProfileMock(name, new UUID(0L, 0L)));
            }
        }
        return true;
    }

    public void setPlayerProfile(@Nullable PlayerProfile profile) {
        this.playerProfile = profile;
    }

    public @Nullable PlayerProfile getPlayerProfile() {
        return this.playerProfile;
    }

    public OfflinePlayer getOwningPlayer() {
        if (this.hasOwner()) {
            return new OfflinePlayerMock(this.playerProfile.getName());
        }
        return null;
    }

    public boolean setOwningPlayer(@Nullable OfflinePlayer owner) {
        if (owner == null) {
            this.setPlayerProfile(null);
        } else {
            this.setPlayerProfile(new PlayerProfileMock(owner.getName(), owner.getUniqueId()));
        }
        return true;
    }

    @Deprecated(since="1.18")
    public org.bukkit.profile.PlayerProfile getOwnerProfile() {
        if (!this.hasOwner()) {
            return null;
        }
        return new PlayerProfileMock(this.playerProfile);
    }

    @Deprecated(since="1.18")
    public void setOwnerProfile(@Nullable org.bukkit.profile.PlayerProfile profile) {
        if (profile == null) {
            this.setPlayerProfile(null);
        } else {
            this.setPlayerProfile(new PlayerProfileMock(profile.getName(), profile.getUniqueId()));
        }
    }

    public void setNoteBlockSound(@Nullable NamespacedKey noteBlockSound) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public NamespacedKey getNoteBlockSound() {
        throw new UnimplementedOperationException();
    }
}

