/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.scheduler.paper;

import be.seeseemelk.mockbukkit.scheduler.BukkitSchedulerMock;
import be.seeseemelk.mockbukkit.scheduler.paper.PaperScheduledTask;
import com.google.common.base.Preconditions;
import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class FoliaAsyncScheduler
implements AsyncScheduler {
    private static final long NANOS_PER_TICK = 50000000L;
    private static final String TASK_CANNOT_BE_NULL = "task cannot be null";
    private static final String UNIT_CANNOT_BE_NULL = "unit cannot be null";
    private static final String PLUGIN_CANNOT_BE_NULL = "plugin cannot be null";
    private final BukkitSchedulerMock scheduler;

    public FoliaAsyncScheduler(BukkitSchedulerMock scheduler) {
        this.scheduler = scheduler;
    }

    @NotNull
    public ScheduledTask runNow(@NotNull Plugin plugin, @NotNull Consumer<ScheduledTask> task) {
        Preconditions.checkNotNull((Object)plugin, (Object)PLUGIN_CANNOT_BE_NULL);
        Preconditions.checkNotNull(task, (Object)TASK_CANNOT_BE_NULL);
        PaperScheduledTask scheduledTask = new PaperScheduledTask(plugin, task);
        this.scheduler.runTaskAsynchronously(plugin, scheduledTask::run);
        return scheduledTask;
    }

    @NotNull
    public ScheduledTask runDelayed(@NotNull Plugin plugin, @NotNull Consumer<ScheduledTask> task, long delay, @NotNull TimeUnit unit) {
        Preconditions.checkNotNull((Object)plugin, (Object)PLUGIN_CANNOT_BE_NULL);
        Preconditions.checkNotNull(task, (Object)TASK_CANNOT_BE_NULL);
        Preconditions.checkNotNull((Object)((Object)unit), (Object)UNIT_CANNOT_BE_NULL);
        PaperScheduledTask scheduledTask = new PaperScheduledTask(plugin, task);
        this.scheduler.runTaskLaterAsynchronously(plugin, scheduledTask::run, FoliaAsyncScheduler.toTicks(delay, unit));
        return scheduledTask;
    }

    @NotNull
    public ScheduledTask runAtFixedRate(@NotNull Plugin plugin, @NotNull Consumer<ScheduledTask> task, long initialDelay, long period, @NotNull TimeUnit unit) {
        Preconditions.checkNotNull((Object)plugin, (Object)PLUGIN_CANNOT_BE_NULL);
        Preconditions.checkNotNull(task, (Object)TASK_CANNOT_BE_NULL);
        Preconditions.checkNotNull((Object)((Object)unit), (Object)UNIT_CANNOT_BE_NULL);
        PaperScheduledTask scheduledTask = new PaperScheduledTask(plugin, task);
        this.scheduler.runTaskTimerAsynchronously(plugin, scheduledTask::run, FoliaAsyncScheduler.toTicks(initialDelay, unit), FoliaAsyncScheduler.toTicks(period, unit));
        return scheduledTask;
    }

    public void cancelTasks(@NotNull Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)PLUGIN_CANNOT_BE_NULL);
        this.scheduler.cancelTasks(plugin);
    }

    private static long toTicks(long delay, TimeUnit timeUnit) {
        long nanoseconds = timeUnit.toNanos(delay);
        return nanoseconds / 50000000L;
    }
}

