/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.scoreboard;

import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.EntityMock;
import be.seeseemelk.mockbukkit.scoreboard.ScoreboardMock;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamMock
implements Team {
    private final String name;
    private Component displayName;
    @NotNull
    private Component prefix = Component.empty();
    @NotNull
    private Component suffix = Component.empty();
    @NotNull
    private ChatColor color = ChatColor.RESET;
    private boolean allowFriendlyFire = false;
    @NotNull
    private final HashSet<String> entries;
    private boolean canSeeFriendly = true;
    private final EnumMap<Team.Option, Team.OptionStatus> options = new EnumMap(Team.Option.class);
    @Nullable
    private ScoreboardMock board;

    public TeamMock(@NotNull String name, ScoreboardMock board) {
        this.name = name;
        this.displayName = Component.text((String)name);
        this.board = board;
        this.entries = new HashSet();
        this.options.put(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
    }

    @NotNull
    public String getName() throws IllegalStateException {
        this.checkRegistered();
        return this.name;
    }

    @NotNull
    public Component displayName() throws IllegalStateException {
        this.checkRegistered();
        return this.displayName;
    }

    public void displayName(@Nullable Component displayName) throws IllegalStateException, IllegalArgumentException {
        this.checkRegistered();
        this.displayName = displayName == null ? Component.empty() : displayName;
    }

    @NotNull
    public Component prefix() throws IllegalStateException {
        this.checkRegistered();
        return this.prefix;
    }

    public void prefix(@Nullable Component prefix) throws IllegalStateException, IllegalArgumentException {
        this.checkRegistered();
        this.prefix = prefix == null ? Component.empty() : prefix;
    }

    @NotNull
    public Component suffix() throws IllegalStateException {
        this.checkRegistered();
        return this.suffix;
    }

    public void suffix(@Nullable Component suffix) throws IllegalStateException, IllegalArgumentException {
        this.checkRegistered();
        this.suffix = suffix == null ? Component.empty() : suffix;
    }

    public boolean hasColor() {
        this.checkRegistered();
        return this.color.isColor();
    }

    @NotNull
    public TextColor color() throws IllegalStateException {
        Preconditions.checkState((boolean)this.hasColor(), (Object)"Team colors must have hex values");
        return TextColor.color((int)this.color.asBungee().getColor().getRGB());
    }

    public void color(@Nullable NamedTextColor color) {
        this.checkRegistered();
        this.color = color == null ? ChatColor.RESET : ChatColor.valueOf((String)color.toString().toUpperCase(Locale.ROOT));
    }

    @NotNull
    public String getDisplayName() throws IllegalStateException {
        this.checkRegistered();
        return LegacyComponentSerializer.legacySection().serialize(this.displayName);
    }

    public void setDisplayName(@NotNull String displayName) {
        Preconditions.checkNotNull((Object)displayName, (Object)"Display name cannot be null");
        Preconditions.checkArgument((ChatColor.stripColor((String)displayName).length() <= 128 ? 1 : 0) != 0, (Object)"Display name is longer than the limit of 128 characters");
        this.checkRegistered();
        this.displayName = LegacyComponentSerializer.legacySection().deserialize(displayName);
    }

    @NotNull
    public String getPrefix() throws IllegalStateException {
        this.checkRegistered();
        return LegacyComponentSerializer.legacySection().serialize(this.prefix);
    }

    public void setPrefix(@NotNull String prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"Prefix cannot be null");
        Preconditions.checkArgument((ChatColor.stripColor((String)prefix).length() <= 64 ? 1 : 0) != 0, (Object)"Prefix is longer than the limit of 64 characters");
        this.checkRegistered();
        this.prefix = LegacyComponentSerializer.legacySection().deserialize(prefix);
    }

    @NotNull
    public String getSuffix() throws IllegalStateException {
        this.checkRegistered();
        return LegacyComponentSerializer.legacySection().serialize(this.suffix);
    }

    public void setSuffix(@NotNull String suffix) {
        Preconditions.checkNotNull((Object)suffix, (Object)"Suffix cannot be null");
        Preconditions.checkArgument((ChatColor.stripColor((String)suffix).length() <= 64 ? 1 : 0) != 0, (Object)"Suffix is longer than the limit of 64 characters");
        this.checkRegistered();
        this.suffix = LegacyComponentSerializer.legacySection().deserialize(suffix);
    }

    @NotNull
    public ChatColor getColor() throws IllegalStateException {
        this.checkRegistered();
        return this.color;
    }

    public void setColor(@NotNull ChatColor chatColor) {
        Preconditions.checkNotNull((Object)chatColor, (Object)"Color cannot be null");
        this.checkRegistered();
        this.color = chatColor;
    }

    public boolean allowFriendlyFire() throws IllegalStateException {
        this.checkRegistered();
        return this.allowFriendlyFire;
    }

    public void setAllowFriendlyFire(boolean b) throws IllegalStateException {
        this.checkRegistered();
        this.allowFriendlyFire = b;
    }

    public boolean canSeeFriendlyInvisibles() throws IllegalStateException {
        this.checkRegistered();
        return this.canSeeFriendly;
    }

    public void setCanSeeFriendlyInvisibles(boolean b) throws IllegalStateException {
        this.checkRegistered();
        this.canSeeFriendly = b;
    }

    @Deprecated(since="1.9")
    @NotNull
    public NameTagVisibility getNameTagVisibility() {
        this.checkRegistered();
        Team.OptionStatus s = this.options.get(Team.Option.NAME_TAG_VISIBILITY);
        return switch (s) {
            case Team.OptionStatus.NEVER -> NameTagVisibility.NEVER;
            case Team.OptionStatus.ALWAYS -> NameTagVisibility.ALWAYS;
            case Team.OptionStatus.FOR_OTHER_TEAMS -> NameTagVisibility.HIDE_FOR_OTHER_TEAMS;
            case Team.OptionStatus.FOR_OWN_TEAM -> NameTagVisibility.HIDE_FOR_OWN_TEAM;
            default -> throw new IllegalArgumentException("Option not compatible");
        };
    }

    @Deprecated(since="1.9")
    public void setNameTagVisibility(@NotNull NameTagVisibility nameTagVisibility) {
        MockBukkit.getMock().getLogger().log(Level.WARNING, "Consider USE setOption() DEPRECATED");
        this.checkRegistered();
        switch (nameTagVisibility) {
            case ALWAYS: {
                this.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
                break;
            }
            case NEVER: {
                this.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
                break;
            }
            case HIDE_FOR_OTHER_TEAMS: {
                this.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.FOR_OTHER_TEAMS);
                break;
            }
            case HIDE_FOR_OWN_TEAM: {
                this.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.FOR_OWN_TEAM);
                break;
            }
            default: {
                throw new IllegalArgumentException("Option not compatible");
            }
        }
    }

    @Deprecated(since="1.8.7")
    @NotNull
    public Set<OfflinePlayer> getPlayers() throws IllegalStateException {
        this.checkRegistered();
        HashSet<OfflinePlayer> players = new HashSet<OfflinePlayer>();
        for (String s : this.entries) {
            OfflinePlayer player;
            if (s == null || (player = MockBukkit.getMock().getOfflinePlayer(s)) == null) continue;
            players.add(player);
        }
        return players;
    }

    @NotNull
    public Set<String> getEntries() throws IllegalStateException {
        this.checkRegistered();
        return this.entries;
    }

    public int getSize() throws IllegalStateException {
        this.checkRegistered();
        return this.entries.size();
    }

    public Scoreboard getScoreboard() {
        return this.board;
    }

    @Deprecated(since="1.8.7")
    public void addPlayer(@NotNull OfflinePlayer offlinePlayer) {
        Preconditions.checkNotNull((Object)offlinePlayer, (Object)"OfflinePlayer cannot be null");
        this.checkRegistered();
        this.entries.add(offlinePlayer.getName());
    }

    public void addEntry(@NotNull String entry) {
        Preconditions.checkNotNull((Object)entry, (Object)"Entry cannot be null");
        this.checkRegistered();
        this.entries.add(entry);
    }

    public void addEntities(@NotNull Collection<Entity> entities) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkNotNull(entities, (Object)"Entities cannot be null");
        this.addEntries(entities.stream().map(entity -> ((EntityMock)entity).getScoreboardEntry()).toList());
    }

    public void addEntries(@NotNull Collection<String> entries) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkNotNull(entries, (Object)"Entries cannot be null");
        this.checkRegistered();
        this.entries.addAll(entries);
    }

    @Deprecated(since="1.8.7")
    public boolean removePlayer(@NotNull OfflinePlayer offlinePlayer) {
        Preconditions.checkNotNull((Object)offlinePlayer, (Object)"OfflinePlayer cannot be null");
        this.checkRegistered();
        return this.entries.remove(offlinePlayer.getName());
    }

    public boolean removeEntry(@NotNull String entry) {
        Preconditions.checkNotNull((Object)entry, (Object)"Entry cannot be null");
        this.checkRegistered();
        return this.entries.remove(entry);
    }

    public boolean removeEntities(@NotNull Collection<Entity> entities) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkNotNull(entities, (Object)"Entities cannot be null");
        return this.removeEntries(entities.stream().map(entity -> ((EntityMock)entity).getScoreboardEntry()).toList());
    }

    public boolean removeEntries(@NotNull Collection<String> entries) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkNotNull(entries, (Object)"Entries cannot be null");
        this.checkRegistered();
        return this.entries.removeAll(entries);
    }

    public void unregister() throws IllegalStateException {
        this.checkRegistered();
        this.board.unregister(this);
        this.board = null;
    }

    @Deprecated(since="1.8.7")
    public boolean hasPlayer(@NotNull OfflinePlayer offlinePlayer) {
        Preconditions.checkNotNull((Object)offlinePlayer, (Object)"OfflinePlayer cannot be null");
        this.checkRegistered();
        return this.entries.contains(offlinePlayer.getName());
    }

    public boolean hasEntry(@NotNull String entry) {
        Preconditions.checkNotNull((Object)entry, (Object)"Entry cannot be null");
        this.checkRegistered();
        return this.entries.contains(entry);
    }

    @NotNull
    public Team.OptionStatus getOption(@NotNull Team.Option option) throws IllegalStateException {
        Preconditions.checkNotNull((Object)option, (Object)"Option cannot be null");
        this.checkRegistered();
        return this.options.get(option);
    }

    public void setOption(@NotNull Team.Option option, @NotNull Team.OptionStatus optionStatus) throws IllegalStateException {
        Preconditions.checkNotNull((Object)option, (Object)"Option cannot be null");
        Preconditions.checkNotNull((Object)optionStatus, (Object)"OptionStatus cannot be null");
        this.checkRegistered();
        this.options.put(option, optionStatus);
    }

    public void addEntity(@NotNull Entity entity) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null");
        this.addEntry(((EntityMock)entity).getScoreboardEntry());
    }

    public boolean removeEntity(@NotNull Entity entity) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null");
        return this.removeEntry(((EntityMock)entity).getScoreboardEntry());
    }

    public boolean hasEntity(@NotNull Entity entity) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null");
        this.checkRegistered();
        return this.entries.contains(((EntityMock)entity).getScoreboardEntry());
    }

    public void checkRegistered() {
        if (this.board != null) {
            return;
        }
        throw new IllegalStateException("Team not registered");
    }

    @NotNull
    public Iterable<? extends Audience> audiences() {
        throw new UnimplementedOperationException();
    }
}

