/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.Coordinate;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;

public class ChunkSnapshotMock
implements ChunkSnapshot {
    private final String worldName;
    private final int x;
    private final int z;
    private final int minY;
    private final int maxY;
    private final long worldTime;
    private final Map<Coordinate, BlockData> blockData;
    private final Map<Coordinate, Biome> biomes;

    ChunkSnapshotMock(int x, int z, int minY, int maxY, String worldName, long worldTime, Map<Coordinate, BlockData> blockData, Map<Coordinate, Biome> biomes) {
        this.x = x;
        this.z = z;
        this.minY = minY;
        this.maxY = maxY;
        this.worldName = worldName;
        this.worldTime = worldTime;
        this.blockData = blockData;
        this.biomes = biomes;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    @NotNull
    public String getWorldName() {
        return this.worldName;
    }

    @NotNull
    public Material getBlockType(int x, int y, int z) {
        this.validateChunkCoordinates(x, y, z);
        return this.blockData.get(new Coordinate(x, y, z)).getMaterial();
    }

    @NotNull
    public BlockData getBlockData(int x, int y, int z) {
        this.validateChunkCoordinates(x, y, z);
        return this.blockData.get(new Coordinate(x, y, z));
    }

    public int getData(int x, int y, int z) {
        throw new UnimplementedOperationException();
    }

    public int getBlockSkyLight(int x, int y, int z) {
        throw new UnimplementedOperationException();
    }

    public int getBlockEmittedLight(int x, int y, int z) {
        throw new UnimplementedOperationException();
    }

    public int getHighestBlockYAt(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Biome getBiome(int x, int z) {
        return this.getBiome(z, 0, z);
    }

    @NotNull
    public Biome getBiome(int x, int y, int z) {
        Preconditions.checkState((this.biomes != null && !this.biomes.isEmpty() ? 1 : 0) != 0, (Object)"ChunkSnapshot created without biome. Please call getSnapshot with includeBiome=true");
        this.validateChunkCoordinates(x, y, z);
        return this.biomes.get(new Coordinate(z, y, z));
    }

    public double getRawBiomeTemperature(int x, int z) {
        return this.getRawBiomeTemperature(x, 0, z);
    }

    public double getRawBiomeTemperature(int x, int y, int z) {
        throw new UnimplementedOperationException();
    }

    public long getCaptureFullTime() {
        return this.worldTime;
    }

    public boolean isSectionEmpty(int sy) {
        int totalSections = (int)Math.ceil((double)Math.abs(this.minY - this.maxY) / 16.0);
        if (sy < 0 || sy >= totalSections) {
            throw new ArrayIndexOutOfBoundsException("Index %d out of bounds for length %d".formatted(sy, totalSections));
        }
        for (int blockY = this.minY + (sy << 4); blockY < this.minY + (sy << 4) + 16 && blockY >= this.minY && blockY < this.maxY; ++blockY) {
            for (int blockX = 0; blockX < 16; ++blockX) {
                for (int blockZ = 0; blockZ < 16; ++blockZ) {
                    if (this.getBlockType(blockX, blockY, blockZ).isAir()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean contains(@NotNull BlockData block) {
        Preconditions.checkNotNull((Object)block, (Object)"BlockData cannot be null");
        return this.blockData.containsValue(block);
    }

    public boolean contains(@NotNull Biome biome) {
        throw new UnimplementedOperationException();
    }

    private void validateChunkCoordinates(int x, int y, int z) {
        Preconditions.checkArgument((0 <= x && x <= 15 ? 1 : 0) != 0, (String)"x out of range (expected 0-15, got %s)", (int)x);
        Preconditions.checkArgument((this.minY <= y && y <= this.maxY ? 1 : 0) != 0, (String)"y out of range (expected %s-%s, got %s)", (Object)this.minY, (Object)this.maxY, (Object)y);
        Preconditions.checkArgument((0 <= z && z <= 15 ? 1 : 0) != 0, (String)"z out of range (expected 0-15, got %s)", (int)z);
    }
}

