/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.MockBukkitInject;
import be.seeseemelk.mockbukkit.ServerMock;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.jetbrains.annotations.ApiStatus;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

@ApiStatus.Experimental
public class MockBukkitExtension
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    public void beforeEach(ExtensionContext context) throws Exception {
        ServerMock serverMock = MockBukkit.getOrCreateMock();
        this.injectServerMockIntoFields(context, serverMock);
    }

    private void injectServerMockIntoFields(ExtensionContext context, ServerMock serverMock) throws IllegalAccessException {
        Optional classOptional = context.getTestClass();
        if (classOptional.isEmpty()) {
            return;
        }
        List<Field> serverMockFields = FieldUtils.getAllFieldsList((Class)((Class)classOptional.get())).stream().filter(field -> field.getType() == ServerMock.class).filter(field -> field.getAnnotation(MockBukkitInject.class) != null).toList();
        Optional optionalTestInstance = context.getTestInstance();
        if (optionalTestInstance.isEmpty()) {
            return;
        }
        Object testInstance = optionalTestInstance.get();
        for (Field field2 : serverMockFields) {
            String name = field2.getName();
            FieldUtils.writeDeclaredField(testInstance, (String)name, (Object)((Object)serverMock), (boolean)true);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        MockBukkit.unmock();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        boolean paramIsCorrectType = parameterContext.getParameter().getType() == ServerMock.class;
        boolean paramHasCorrectAnnotation = parameterContext.isAnnotated(MockBukkitInject.class);
        return paramIsCorrectType && paramHasCorrectAnnotation;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (!this.supportsParameter(parameterContext, extensionContext)) {
            return null;
        }
        return MockBukkit.getOrCreateMock();
    }
}

