/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import com.google.common.base.Preconditions;
import io.papermc.paper.plugin.PermissionManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermissionManagerMock
implements PermissionManager {
    private final Map<String, Permission> permissions = new HashMap<String, Permission>();
    private final Map<Boolean, Set<Permission>> defaultPermissions = new HashMap<Boolean, Set<Permission>>();
    private final Map<String, Map<Permissible, Boolean>> permissionSubscriptions = new HashMap<String, Map<Permissible, Boolean>>();
    private final Map<Boolean, Map<Permissible, Boolean>> defaultSubscriptions = new HashMap<Boolean, Map<Permissible, Boolean>>();

    protected PermissionManagerMock() {
        this.defaultPermissions.put(true, new LinkedHashSet());
        this.defaultPermissions.put(false, new LinkedHashSet());
    }

    @Nullable
    public Permission getPermission(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        return this.permissions.get(name.toLowerCase(Locale.ENGLISH));
    }

    public void addPermission(@NotNull Permission perm) {
        this.addPermission(perm, true);
    }

    private void addPermission(@NotNull Permission perm, boolean dirtyPermissibles) {
        Preconditions.checkNotNull((Object)perm, (Object)"Permission cannot be null");
        String name = perm.getName().toLowerCase(Locale.ENGLISH);
        Preconditions.checkArgument((!this.permissions.containsKey(name) ? 1 : 0) != 0, (Object)("The permission " + name + " is already defined!"));
        this.permissions.put(name, perm);
        this.calculatePermissionDefault(perm);
        if (dirtyPermissibles) {
            this.dirtyPermissibles();
        }
    }

    public void removePermission(@NotNull Permission perm) {
        Preconditions.checkNotNull((Object)perm, (Object)"Permission cannot be null");
        this.removePermission(perm.getName());
    }

    public void removePermission(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        this.permissions.remove(name.toLowerCase(Locale.ENGLISH));
    }

    @NotNull
    public Set<Permission> getDefaultPermissions(boolean op) {
        return Set.copyOf((Collection)this.defaultPermissions.get(op));
    }

    public void recalculatePermissionDefaults(@NotNull Permission perm) {
        Preconditions.checkNotNull((Object)perm);
        if (this.permissions.containsKey(perm.getName().toLowerCase(Locale.ENGLISH))) {
            this.defaultPermissions.get(true).remove(perm);
            this.defaultPermissions.get(false).remove(perm);
            this.calculatePermissionDefault(perm);
        }
    }

    public void subscribeToPermission(@NotNull String permission, @NotNull Permissible permissible) {
        Preconditions.checkNotNull((Object)permission, (Object)"Permission cannot be null");
        Preconditions.checkNotNull((Object)permissible, (Object)"Permissible cannot be null");
        String name = permission.toLowerCase(Locale.ENGLISH);
        Map map = this.permissionSubscriptions.computeIfAbsent(name, key -> new WeakHashMap());
        map.put(permissible, true);
    }

    public void unsubscribeFromPermission(@NotNull String permission, @NotNull Permissible permissible) {
        Preconditions.checkNotNull((Object)permission, (Object)"Permission cannot be null");
        Preconditions.checkNotNull((Object)permissible, (Object)"Permissible cannot be null");
        String name = permission.toLowerCase(Locale.ENGLISH);
        Map<Permissible, Boolean> map = this.permissionSubscriptions.get(name);
        if (map != null) {
            map.remove(permissible);
            if (map.isEmpty()) {
                this.permissionSubscriptions.remove(name);
            }
        }
    }

    @NotNull
    public Set<Permissible> getPermissionSubscriptions(@NotNull String permission) {
        Preconditions.checkNotNull((Object)permission, (Object)"Permission cannot be null");
        String name = permission.toLowerCase(Locale.ENGLISH);
        Map<Permissible, Boolean> map = this.permissionSubscriptions.get(name);
        if (map == null) {
            return Set.of();
        }
        return Set.copyOf(map.keySet());
    }

    public void subscribeToDefaultPerms(boolean op, @NotNull Permissible permissible) {
        Preconditions.checkNotNull((Object)permissible, (Object)"Permissible cannot be null");
        Map map = this.defaultSubscriptions.computeIfAbsent(op, k -> new WeakHashMap());
        map.put(permissible, true);
    }

    public void unsubscribeFromDefaultPerms(boolean op, @NotNull Permissible permissible) {
        Preconditions.checkNotNull((Object)permissible, (Object)"Permissible cannot be null");
        Map<Permissible, Boolean> map = this.defaultSubscriptions.get(op);
        if (map != null) {
            map.remove(permissible);
            if (map.isEmpty()) {
                this.defaultSubscriptions.remove(op);
            }
        }
    }

    @NotNull
    public Set<Permissible> getDefaultPermSubscriptions(boolean op) {
        Map<Permissible, Boolean> map = this.defaultSubscriptions.get(op);
        if (map == null) {
            return Set.of();
        }
        return Set.copyOf(map.keySet());
    }

    @NotNull
    public Set<Permission> getPermissions() {
        return Set.copyOf(this.permissions.values());
    }

    public void addPermissions(@NotNull List<Permission> perm) {
        Preconditions.checkNotNull(perm);
        perm.forEach(permission -> this.addPermission((Permission)permission, false));
        this.dirtyPermissibles();
    }

    public void clearPermissions() {
        this.permissions.clear();
        this.defaultPermissions.get(true).clear();
        this.defaultPermissions.get(false).clear();
    }

    private void calculatePermissionDefault(Permission permission) {
        if (permission.getDefault() == PermissionDefault.OP || permission.getDefault() == PermissionDefault.TRUE) {
            this.defaultPermissions.get(true).add(permission);
        }
        if (permission.getDefault() == PermissionDefault.NOT_OP || permission.getDefault() == PermissionDefault.TRUE) {
            this.defaultPermissions.get(false).add(permission);
        }
    }

    void dirtyPermissibles(boolean op) {
        Set<Permissible> permissibles = this.getDefaultPermSubscriptions(op);
        for (Permissible p : permissibles) {
            p.recalculatePermissions();
        }
    }

    private void dirtyPermissibles() {
        this.dirtyPermissibles(true);
        this.dirtyPermissibles(false);
    }
}

