/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.GameEventMock;
import be.seeseemelk.mockbukkit.JukeboxSongMock;
import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.MusicInstrumentMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.block.BlockTypeMock;
import be.seeseemelk.mockbukkit.block.banner.PatternTypeMock;
import be.seeseemelk.mockbukkit.damage.DamageTypeMock;
import be.seeseemelk.mockbukkit.enchantments.EnchantmentMock;
import be.seeseemelk.mockbukkit.entity.variant.CatVariantMock;
import be.seeseemelk.mockbukkit.entity.variant.FrogVariantMock;
import be.seeseemelk.mockbukkit.entity.variant.VillagerProfessionMock;
import be.seeseemelk.mockbukkit.entity.variant.VillagerTypeMock;
import be.seeseemelk.mockbukkit.entity.variant.WolfVariantMock;
import be.seeseemelk.mockbukkit.generator.structure.StructureMock;
import be.seeseemelk.mockbukkit.generator.structure.StructureTypeMock;
import be.seeseemelk.mockbukkit.inventory.ItemTypeMock;
import be.seeseemelk.mockbukkit.inventory.meta.trim.TrimMaterialMock;
import be.seeseemelk.mockbukkit.inventory.meta.trim.TrimPatternMock;
import be.seeseemelk.mockbukkit.map.MapCursorTypeMock;
import be.seeseemelk.mockbukkit.potion.MockPotionEffectType;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.papermc.paper.registry.RegistryKey;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryMock<T extends Keyed>
implements Registry<T> {
    private final Map<NamespacedKey, T> keyedMap = new HashMap<NamespacedKey, T>();
    private JsonArray keyedData;
    private Function<JsonObject, T> constructor;

    public RegistryMock(RegistryKey<T> key) {
        try {
            this.loadKeyedToRegistry(key);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadKeyedToRegistry(RegistryKey<T> key) throws IOException {
        String fileName = "/keyed/" + key.key().value() + ".json";
        this.constructor = this.getConstructor(key);
        try (InputStream stream = MockBukkit.class.getResourceAsStream(fileName);){
            if (stream == null) {
                throw new FileNotFoundException(fileName);
            }
            JsonElement element = JsonParser.parseReader((Reader)new InputStreamReader(stream));
            this.keyedData = element.getAsJsonObject().get("values").getAsJsonArray();
        }
    }

    private Function<JsonObject, ? extends Keyed> getConstructor(RegistryKey<T> key) {
        if (key == RegistryKey.STRUCTURE) {
            return StructureMock::from;
        }
        if (key == RegistryKey.STRUCTURE_TYPE) {
            return StructureTypeMock::from;
        }
        if (key == RegistryKey.TRIM_MATERIAL) {
            return TrimMaterialMock::from;
        }
        if (key == RegistryKey.TRIM_PATTERN) {
            return TrimPatternMock::from;
        }
        if (key == RegistryKey.INSTRUMENT) {
            return MusicInstrumentMock::from;
        }
        if (key == RegistryKey.GAME_EVENT) {
            return GameEventMock::from;
        }
        if (key == RegistryKey.ENCHANTMENT) {
            return EnchantmentMock::from;
        }
        if (key == RegistryKey.MOB_EFFECT) {
            return MockPotionEffectType::from;
        }
        if (key == RegistryKey.DAMAGE_TYPE) {
            return DamageTypeMock::from;
        }
        if (key == RegistryKey.ITEM) {
            return ItemTypeMock::from;
        }
        if (key == RegistryKey.BLOCK) {
            return BlockTypeMock::from;
        }
        if (key == RegistryKey.WOLF_VARIANT) {
            return WolfVariantMock::from;
        }
        if (key == RegistryKey.JUKEBOX_SONG) {
            return JukeboxSongMock::from;
        }
        if (key == RegistryKey.CAT_VARIANT) {
            return CatVariantMock::from;
        }
        if (key == RegistryKey.VILLAGER_PROFESSION) {
            return VillagerProfessionMock::from;
        }
        if (key == RegistryKey.VILLAGER_TYPE) {
            return VillagerTypeMock::from;
        }
        if (key == RegistryKey.FROG_VARIANT) {
            return FrogVariantMock::from;
        }
        if (key == RegistryKey.MAP_DECORATION_TYPE) {
            return MapCursorTypeMock::from;
        }
        if (key == RegistryKey.BANNER_PATTERN) {
            return PatternTypeMock::from;
        }
        throw new UnimplementedOperationException();
    }

    @Nullable
    public T get(@NotNull NamespacedKey key) {
        Preconditions.checkNotNull((Object)key);
        this.loadIfEmpty();
        return (T)((Keyed)this.keyedMap.get(key));
    }

    @NotNull
    public Stream<T> stream() {
        this.loadIfEmpty();
        return this.keyedMap.values().stream();
    }

    @NotNull
    public Iterator<T> iterator() {
        this.loadIfEmpty();
        return this.keyedMap.values().iterator();
    }

    private void loadIfEmpty() {
        if (this.keyedMap.isEmpty()) {
            for (JsonElement structureJSONElement : this.keyedData) {
                JsonObject structureJSONObject = structureJSONElement.getAsJsonObject();
                Keyed tObject = (Keyed)this.constructor.apply(structureJSONObject);
                this.keyedMap.putIfAbsent(tObject.getKey(), tObject);
            }
        }
    }
}

