/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.AsyncCatcher;
import be.seeseemelk.mockbukkit.CachedServerIconMock;
import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.MockChunkData;
import be.seeseemelk.mockbukkit.MockPlayerList;
import be.seeseemelk.mockbukkit.MockUnsafeValues;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.WorldMock;
import be.seeseemelk.mockbukkit.block.data.BlockDataMock;
import be.seeseemelk.mockbukkit.boss.BossBarMock;
import be.seeseemelk.mockbukkit.boss.KeyedBossBarMock;
import be.seeseemelk.mockbukkit.command.CommandResult;
import be.seeseemelk.mockbukkit.command.ConsoleCommandSenderMock;
import be.seeseemelk.mockbukkit.command.MessageTarget;
import be.seeseemelk.mockbukkit.command.MockCommandMap;
import be.seeseemelk.mockbukkit.configuration.ServerConfiguration;
import be.seeseemelk.mockbukkit.entity.EntityMock;
import be.seeseemelk.mockbukkit.entity.OfflinePlayerMock;
import be.seeseemelk.mockbukkit.entity.PlayerMock;
import be.seeseemelk.mockbukkit.entity.PlayerMockFactory;
import be.seeseemelk.mockbukkit.help.HelpMapMock;
import be.seeseemelk.mockbukkit.inventory.AnvilInventoryMock;
import be.seeseemelk.mockbukkit.inventory.BarrelInventoryMock;
import be.seeseemelk.mockbukkit.inventory.BeaconInventoryMock;
import be.seeseemelk.mockbukkit.inventory.BrewerInventoryMock;
import be.seeseemelk.mockbukkit.inventory.CartographyInventoryMock;
import be.seeseemelk.mockbukkit.inventory.ChestInventoryMock;
import be.seeseemelk.mockbukkit.inventory.DispenserInventoryMock;
import be.seeseemelk.mockbukkit.inventory.DropperInventoryMock;
import be.seeseemelk.mockbukkit.inventory.EnchantingInventoryMock;
import be.seeseemelk.mockbukkit.inventory.EnderChestInventoryMock;
import be.seeseemelk.mockbukkit.inventory.FurnaceInventoryMock;
import be.seeseemelk.mockbukkit.inventory.GrindstoneInventoryMock;
import be.seeseemelk.mockbukkit.inventory.HopperInventoryMock;
import be.seeseemelk.mockbukkit.inventory.InventoryMock;
import be.seeseemelk.mockbukkit.inventory.ItemFactoryMock;
import be.seeseemelk.mockbukkit.inventory.LecternInventoryMock;
import be.seeseemelk.mockbukkit.inventory.LoomInventoryMock;
import be.seeseemelk.mockbukkit.inventory.PlayerInventoryMock;
import be.seeseemelk.mockbukkit.inventory.ShulkerBoxInventoryMock;
import be.seeseemelk.mockbukkit.inventory.SmithingInventoryMock;
import be.seeseemelk.mockbukkit.inventory.StonecutterInventoryMock;
import be.seeseemelk.mockbukkit.inventory.WorkbenchInventoryMock;
import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import be.seeseemelk.mockbukkit.map.MapViewMock;
import be.seeseemelk.mockbukkit.plugin.PluginManagerMock;
import be.seeseemelk.mockbukkit.profile.PlayerProfileMock;
import be.seeseemelk.mockbukkit.scheduler.BukkitSchedulerMock;
import be.seeseemelk.mockbukkit.scheduler.paper.FoliaAsyncScheduler;
import be.seeseemelk.mockbukkit.scoreboard.CriteriaMock;
import be.seeseemelk.mockbukkit.scoreboard.ScoreboardManagerMock;
import be.seeseemelk.mockbukkit.services.ServicesManagerMock;
import be.seeseemelk.mockbukkit.tags.TagRegistry;
import be.seeseemelk.mockbukkit.tags.TagWrapperMock;
import be.seeseemelk.mockbukkit.tags.TagsMock;
import be.seeseemelk.mockbukkit.tags.internal.InternalTag;
import com.destroystokyo.paper.entity.ai.MobGoals;
import com.destroystokyo.paper.event.player.PlayerConnectionCloseEvent;
import com.destroystokyo.paper.event.server.WhitelistToggleEvent;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.base.Preconditions;
import io.papermc.paper.ban.BanListType;
import io.papermc.paper.datapack.DatapackManager;
import io.papermc.paper.math.Position;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.Server;
import org.bukkit.ServerLinks;
import org.bukkit.ServerTickManager;
import org.bukkit.StructureType;
import org.bukkit.Tag;
import org.bukkit.Warning;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldCreator;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityFactory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemCraftResult;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;
import org.bukkit.packs.DataPackManager;
import org.bukkit.packs.ResourcePack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.PotionBrewer;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.structure.StructureManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;

public class ServerMock
extends Server.Spigot
implements Server {
    private Component motd = Component.text((String)"A Minecraft Server");
    private static final Component NO_PERMISSION = Component.text((String)"I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", (TextColor)NamedTextColor.RED);
    private final Logger logger = Logger.getLogger("ServerMock");
    private final Thread mainThread = Thread.currentThread();
    private final MockUnsafeValues unsafe = new MockUnsafeValues();
    private final Map<String, TagRegistry> materialTags = new HashMap<String, TagRegistry>();
    private final Set<EntityMock> entities = new HashSet<EntityMock>();
    private final List<World> worlds = new ArrayList<World>();
    private final List<Recipe> recipes = new LinkedList<Recipe>();
    private final Map<NamespacedKey, KeyedBossBarMock> bossBars = new HashMap<NamespacedKey, KeyedBossBarMock>();
    private final ItemFactoryMock factory = new ItemFactoryMock();
    private final PlayerMockFactory playerFactory = new PlayerMockFactory(this);
    private final PluginManagerMock pluginManager = new PluginManagerMock(this);
    private final ScoreboardManagerMock scoreboardManager = new ScoreboardManagerMock();
    private final Map<String, Criteria> criteria = new HashMap<String, Criteria>();
    private final BukkitSchedulerMock scheduler = new BukkitSchedulerMock();
    private final FoliaAsyncScheduler foliaAsyncScheduler = new FoliaAsyncScheduler(this.scheduler);
    private final ServicesManagerMock servicesManager = new ServicesManagerMock();
    private final MockPlayerList playerList = new MockPlayerList();
    private final MockCommandMap commandMap = new MockCommandMap(this, new HashMap<String, Command>());
    private final HelpMapMock helpMap = new HelpMapMock();
    private final StandardMessenger messenger = new StandardMessenger();
    private final Map<Integer, MapViewMock> mapViews = new HashMap<Integer, MapViewMock>();
    private CachedServerIconMock serverIcon = new CachedServerIconMock(null);
    private int nextMapId = 1;
    private GameMode defaultGameMode = GameMode.SURVIVAL;
    private ConsoleCommandSenderMock consoleSender;
    private int spawnRadius = 16;
    @NotNull
    private Warning.WarningState warningState = Warning.WarningState.DEFAULT;
    private boolean isWhitelistEnabled = false;
    private boolean isWhitelistEnforced = false;
    @NotNull
    private final Set<OfflinePlayer> whitelistedPlayers = new LinkedHashSet<OfflinePlayer>();
    @NotNull
    private final ServerConfiguration serverConfiguration = new ServerConfiguration();

    public ServerMock() {
        ServerMock.registerSerializables();
        TagsMock.loadDefaultTags(this, true);
        InternalTag.loadInternalTags();
        try {
            InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("logger.properties");
            LogManager.getLogManager().readConfiguration(stream);
        }
        catch (IOException e) {
            this.logger.warning("Could not load file logger.properties");
        }
        this.logger.setLevel(Level.ALL);
    }

    public boolean isOnMainThread() {
        return this.mainThread.equals(Thread.currentThread());
    }

    public void registerEntity(@NotNull EntityMock entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null");
        AsyncCatcher.catchOp("entity add");
        this.entities.add(entity);
    }

    public void unregisterEntity(@NotNull EntityMock entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null");
        Preconditions.checkArgument((!entity.isValid() ? 1 : 0) != 0, (Object)"Entity is not marked for removal");
        AsyncCatcher.catchOp("entity remove");
        this.entities.remove(entity);
    }

    @NotNull
    public Set<EntityMock> getEntities() {
        return Collections.unmodifiableSet(this.entities);
    }

    public void addPlayer(@NotNull PlayerMock player) {
        AsyncCatcher.catchOp("player add");
        this.playerList.addPlayer(player);
        CountDownLatch conditionLatch = new CountDownLatch(1);
        InetSocketAddress address = player.getAddress();
        AsyncPlayerPreLoginEvent preLoginEvent = new AsyncPlayerPreLoginEvent(player.getName(), address.getAddress(), player.getUniqueId());
        this.getPluginManager().callEventAsynchronously(preLoginEvent, e -> conditionLatch.countDown());
        try {
            conditionLatch.await();
        }
        catch (InterruptedException e2) {
            this.getLogger().severe("Interrupted while waiting for AsyncPlayerPreLoginEvent! " + (StringUtils.isEmpty((CharSequence)e2.getMessage()) ? "" : e2.getMessage()));
            Thread.currentThread().interrupt();
        }
        PlayerLoginEvent playerLoginEvent = new PlayerLoginEvent((Player)player, address.getHostString(), address.getAddress());
        Bukkit.getPluginManager().callEvent((Event)playerLoginEvent);
        Component joinMessage = MiniMessage.miniMessage().deserialize("<name> has joined the Server!", (TagResolver)Placeholder.component((String)"name", (ComponentLike)player.displayName()));
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent((Player)player, joinMessage);
        Bukkit.getPluginManager().callEvent((Event)playerJoinEvent);
        if (this.isWhitelistEnabled && !this.whitelistedPlayers.contains(player)) {
            PlayerConnectionCloseEvent playerConnectionCloseEvent = new PlayerConnectionCloseEvent(player.getUniqueId(), player.getName(), player.getAddress().getAddress(), false);
            this.getPluginManager().callEvent((Event)playerConnectionCloseEvent);
            this.playerList.disconnectPlayer(player);
            return;
        }
        PlayerSpawnLocationEvent playerSpawnLocationEvent = new PlayerSpawnLocationEvent((Player)player, player.getLocation());
        this.getPluginManager().callEvent((Event)playerSpawnLocationEvent);
        player.setLocation(playerSpawnLocationEvent.getSpawnLocation());
        this.registerEntity(player);
    }

    @NotNull
    public PlayerMock addPlayer() {
        AsyncCatcher.catchOp("player add");
        PlayerMock player = this.playerFactory.createRandomPlayer();
        this.addPlayer(player);
        return player;
    }

    @NotNull
    public PlayerMock addPlayer(@NotNull String name) {
        AsyncCatcher.catchOp("player add");
        PlayerMock player = new PlayerMock(this, name, UUID.randomUUID());
        this.addPlayer(player);
        return player;
    }

    public void setPlayers(int num) {
        AsyncCatcher.catchOp("set players");
        this.playerList.clearOnlinePlayers();
        for (int i = 0; i < num; ++i) {
            this.addPlayer();
        }
    }

    public void setOfflinePlayers(int num) {
        AsyncCatcher.catchOp("set offline players");
        this.playerList.clearOfflinePlayers();
        for (PlayerMock playerMock : this.getOnlinePlayers()) {
            this.playerList.addPlayer(playerMock);
        }
        for (int i = 0; i < num; ++i) {
            OfflinePlayerMock offlinePlayerMock = this.playerFactory.createRandomOfflinePlayer();
            this.playerList.addOfflinePlayer(offlinePlayerMock);
        }
    }

    @NotNull
    public PlayerMock getPlayer(int num) {
        return this.playerList.getPlayer(num);
    }

    @NotNull
    public MockPlayerList getPlayerList() {
        return this.playerList;
    }

    @Nullable
    public UUID getPlayerUniqueId(@NotNull String playerName) {
        return this.playerList.getOfflinePlayer(playerName).getUniqueId();
    }

    @NotNull
    public WorldMock addSimpleWorld(String name) {
        AsyncCatcher.catchOp("world creation");
        WorldMock world = new WorldMock();
        world.setName(name);
        this.worlds.add(world);
        return world;
    }

    public void addWorld(WorldMock world) {
        AsyncCatcher.catchOp("world add");
        this.worlds.add(world);
    }

    public boolean removeWorld(WorldMock world) {
        AsyncCatcher.catchOp("world remove");
        return this.worlds.remove(world);
    }

    @NotNull
    public CommandResult executeConsole(@NotNull Command command, String ... args) {
        return this.execute(command, (CommandSender)this.getConsoleSender(), args);
    }

    @NotNull
    public CommandResult executeConsole(@NotNull String command, String ... args) {
        return this.executeConsole(this.getCommandMap().getCommand(command), args);
    }

    @NotNull
    public CommandResult executePlayer(@NotNull Command command, String ... args) {
        AsyncCatcher.catchOp("command dispatch");
        if (this.playerList.isSomeoneOnline()) {
            return this.execute(command, (CommandSender)this.getPlayer(0), args);
        }
        throw new IllegalStateException("Need at least one player to run the command");
    }

    @NotNull
    public CommandResult executePlayer(@NotNull String command, String ... args) {
        return this.executePlayer(this.getCommandMap().getCommand(command), args);
    }

    @NotNull
    public CommandResult execute(@NotNull Command command, CommandSender sender, String ... args) {
        AsyncCatcher.catchOp("command dispatch");
        if (!(sender instanceof MessageTarget)) {
            throw new IllegalArgumentException("Only a MessageTarget can be the sender of the command");
        }
        boolean status = command.execute(sender, command.getName(), args);
        return new CommandResult(status, (MessageTarget)sender);
    }

    @NotNull
    public CommandResult execute(@NotNull String command, CommandSender sender, String ... args) {
        AsyncCatcher.catchOp("command dispatch");
        return this.execute(this.getCommandMap().getCommand(command), sender, args);
    }

    @NotNull
    public String getName() {
        return "ServerMock";
    }

    @NotNull
    public String getVersion() {
        return String.format("MockBukkit (MC: %s)", this.getMinecraftVersion());
    }

    @NotNull
    public String getBukkitVersion() {
        return "1.21-R0.1-SNAPSHOT";
    }

    @NotNull
    public String getMinecraftVersion() {
        return this.getBukkitVersion().split("-")[0];
    }

    @NotNull
    public Collection<? extends PlayerMock> getOnlinePlayers() {
        return this.playerList.getOnlinePlayers();
    }

    public OfflinePlayer @NotNull [] getOfflinePlayers() {
        return this.playerList.getOfflinePlayers();
    }

    @Nullable
    public OfflinePlayer getOfflinePlayerIfCached(@NotNull String name) {
        return this.playerList.getOfflinePlayerIfCached(name);
    }

    public Player getPlayer(@NotNull String name) {
        return this.playerList.getPlayer(name);
    }

    public Player getPlayerExact(@NotNull String name) {
        return this.playerList.getPlayerExact(name);
    }

    @NotNull
    public List<Player> matchPlayer(@NotNull String name) {
        return this.playerList.matchPlayer(name);
    }

    public Player getPlayer(@NotNull UUID id) {
        return this.playerList.getPlayer(id);
    }

    @NotNull
    public PluginManagerMock getPluginManager() {
        return this.pluginManager;
    }

    @NotNull
    public MockCommandMap getCommandMap() {
        return this.commandMap;
    }

    public PluginCommand getPluginCommand(@NotNull String name) {
        Command command = this.getCommandMap().getCommand(name);
        return command instanceof PluginCommand ? (PluginCommand)command : null;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public ConsoleCommandSenderMock getConsoleSender() {
        if (this.consoleSender == null) {
            this.consoleSender = new ConsoleCommandSenderMock();
        }
        return this.consoleSender;
    }

    @NotNull
    public CommandSender createCommandSender(@NotNull Consumer<? super Component> feedback) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public InventoryMock createInventory(InventoryHolder owner, @NotNull InventoryType type, String title, int size) {
        Preconditions.checkArgument((boolean)type.isCreatable(), (Object)("Inventory Type '" + String.valueOf(type) + "' is not creatable!"));
        switch (type) {
            case CHEST: {
                return new ChestInventoryMock(owner, size > 0 ? size : 27);
            }
            case DISPENSER: {
                return new DispenserInventoryMock(owner);
            }
            case DROPPER: {
                return new DropperInventoryMock(owner);
            }
            case PLAYER: {
                if (owner instanceof HumanEntity) {
                    HumanEntity he = (HumanEntity)owner;
                    return new PlayerInventoryMock(he);
                }
                throw new IllegalArgumentException("Cannot create a Player Inventory for: " + String.valueOf(owner));
            }
            case ENDER_CHEST: {
                return new EnderChestInventoryMock(owner);
            }
            case HOPPER: {
                return new HopperInventoryMock(owner);
            }
            case SHULKER_BOX: {
                return new ShulkerBoxInventoryMock(owner);
            }
            case BARREL: {
                return new BarrelInventoryMock(owner);
            }
            case LECTERN: {
                return new LecternInventoryMock(owner);
            }
            case GRINDSTONE: {
                return new GrindstoneInventoryMock(owner);
            }
            case STONECUTTER: {
                return new StonecutterInventoryMock(owner);
            }
            case CARTOGRAPHY: {
                return new CartographyInventoryMock(owner);
            }
            case SMOKER: 
            case FURNACE: 
            case BLAST_FURNACE: {
                return new FurnaceInventoryMock(owner);
            }
            case LOOM: {
                return new LoomInventoryMock(owner);
            }
            case ANVIL: {
                return new AnvilInventoryMock(owner);
            }
            case SMITHING: {
                return new SmithingInventoryMock(owner);
            }
            case BEACON: {
                return new BeaconInventoryMock(owner);
            }
            case WORKBENCH: {
                return new WorkbenchInventoryMock(owner);
            }
            case ENCHANTING: {
                return new EnchantingInventoryMock(owner);
            }
            case BREWING: {
                return new BrewerInventoryMock(owner);
            }
        }
        throw new UnimplementedOperationException("Inventory type not yet supported");
    }

    @NotNull
    public InventoryMock createInventory(InventoryHolder owner, @NotNull InventoryType type) {
        return this.createInventory(owner, type, "Inventory");
    }

    @NotNull
    public InventoryMock createInventory(@Nullable InventoryHolder owner, @NotNull InventoryType type, @NotNull Component title) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public InventoryMock createInventory(InventoryHolder owner, @NotNull InventoryType type, String title) {
        return this.createInventory(owner, type, title, -1);
    }

    @NotNull
    public InventoryMock createInventory(InventoryHolder owner, int size) {
        return this.createInventory(owner, size, "Inventory");
    }

    @NotNull
    public InventoryMock createInventory(@Nullable InventoryHolder owner, int size, @NotNull Component title) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public InventoryMock createInventory(InventoryHolder owner, int size, String title) {
        return this.createInventory(owner, InventoryType.CHEST, title, size);
    }

    @NotNull
    public Merchant createMerchant(@Nullable Component title) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemFactory getItemFactory() {
        return this.factory;
    }

    @NotNull
    public List<World> getWorlds() {
        return new ArrayList<World>(this.worlds);
    }

    public boolean isTickingWorlds() {
        throw new UnimplementedOperationException();
    }

    public World getWorld(String name) {
        return this.worlds.stream().filter(world -> world.getName().equals(name)).findAny().orElse(null);
    }

    public World getWorld(UUID uid) {
        return this.worlds.stream().filter(world -> world.getUID().equals(uid)).findAny().orElse(null);
    }

    @Nullable
    public World getWorld(@NotNull NamespacedKey worldKey) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public WorldBorder createWorldBorder() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BukkitSchedulerMock getScheduler() {
        return this.scheduler;
    }

    public int getMaxPlayers() {
        return this.playerList.getMaxPlayers();
    }

    public void setMaxPlayers(int maxPlayers) {
        this.playerList.setMaxPlayers(maxPlayers);
    }

    @NotNull
    public Set<String> getIPBans() {
        return this.playerList.getIPBans().getEntries().stream().map(BanEntry::getBanTarget).map(InetAddress::getHostAddress).collect(Collectors.toSet());
    }

    public void banIP(@NotNull String address) {
        this.playerList.getIPBans().addBan(address, null, null, null);
    }

    public void unbanIP(@NotNull String address) {
        this.playerList.getIPBans().pardon(address);
    }

    public void banIP(@NotNull InetAddress address) {
        Preconditions.checkNotNull((Object)address, (Object)"Address cannot be null");
        this.playerList.getIPBans().addBan(address, null, (Date)null, null);
    }

    public void unbanIP(@NotNull InetAddress address) {
        Preconditions.checkNotNull((Object)address, (Object)"Address cannot be null");
        this.playerList.getIPBans().pardon(address);
    }

    @NotNull
    public BanList getBanList(@NotNull BanList.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case BanList.Type.IP -> this.playerList.getIPBans();
            case BanList.Type.NAME, BanList.Type.PROFILE -> this.playerList.getProfileBans();
        };
    }

    @NotNull
    public Set<OfflinePlayer> getOperators() {
        return this.playerList.getOperators();
    }

    @NotNull
    public GameMode getDefaultGameMode() {
        return this.defaultGameMode;
    }

    public void setDefaultGameMode(GameMode mode) {
        this.defaultGameMode = mode;
    }

    @Deprecated
    public int broadcastMessage(@NotNull String message) {
        Collection<? extends PlayerMock> players = this.getOnlinePlayers();
        for (Player player : players) {
            player.sendMessage(message);
        }
        return players.size();
    }

    @Deprecated
    public int broadcast(@NotNull String message, @NotNull String permission) {
        Collection<? extends PlayerMock> players = this.getOnlinePlayers();
        int count = 0;
        for (Player player : players) {
            if (!player.hasPermission(permission)) continue;
            player.sendMessage(message);
            ++count;
        }
        return count;
    }

    public int broadcast(@NotNull Component message) {
        Collection<? extends PlayerMock> players = this.getOnlinePlayers();
        for (Player player : players) {
            player.sendMessage(message);
        }
        return players.size();
    }

    public int broadcast(@NotNull Component message, @NotNull String permission) {
        Collection<? extends PlayerMock> players = this.getOnlinePlayers();
        int count = 0;
        for (Player player : players) {
            if (!player.hasPermission(permission)) continue;
            player.sendMessage(message);
            ++count;
        }
        return count;
    }

    public static void registerSerializables() {
        ConfigurationSerialization.registerClass(ItemMetaMock.class);
    }

    public boolean addRecipe(Recipe recipe) {
        Preconditions.checkNotNull((Object)recipe, (Object)"recipe cannot be null");
        return this.addRecipe(recipe, false);
    }

    public boolean addRecipe(@Nullable Recipe recipe, boolean resendRecipes) {
        AsyncCatcher.catchOp("Recipe add");
        if (recipe == null) {
            return false;
        }
        return this.recipes.add(recipe);
    }

    @NotNull
    public List<Recipe> getRecipesFor(@NotNull ItemStack item) {
        Preconditions.checkNotNull((Object)item, (Object)"item cannot be null");
        return this.recipes.stream().filter(recipe -> {
            ItemStack result = recipe.getResult();
            return result.getType() == item.getType() && (result.getDurability() == -1 || result.getDurability() == item.getDurability());
        }).toList();
    }

    @Nullable
    public Recipe getRecipe(@NotNull NamespacedKey key) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        for (Recipe recipe : this.recipes) {
            Keyed keyed;
            if (!(recipe instanceof Keyed) || !(keyed = (Keyed)recipe).getKey().equals((Object)key)) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public Recipe getCraftingRecipe(@NotNull ItemStack[] craftingMatrix, @NotNull World world) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemStack craftItem(@NotNull ItemStack[] craftingMatrix, @NotNull World world, @NotNull Player player) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemCraftResult craftItemResult(@NotNull ItemStack[] craftingMatrix, @NotNull World world) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemCraftResult craftItemResult(@NotNull ItemStack[] craftingMatrix, @NotNull World world, @NotNull Player player) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemStack craftItem(@NotNull ItemStack[] craftingMatrix, @NotNull World world) {
        throw new UnimplementedOperationException();
    }

    public boolean removeRecipe(@NotNull NamespacedKey key) {
        return this.removeRecipe(key, false);
    }

    public boolean removeRecipe(@NotNull NamespacedKey key, boolean resendRecipes) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        Iterator<Recipe> iterator = this.recipeIterator();
        while (iterator.hasNext()) {
            Keyed keyed;
            Recipe recipe = iterator.next();
            if (!(recipe instanceof Keyed) || !(keyed = (Keyed)recipe).getKey().equals((Object)key)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @NotNull
    public Iterator<Recipe> recipeIterator() {
        return this.recipes.iterator();
    }

    public void clearRecipes() {
        this.recipes.clear();
    }

    public boolean dispatchCommand(@NotNull CommandSender sender, @NotNull String commandLine) {
        AsyncCatcher.catchOp("command dispatch");
        String[] commands = commandLine.split(" ");
        String commandLabel = commands[0];
        String[] args = Arrays.copyOfRange(commands, 1, commands.length);
        Command command = this.getCommandMap().getCommand(commandLabel);
        if (command != null) {
            return command.execute(sender, commandLabel, args);
        }
        return false;
    }

    @NotNull
    public List<String> getCommandTabComplete(@NotNull CommandSender sender, @NotNull String commandLine) {
        AsyncCatcher.catchOp("command tabcomplete");
        int idx = commandLine.indexOf(32);
        String commandLabel = commandLine.substring(0, idx);
        String[] args = commandLine.substring(idx + 1).split(" ", -1);
        Command command = this.getCommandMap().getCommand(commandLabel);
        if (command != null) {
            return command.tabComplete(sender, commandLabel, args);
        }
        return Collections.emptyList();
    }

    @NotNull
    public HelpMapMock getHelpMap() {
        return this.helpMap;
    }

    public void sendPluginMessage(@NotNull Plugin source, @NotNull String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)this.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        for (Player player : this.getOnlinePlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    @NotNull
    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (Player player : this.getOnlinePlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    public int getPort() {
        return this.serverConfiguration.getServerPort();
    }

    public void setPort(int port) {
        this.serverConfiguration.setServerPort(port);
    }

    public int getViewDistance() {
        return this.serverConfiguration.getViewDistance();
    }

    public void setViewDistance(int viewDistance) {
        this.serverConfiguration.setViewDistance(viewDistance);
    }

    @NotNull
    public String getIp() {
        return this.serverConfiguration.getServerIp();
    }

    public void setIp(@NotNull String serverIp) {
        this.serverConfiguration.setServerIp(serverIp);
    }

    @NotNull
    public String getWorldType() {
        return this.serverConfiguration.getLevelType().getKey();
    }

    public void setWorldType(@NotNull ServerConfiguration.LevelType worldType) {
        this.serverConfiguration.setLevelType(worldType);
    }

    public boolean getGenerateStructures() {
        return this.serverConfiguration.isGenerateStructures();
    }

    public void setGenerateStructures(boolean generateStructures) {
        this.serverConfiguration.setGenerateStructures(generateStructures);
    }

    public boolean getAllowEnd() {
        return this.serverConfiguration.isAllowEnd();
    }

    public void setAllowEnd(boolean allowEnd) {
        this.serverConfiguration.setAllowEnd(allowEnd);
    }

    public boolean getAllowNether() {
        return this.serverConfiguration.isAllowNether();
    }

    public boolean isLoggingIPs() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public List<String> getInitialEnabledPacks() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public List<String> getInitialDisabledPacks() {
        throw new UnimplementedOperationException();
    }

    @Deprecated(since="1.19")
    @NotNull
    public DataPackManager getDataPackManager() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ServerTickManager getServerTickManager() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public ResourcePack getServerResourcePack() {
        throw new UnimplementedOperationException();
    }

    public void setAllowNether(boolean allowNether) {
        this.serverConfiguration.setAllowNether(allowNether);
    }

    @NotNull
    public String getResourcePack() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public String getResourcePackHash() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public String getResourcePackPrompt() {
        throw new UnimplementedOperationException();
    }

    public boolean isResourcePackRequired() {
        throw new UnimplementedOperationException();
    }

    public boolean hasWhitelist() {
        return this.isWhitelistEnabled;
    }

    public void setWhitelist(boolean value) {
        this.isWhitelistEnabled = value;
        WhitelistToggleEvent event = new WhitelistToggleEvent(value);
        this.getPluginManager().callEvent((Event)event);
    }

    public boolean isWhitelistEnforced() {
        return this.isWhitelistEnforced;
    }

    public void setWhitelistEnforced(boolean value) {
        this.isWhitelistEnforced = value;
    }

    @NotNull
    public Set<OfflinePlayer> getWhitelistedPlayers() {
        return this.whitelistedPlayers;
    }

    public void reloadWhitelist() {
        if (!this.isWhitelistEnforced && this.isWhitelistEnabled) {
            return;
        }
        MockBukkit.getMock().getOnlinePlayers().forEach(p -> {
            if (!MockBukkit.getMock().getWhitelistedPlayers().contains(p)) {
                p.kick();
            }
        });
    }

    @NotNull
    public String getUpdateFolder() {
        return this.serverConfiguration.getUpdateFolder();
    }

    public void setUpdateFolder(@NotNull String updateFolder) {
        this.serverConfiguration.setUpdateFolder(updateFolder);
    }

    @NotNull
    public File getUpdateFolderFile() {
        return new File(this.getPluginsFolder(), this.getUpdateFolder());
    }

    public long getConnectionThrottle() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public int getTicksPerAnimalSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.ANIMAL);
    }

    @Deprecated
    public int getTicksPerMonsterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.MONSTER);
    }

    @NotNull
    public ServicesManagerMock getServicesManager() {
        return this.servicesManager;
    }

    public World createWorld(@NotNull WorldCreator creator) {
        WorldMock world = new WorldMock(creator);
        this.addWorld(world);
        return world;
    }

    public boolean unloadWorld(String name, boolean save) {
        return this.unloadWorld(this.getWorld(name), save);
    }

    public boolean unloadWorld(World world, boolean save) {
        if (!(world instanceof WorldMock)) {
            return false;
        }
        WorldMock worldMock = (WorldMock)world;
        if (!worldMock.getPlayers().isEmpty()) {
            return false;
        }
        if (new WorldUnloadEvent((World)worldMock).callEvent()) {
            return false;
        }
        return this.removeWorld(worldMock);
    }

    @NotNull
    public MapViewMock createMap(@NotNull World world) {
        MapViewMock mapView = new MapViewMock(world, this.nextMapId++);
        this.mapViews.put(mapView.getId(), mapView);
        new MapInitializeEvent((MapView)mapView).callEvent();
        return mapView;
    }

    public void reload() {
        Plugin[] pluginsClone = (Plugin[])this.pluginManager.getPlugins().clone();
        this.pluginManager.clearPlugins();
        this.commandMap.clearCommands();
        for (Plugin plugin2 : pluginsClone) {
            this.getPluginManager().disablePlugin(plugin2);
            this.getWorlds().stream().map(WorldMock.class::cast).forEach(w -> w.clearMetadata(plugin2));
            this.getEntities().forEach(e -> e.clearMetadata(plugin2));
            this.getOnlinePlayers().forEach(p -> p.clearMetadata(plugin2));
        }
        for (int pollCount = 0; pollCount < 50 && this.getScheduler().getActiveWorkers().size() > 0; ++pollCount) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
        this.getScheduler().saveOverdueTasks();
        ArrayList<JavaPlugin> newPlugins = new ArrayList<JavaPlugin>(pluginsClone.length);
        for (Plugin oldPlugin : pluginsClone) {
            if (!(oldPlugin instanceof JavaPlugin)) continue;
            JavaPlugin oldJavaPlugin = (JavaPlugin)oldPlugin;
            Class<?> originalClass = oldJavaPlugin.getClass().getSuperclass();
            JavaPlugin plugin3 = this.getPluginManager().loadPlugin(originalClass, oldJavaPlugin.getDescription(), new Object[0]);
            newPlugins.add(plugin3);
        }
        newPlugins.stream().sorted(Comparator.comparing(p -> p.getDescription().getLoad())).forEach(plugin -> this.getPluginManager().enablePlugin((Plugin)plugin));
        new ServerLoadEvent(ServerLoadEvent.LoadType.RELOAD).callEvent();
    }

    public void reloadData() {
        throw new UnimplementedOperationException();
    }

    public void updateResources() {
    }

    public void updateRecipes() {
    }

    public void savePlayers() {
        throw new UnimplementedOperationException();
    }

    public void resetRecipes() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Map<String, String[]> getCommandAliases() {
        throw new UnimplementedOperationException();
    }

    public int getSpawnRadius() {
        return this.spawnRadius;
    }

    public void setSpawnRadius(int spawnRadius) {
        this.spawnRadius = spawnRadius;
    }

    @Deprecated(forRemoval=true)
    public boolean shouldSendChatPreviews() {
        return this.serverConfiguration.shouldSendChatPreviews();
    }

    @Deprecated(forRemoval=true)
    public void setShouldSendChatPreviews(boolean shouldSendChatPreviews) {
        this.serverConfiguration.setShouldSendChatPreviews(shouldSendChatPreviews);
    }

    public boolean isEnforcingSecureProfiles() {
        return this.serverConfiguration.isEnforceSecureProfiles() && this.getOnlineMode();
    }

    public void setEnforcingSecureProfiles(boolean enforcingSecureProfiles) {
        this.serverConfiguration.setEnforceSecureProfiles(enforcingSecureProfiles);
    }

    public boolean getOnlineMode() {
        return this.serverConfiguration.isOnlineMode();
    }

    public void setOnlineMode(boolean onlineMode) {
        this.serverConfiguration.setOnlineMode(onlineMode);
    }

    public boolean getAllowFlight() {
        return this.serverConfiguration.isAllowFlight();
    }

    public void setAllowFlight(boolean allowFlight) {
        this.serverConfiguration.setAllowFlight(allowFlight);
    }

    public boolean isHardcore() {
        return this.serverConfiguration.isHardcore();
    }

    public void setHardcore(boolean hardcore) {
        this.serverConfiguration.setHardcore(hardcore);
    }

    public void shutdown() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public OfflinePlayer getOfflinePlayer(@NotNull String name) {
        return this.playerList.getOfflinePlayer(name);
    }

    @NotNull
    public OfflinePlayer getOfflinePlayer(@NotNull UUID id) {
        OfflinePlayer player = this.playerList.getOfflinePlayer(id);
        if (player != null) {
            return player;
        }
        return this.playerFactory.createOfflinePlayer(id);
    }

    @NotNull
    public Set<OfflinePlayer> getBannedPlayers() {
        return this.getBanList(BanList.Type.PROFILE).getEntries().stream().map(banEntry -> ((PlayerProfile)((BanEntry)banEntry).getBanTarget()).getId()).map(uuid -> this.getOfflinePlayer((UUID)uuid)).collect(Collectors.toSet());
    }

    @NotNull
    public <B extends BanList<E>, E> B getBanList(@NotNull BanListType<B> type) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public File getWorldContainer() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Messenger getMessenger() {
        return this.messenger;
    }

    @Deprecated
    @NotNull
    public Merchant createMerchant(String title) {
        throw new UnimplementedOperationException();
    }

    public int getMaxChainedNeighborUpdates() {
        return this.serverConfiguration.getMaxChainedNeighbourUpdates();
    }

    public void setMaxChainedNeighborUpdates(int maxChainedNeighborUpdates) {
        this.serverConfiguration.setMaxChainedNeighbourUpdates(maxChainedNeighborUpdates);
    }

    @Deprecated
    public int getMonsterSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.MONSTER);
    }

    @Deprecated
    public int getAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.ANIMAL);
    }

    @Deprecated
    public int getWaterAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_ANIMAL);
    }

    @Deprecated
    public int getAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.AMBIENT);
    }

    public boolean isPrimaryThread() {
        return this.isOnMainThread();
    }

    @NotNull
    public Component motd() {
        return this.motd;
    }

    public void motd(@NotNull Component motd) {
        Preconditions.checkNotNull((Object)motd, (Object)"motd cannot be null");
        this.motd = motd;
    }

    @Deprecated
    @NotNull
    public String getMotd() {
        return LegacyComponentSerializer.legacySection().serialize(this.motd);
    }

    public void setMotd(@NotNull String motd) {
        Preconditions.checkNotNull((Object)motd, (Object)"motd cannot be null");
        this.motd = LegacyComponentSerializer.legacySection().deserialize(motd);
    }

    @NotNull
    public ServerLinks getServerLinks() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Component shutdownMessage() {
        return this.serverConfiguration.getShutdownMessage();
    }

    public void setShutdownMessage(@NotNull Component shutdownMessage) {
        this.serverConfiguration.setShutdownMessage(shutdownMessage);
    }

    @Deprecated
    public String getShutdownMessage() {
        return LegacyComponentSerializer.legacySection().serialize(this.serverConfiguration.getShutdownMessage());
    }

    public void setWarningState(@NotNull Warning.WarningState warningState) {
        Preconditions.checkNotNull((Object)warningState, (Object)"warningState cannot be null");
        this.warningState = warningState;
    }

    @NotNull
    public Warning.WarningState getWarningState() {
        return this.warningState;
    }

    @NotNull
    public ScoreboardManagerMock getScoreboardManager() {
        return this.scoreboardManager;
    }

    @NotNull
    public Criteria getScoreboardCriteria(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Scoreboard criteria name cannot be null");
        return this.criteria.computeIfAbsent(name, CriteriaMock::new);
    }

    public void setServerIcon(CachedServerIconMock serverIcon) {
        this.serverIcon = serverIcon;
    }

    public CachedServerIconMock getServerIcon() {
        return this.serverIcon;
    }

    @NotNull
    public CachedServerIconMock loadServerIcon(@NotNull File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"File cannot be null");
        Preconditions.checkArgument((boolean)file.isFile(), (Object)(String.valueOf(file) + " isn't a file"));
        return this.loadServerIcon(ImageIO.read(file));
    }

    @NotNull
    public CachedServerIconMock loadServerIcon(@NotNull BufferedImage image) throws IOException {
        Preconditions.checkNotNull((Object)image, (Object)"Image cannot be null");
        Preconditions.checkArgument((image.getWidth() == 64 ? 1 : 0) != 0, (Object)"Image must be 64 pixels wide");
        Preconditions.checkArgument((image.getHeight() == 64 ? 1 : 0) != 0, (Object)"Image must be 64 pixels high");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "PNG", out);
        String encoded = Base64.getEncoder().encodeToString(out.toByteArray());
        return new CachedServerIconMock("data:image/png;base64," + encoded);
    }

    public void setIdleTimeout(int threshold) {
        throw new UnimplementedOperationException();
    }

    public int getIdleTimeout() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ChunkGenerator.ChunkData createChunkData(@NotNull World world) {
        Preconditions.checkNotNull((Object)world, (Object)"World cannot be null");
        return new MockChunkData(world);
    }

    @NotNull
    public BossBar createBossBar(@NotNull String title, @NotNull BarColor color, @NotNull BarStyle style, BarFlag ... flags) {
        return new BossBarMock(title, color, style, flags);
    }

    @Nullable
    public Entity getEntity(@NotNull UUID uuid) {
        Preconditions.checkNotNull((Object)uuid, (Object)"uuid cannot be null");
        for (EntityMock entity : this.entities) {
            if (!entity.getUniqueId().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    @NotNull
    public double[] getTPS() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public long[] getTickTimes() {
        throw new UnimplementedOperationException();
    }

    public double getAverageTickTime() {
        throw new UnimplementedOperationException();
    }

    public Advancement getAdvancement(NamespacedKey key) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Iterator<Advancement> advancementIterator() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public MockUnsafeValues getUnsafe() {
        return this.unsafe;
    }

    @NotNull
    public BlockData createBlockData(@NotNull Material material) {
        Preconditions.checkNotNull((Object)material, (Object)"Must provide material");
        return BlockDataMock.mock(material);
    }

    @NotNull
    public BlockData createBlockData(@NotNull Material material, @Nullable Consumer<? super BlockData> consumer) {
        BlockData blockData = this.createBlockData(material);
        if (consumer != null) {
            consumer.accept((BlockData)blockData);
        }
        return blockData;
    }

    @NotNull
    public BlockData createBlockData(String data) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BlockData createBlockData(Material material, String data) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Tag<Material> createMaterialTag(@NotNull NamespacedKey key, @NotNull String registryKey, Material ... materials) {
        Preconditions.checkNotNull((Object)key, (Object)"A NamespacedKey must never be null");
        TagRegistry registry = this.materialTags.get(registryKey);
        TagWrapperMock tag = new TagWrapperMock(registry, key);
        registry.getTags().put(key, tag);
        return tag;
    }

    public void addTagRegistry(@NotNull TagRegistry registry) {
        this.materialTags.put(registry.getRegistry(), registry);
    }

    public <T extends Keyed> Tag<T> getTag(@NotNull String registryKey, @NotNull NamespacedKey key, @NotNull Class<T> clazz) {
        Tag tag;
        TagRegistry registry;
        if (clazz == Material.class && (registry = this.materialTags.get(registryKey)) != null && (tag = (Tag)registry.getTags().get(key)) != null) {
            return tag;
        }
        return null;
    }

    public LootTable getLootTable(NamespacedKey key) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemStack createExplorerMap(World world, Location location, StructureType structureType) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemStack createExplorerMap(World world, Location location, StructureType structureType, int radius, boolean findUnexplored) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public ItemStack createExplorerMap(@NotNull World world, @NotNull Location location, @NotNull org.bukkit.generator.structure.StructureType structureType, @NotNull MapCursor.Type mapIcon, int radius, boolean findUnexplored) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public KeyedBossBar createBossBar(@NotNull NamespacedKey key, @NotNull String title, @NotNull BarColor color, @NotNull BarStyle style, BarFlag ... flags) {
        Preconditions.checkNotNull((Object)key, (Object)"A NamespacedKey must never be null");
        KeyedBossBarMock bar = new KeyedBossBarMock(key, title, color, style, flags);
        this.bossBars.put(key, bar);
        return bar;
    }

    @NotNull
    public Iterator<KeyedBossBar> getBossBars() {
        return this.bossBars.values().stream().map(bossbar -> bossbar).iterator();
    }

    public KeyedBossBar getBossBar(NamespacedKey key) {
        Preconditions.checkNotNull((Object)key, (Object)"A NamespacedKey must never be null");
        return this.bossBars.get(key);
    }

    public boolean removeBossBar(NamespacedKey key) {
        Preconditions.checkNotNull((Object)key, (Object)"A NamespacedKey must never be null");
        return this.bossBars.remove(key, this.bossBars.get(key));
    }

    @NotNull
    public List<Entity> selectEntities(CommandSender sender, String selector) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public StructureManager getStructureManager() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public <T extends Keyed> Registry<T> getRegistry(@NotNull Class<T> tClass) {
        return RegistryAccess.registryAccess().getRegistry(tClass);
    }

    @Deprecated
    public MapViewMock getMap(int id) {
        return this.mapViews.get(id);
    }

    @NotNull
    public <T extends Keyed> Iterable<Tag<T>> getTags(@NotNull String registry, @NotNull Class<T> clazz) {
        TagRegistry tagRegistry;
        if (clazz == Material.class && (tagRegistry = this.materialTags.get(registry)) != null) {
            return tagRegistry.getTags().values().stream().map(tagWrapperMock -> tagWrapperMock).toList();
        }
        throw new IllegalArgumentException();
    }

    @Deprecated
    public int getTicksPerWaterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_ANIMAL);
    }

    @Deprecated
    public int getTicksPerAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.AMBIENT);
    }

    protected long getCurrentServerTime() {
        return System.currentTimeMillis();
    }

    public int getTicksPerWaterAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_AMBIENT);
    }

    @Deprecated
    public int getTicksPerWaterUndergroundCreatureSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Deprecated
    public int getWaterAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_AMBIENT);
    }

    @Deprecated
    public int getWaterUndergroundCreatureSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    public int getMaxWorldSize() {
        return this.serverConfiguration.getMaxWorldSize();
    }

    public void setMaxWorldSize(int maxWorldSize) {
        this.serverConfiguration.setMaxWorldSize(maxWorldSize);
    }

    public int getSimulationDistance() {
        return this.serverConfiguration.getSimulationDistance();
    }

    public void setSimulationDistance(int simulationDistance) {
        this.serverConfiguration.setSimulationDistance(simulationDistance);
    }

    public boolean getHideOnlinePlayers() {
        return this.serverConfiguration.isHideOnlinePlayers();
    }

    public void setHideOnlinePlayers(boolean hideOnlinePlayers) {
        this.serverConfiguration.setHideOnlinePlayers(hideOnlinePlayers);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Server.Spigot spigot() {
        return this;
    }

    public void reloadPermissions() {
        throw new UnimplementedOperationException();
    }

    public boolean reloadCommandAliases() {
        throw new UnimplementedOperationException();
    }

    public boolean suggestPlayerNamesWhenNullTabCompletions() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public String getPermissionMessage() {
        return this.unsafe.legacyComponentSerializer().serialize(NO_PERMISSION);
    }

    @NotNull
    public Component permissionMessage() {
        return NO_PERMISSION;
    }

    @NotNull
    public PlayerProfileMock createProfile(@NotNull UUID uuid) {
        return this.createProfile(uuid, null);
    }

    @NotNull
    public PlayerProfileMock createProfile(@NotNull String name) {
        return this.createProfile(null, name);
    }

    @NotNull
    public PlayerProfileMock createProfile(@Nullable UUID uuid, @Nullable String name) {
        return new PlayerProfileMock(name, uuid);
    }

    @NotNull
    public PlayerProfileMock createProfileExact(@Nullable UUID uuid, @Nullable String name) {
        return new PlayerProfileMock(name, uuid);
    }

    public int getCurrentTick() {
        return (int)this.getScheduler().getCurrentTick();
    }

    public boolean isStopping() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public MobGoals getMobGoals() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public DatapackManager getDatapackManager() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public YamlConfiguration getConfig() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void broadcast(@NotNull BaseComponent component) {
        for (Player player : this.getOnlinePlayers()) {
            player.spigot().sendMessage(component);
        }
    }

    @Deprecated
    public void broadcast(BaseComponent ... components) {
        for (Player player : this.getOnlinePlayers()) {
            player.spigot().sendMessage(components);
        }
    }

    public void restart() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public int getTicksPerSpawns(@NotNull SpawnCategory spawnCategory) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((spawnCategory != SpawnCategory.MISC ? 1 : 0) != 0, (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        return (int)this.serverConfiguration.getTicksPerSpawn().getLong((Object)spawnCategory);
    }

    @Deprecated
    @NotNull
    public PlayerProfileMock createPlayerProfile(@Nullable UUID uniqueId, @Nullable String name) {
        return new PlayerProfileMock(name, uniqueId);
    }

    @Deprecated
    @NotNull
    public PlayerProfileMock createPlayerProfile(@NotNull UUID uniqueId) {
        return this.createPlayerProfile(uniqueId, null);
    }

    @Deprecated
    @NotNull
    public PlayerProfileMock createPlayerProfile(@NotNull String name) {
        return this.createPlayerProfile(null, name);
    }

    public int getSpawnLimit(@NotNull SpawnCategory spawnCategory) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((spawnCategory != SpawnCategory.MISC ? 1 : 0) != 0, (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        return this.serverConfiguration.getSpawnLimits().getOrDefault((Object)spawnCategory, -1);
    }

    @NotNull
    public PotionBrewer getPotionBrewer() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public RegionScheduler getRegionScheduler() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public AsyncScheduler getAsyncScheduler() {
        return this.foliaAsyncScheduler;
    }

    @NotNull
    public GlobalRegionScheduler getGlobalRegionScheduler() {
        throw new UnimplementedOperationException();
    }

    public boolean isOwnedByCurrentRegion(@NotNull World world, @NotNull Position position) {
        throw new UnimplementedOperationException();
    }

    public boolean isOwnedByCurrentRegion(@NotNull World world, @NotNull Position position, int squareRadiusChunks) {
        throw new UnimplementedOperationException();
    }

    public boolean isOwnedByCurrentRegion(@NotNull Location location) {
        throw new UnimplementedOperationException();
    }

    public boolean isOwnedByCurrentRegion(@NotNull Location location, int squareRadiusChunks) {
        throw new UnimplementedOperationException();
    }

    public boolean isOwnedByCurrentRegion(@NotNull World world, int chunkX, int chunkZ) {
        throw new UnimplementedOperationException();
    }

    public boolean isOwnedByCurrentRegion(@NotNull World world, int chunkX, int chunkZ, int squareRadiusChunks) {
        throw new UnimplementedOperationException();
    }

    public boolean isOwnedByCurrentRegion(@NotNull Entity entity) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public File getPluginsFolder() {
        try {
            return this.getPluginManager().getParentTemporaryDirectory();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isAcceptingTransfers() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public EntityFactory getEntityFactory() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Iterable<? extends Audience> audiences() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }
}

