/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.ban;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.util.Date;
import org.bukkit.BanEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockIpBanEntry
implements BanEntry<InetAddress> {
    private final String target;
    private String source;
    private String reason;
    private Date created;
    private Date expires;

    public MockIpBanEntry(@NotNull String target, @Nullable String reason, @Nullable Date expires, @Nullable String source) {
        this.target = target;
        this.source = source;
        this.reason = reason;
        this.created = new Date();
        this.expires = expires;
    }

    @Deprecated(since="1.20")
    @NotNull
    public String getTarget() {
        return this.target;
    }

    @NotNull
    public InetAddress getBanTarget() {
        return InetAddresses.forString((String)this.target);
    }

    @NotNull
    public Date getCreated() {
        return this.created;
    }

    public void setCreated(@NotNull Date created) {
        Preconditions.checkNotNull((Object)created, (Object)"Created date cannot be null");
        this.created = created;
    }

    @NotNull
    public String getSource() {
        return this.source;
    }

    public void setSource(@NotNull String source) {
        Preconditions.checkNotNull((Object)source, (Object)"Source cannot be null");
        this.source = source;
    }

    @Nullable
    public Date getExpiration() {
        return this.expires;
    }

    public void setExpiration(@Nullable Date expiration) {
        this.expires = expiration;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    public void setReason(@Nullable String reason) {
        this.reason = reason;
    }

    public void save() {
        throw new UnimplementedOperationException();
    }

    public void remove() {
        throw new UnimplementedOperationException();
    }
}

