/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.ban;

import be.seeseemelk.mockbukkit.ban.MockBukkitProfileBanEntry;
import be.seeseemelk.mockbukkit.ban.MockPaperProfileBanEntry;
import be.seeseemelk.mockbukkit.profile.PlayerProfileMock;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.BanEntry;
import org.bukkit.Bukkit;
import org.bukkit.ban.ProfileBanList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockProfileBanList
implements ProfileBanList {
    private final Map<String, BanEntry<PlayerProfile>> bans = new HashMap<String, BanEntry<PlayerProfile>>();
    private static final String TARGET_CANNOT_BE_NULL = "Target cannot be null";

    @Deprecated(since="1.20")
    @Nullable
    public BanEntry<PlayerProfile> getBanEntry(@NotNull String target) {
        Preconditions.checkNotNull((Object)target, (Object)TARGET_CANNOT_BE_NULL);
        return this.bans.getOrDefault(target, null);
    }

    @Nullable
    public BanEntry<PlayerProfile> getBanEntry(@NotNull PlayerProfile target) {
        Preconditions.checkNotNull((Object)target, (Object)TARGET_CANNOT_BE_NULL);
        return this.bans.getOrDefault(target.getName(), null);
    }

    @Deprecated(since="1.20")
    @Nullable
    public BanEntry<PlayerProfile> addBan(@NotNull String target, @Nullable String reason, @Nullable Date expires, @Nullable String source) {
        PlayerProfileMock profile = new PlayerProfileMock(target, Bukkit.getOfflinePlayer((String)target).getUniqueId());
        return this.addBan((PlayerProfile)profile, reason, expires, source);
    }

    @Deprecated(since="1.20")
    @Nullable
    public <E extends BanEntry<? super PlayerProfile>> E addBan(@NotNull org.bukkit.profile.PlayerProfile target, @Nullable String reason, @Nullable Date expires, @Nullable String source) {
        Preconditions.checkNotNull((Object)target, (Object)TARGET_CANNOT_BE_NULL);
        PlayerProfile profile = Bukkit.createProfile((UUID)target.getUniqueId(), (String)target.getName());
        BanEntry<PlayerProfile> entry = this.addBan(profile, reason, expires, source);
        return (E)new MockBukkitProfileBanEntry(Bukkit.createPlayerProfile((UUID)profile.getUniqueId(), (String)profile.getName()), entry.getSource(), entry.getExpiration(), entry.getReason());
    }

    @Nullable
    public BanEntry<PlayerProfile> addBan(@NotNull PlayerProfile target, @Nullable String reason, @Nullable Date expires, @Nullable String source) {
        Preconditions.checkNotNull((Object)target, (Object)TARGET_CANNOT_BE_NULL);
        MockPaperProfileBanEntry entry = new MockPaperProfileBanEntry(target, source == null || source.isBlank() ? null : source, expires, reason == null || reason.isBlank() ? null : reason);
        this.bans.put(target.getName(), entry);
        return entry;
    }

    @Nullable
    public BanEntry<PlayerProfile> addBan(@NotNull PlayerProfile target, @Nullable String reason, @Nullable Instant expires, @Nullable String source) {
        Date date = expires != null ? Date.from(expires) : null;
        return this.addBan(target, reason, date, source);
    }

    @Nullable
    public BanEntry<PlayerProfile> addBan(@NotNull PlayerProfile target, @Nullable String reason, @Nullable Duration duration, @Nullable String source) {
        Instant instant = duration != null ? Instant.now().plus(duration) : null;
        return this.addBan(target, reason, instant, source);
    }

    @Deprecated(since="1.20")
    @Nullable
    public <E extends BanEntry<? super PlayerProfile>> E getBanEntry(@NotNull org.bukkit.profile.PlayerProfile target) {
        Preconditions.checkNotNull((Object)target, (Object)TARGET_CANNOT_BE_NULL);
        PlayerProfile profile = Bukkit.createProfile((UUID)target.getUniqueId(), (String)target.getName());
        return (E)this.getBanEntry(profile);
    }

    @Deprecated(since="1.20")
    public boolean isBanned(@NotNull org.bukkit.profile.PlayerProfile target) {
        Preconditions.checkNotNull((Object)target, (Object)TARGET_CANNOT_BE_NULL);
        PlayerProfile profile = Bukkit.createProfile((UUID)target.getUniqueId(), (String)target.getName());
        return this.isBanned(profile);
    }

    @Deprecated(since="1.20")
    public void pardon(@NotNull org.bukkit.profile.PlayerProfile target) {
        Preconditions.checkNotNull((Object)target, (Object)TARGET_CANNOT_BE_NULL);
        PlayerProfile profile = Bukkit.createProfile((UUID)target.getUniqueId(), (String)target.getName());
        this.pardon(profile);
    }

    @Nullable
    public <E extends BanEntry<? super PlayerProfile>> E addBan(@NotNull org.bukkit.profile.PlayerProfile target, @Nullable String reason, @Nullable Instant expires, @Nullable String source) {
        Date date = expires != null ? Date.from(expires) : null;
        return this.addBan(target, reason, date, source);
    }

    @Nullable
    public <E extends BanEntry<? super PlayerProfile>> E addBan(@NotNull org.bukkit.profile.PlayerProfile target, @Nullable String reason, @Nullable Duration duration, @Nullable String source) {
        Instant instant = duration != null ? Instant.now().plus(duration) : null;
        return this.addBan(target, reason, instant, source);
    }

    @Deprecated(since="1.20")
    @NotNull
    public Set<BanEntry> getBanEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (BanEntry<PlayerProfile> ban : this.bans.values()) {
            builder.add(ban);
        }
        return builder.build();
    }

    @NotNull
    public Set<BanEntry<PlayerProfile>> getEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (BanEntry<PlayerProfile> ban : this.bans.values()) {
            builder.add(ban);
        }
        return builder.build();
    }

    public boolean isBanned(@NotNull PlayerProfile target) {
        return this.bans.values().stream().anyMatch(banEntry -> ((PlayerProfile)banEntry.getBanTarget()).equals((Object)target));
    }

    public boolean isBanned(@NotNull String target) {
        return this.bans.values().stream().anyMatch(banEntry -> Objects.equals(((PlayerProfile)banEntry.getBanTarget()).getName(), target));
    }

    public void pardon(@NotNull PlayerProfile target) {
        Preconditions.checkNotNull((Object)target, (Object)TARGET_CANNOT_BE_NULL);
        this.bans.remove(target.getName());
    }

    public void pardon(@NotNull String target) {
        Preconditions.checkNotNull((Object)target, (Object)TARGET_CANNOT_BE_NULL);
        this.bans.remove(target);
    }
}

