/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.data;

import be.seeseemelk.mockbukkit.block.data.BlockDataMock;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.AmethystCluster;
import org.jetbrains.annotations.NotNull;

public class AmethystClusterMock
extends BlockDataMock
implements AmethystCluster {
    public AmethystClusterMock(@NotNull Material type) {
        super(type);
        this.checkType(type, Material.AMETHYST_CLUSTER);
        this.setFacing(BlockFace.NORTH);
        this.setWaterlogged(false);
    }

    @NotNull
    public BlockFace getFacing() {
        return (BlockFace)super.get("facing");
    }

    public void setFacing(@NotNull BlockFace facing) {
        Preconditions.checkNotNull((Object)facing, (Object)"Facing cannot be null");
        Preconditions.checkArgument((boolean)this.getFaces().contains(facing), (Object)("Invalid face. Must be one of " + String.valueOf(this.getFaces())));
        super.set("facing", facing);
    }

    @NotNull
    public Set<BlockFace> getFaces() {
        return Set.of(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN);
    }

    public boolean isWaterlogged() {
        return (Boolean)super.get("waterlogged");
    }

    public void setWaterlogged(boolean waterlogged) {
        super.set("waterlogged", waterlogged);
    }
}

