/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.data;

import be.seeseemelk.mockbukkit.block.data.BlockDataMock;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Campfire;
import org.jetbrains.annotations.NotNull;

public class CampfireMock
extends BlockDataMock
implements Campfire {
    public CampfireMock(@NotNull Material type) {
        super(type);
        this.checkType(type, (Tag<Material>)Tag.CAMPFIRES);
        this.setFacing(BlockFace.NORTH);
        this.setLit(true);
        this.setSignalFire(false);
        this.setWaterlogged(false);
    }

    @NotNull
    public BlockFace getFacing() {
        return (BlockFace)super.get("facing");
    }

    public void setFacing(@NotNull BlockFace facing) {
        Preconditions.checkNotNull((Object)facing, (Object)"Facing cannot be null");
        Preconditions.checkArgument((boolean)this.getFaces().contains(facing), (Object)("Invalid face. Must be one of " + String.valueOf(this.getFaces())));
        super.set("facing", facing);
    }

    @NotNull
    public Set<BlockFace> getFaces() {
        return Set.of(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST);
    }

    public boolean isLit() {
        return (Boolean)super.get("lit");
    }

    public void setLit(boolean lit) {
        super.set("lit", lit);
    }

    public boolean isSignalFire() {
        return (Boolean)super.get("signal_fire");
    }

    public void setSignalFire(boolean signalFire) {
        super.set("signal_fire", signalFire);
    }

    public boolean isWaterlogged() {
        return (Boolean)super.get("waterlogged");
    }

    public void setWaterlogged(boolean waterlogged) {
        super.set("waterlogged", waterlogged);
    }
}

