/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.state;

import be.seeseemelk.mockbukkit.block.state.TileStateMock;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.EndGateway;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EndGatewayMock
extends TileStateMock
implements EndGateway {
    private long age;
    private boolean exactTeleport;
    @Nullable
    private Location exitLocation;

    public EndGatewayMock(@NotNull Material material) {
        super(material);
        this.checkType(material, Material.END_GATEWAY);
    }

    protected EndGatewayMock(@NotNull Block block) {
        super(block);
        this.checkType(block, Material.END_GATEWAY);
    }

    protected EndGatewayMock(@NotNull EndGatewayMock state) {
        super(state);
        this.age = state.age;
        this.exactTeleport = state.exactTeleport;
        this.exitLocation = state.exitLocation;
    }

    @Override
    @NotNull
    public BlockState getSnapshot() {
        return new EndGatewayMock(this);
    }

    @Nullable
    public Location getExitLocation() {
        return this.exitLocation == null ? null : this.exitLocation.clone();
    }

    public void setExitLocation(@Nullable Location location) {
        Preconditions.checkArgument((location == null || Objects.equals(location.getWorld(), this.isPlaced() ? this.getWorld() : null) ? 1 : 0) != 0, (Object)"Cannot set exit location to different world");
        this.exitLocation = location == null ? null : location.toBlockLocation();
    }

    public boolean isExactTeleport() {
        return this.exactTeleport;
    }

    public void setExactTeleport(boolean exact) {
        this.exactTeleport = exact;
    }

    public long getAge() {
        return this.age;
    }

    public void setAge(long age) {
        this.age = age;
    }
}

