/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.state;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.block.state.TileStateMock;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SignMock
extends TileStateMock
implements Sign {
    private final SignSideMock front;
    private final SignSideMock back;

    public SignMock(@NotNull Material material) {
        super(material);
        this.checkType(material, (Tag<Material>)Tag.SIGNS);
        this.front = new SignSideMock();
        this.back = new SignSideMock();
    }

    protected SignMock(@NotNull Block block) {
        super(block);
        this.checkType(block, (Tag<Material>)Tag.SIGNS);
        this.front = new SignSideMock();
        this.back = new SignSideMock();
    }

    protected SignMock(@NotNull SignMock state) {
        super(state);
        this.front = new SignSideMock(state.front);
        this.back = new SignSideMock(state.back);
    }

    @NotNull
    public List<Component> lines() {
        return this.front.lines();
    }

    @NotNull
    public Component line(int index) throws IndexOutOfBoundsException {
        return this.front.line(index);
    }

    public void line(int index, @NotNull Component line) throws IndexOutOfBoundsException {
        this.front.line(index, line);
    }

    @Deprecated(since="1.16")
    @NotNull
    public @NotNull String @NotNull [] getLines() {
        return this.front.getLines();
    }

    @Deprecated(since="1.16")
    @NotNull
    public String getLine(int index) throws IndexOutOfBoundsException {
        return this.front.getLine(index);
    }

    @Deprecated(since="1.16")
    public void setLine(int index, String line) throws IndexOutOfBoundsException {
        this.front.setLine(index, line);
    }

    public boolean isEditable() {
        throw new UnimplementedOperationException();
    }

    public void setEditable(boolean editable) {
        throw new UnimplementedOperationException();
    }

    public boolean isGlowingText() {
        return this.front.isGlowingText();
    }

    public void setGlowingText(boolean glowing) {
        this.front.setGlowingText(glowing);
    }

    @NotNull
    public DyeColor getColor() {
        return this.front.getColor();
    }

    public void setColor(@NotNull DyeColor color) {
        this.front.setColor(color);
    }

    public boolean isWaxed() {
        throw new UnimplementedOperationException();
    }

    public void setWaxed(boolean waxed) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public SignSide getSide(@NotNull Side side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case Side.FRONT -> this.front;
            case Side.BACK -> this.back;
        };
    }

    @NotNull
    public SignSide getTargetSide(@NotNull Player player) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Player getAllowedEditor() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Side getInteractableSideFor(double x, double z) {
        throw new UnimplementedOperationException();
    }

    @Override
    @NotNull
    public BlockState getSnapshot() {
        return new SignMock(this);
    }

    private static class SignSideMock
    implements SignSide {
        private final Component[] lines;
        private boolean glowing = false;
        private DyeColor color = DyeColor.BLACK;

        private SignSideMock() {
            this.lines = new Component[4];
            Arrays.fill(this.lines, Component.empty());
        }

        private SignSideMock(SignSide signSide) {
            this.lines = signSide.lines().toArray(new Component[0]);
            this.glowing = signSide.isGlowingText();
            this.color = signSide.getColor();
        }

        @NotNull
        public List<Component> lines() {
            return List.of(this.lines);
        }

        @NotNull
        public Component line(int index) throws IndexOutOfBoundsException {
            if (index < 0 || index >= this.lines.length) {
                throw new IndexOutOfBoundsException("Index out of bounds: " + index);
            }
            return this.lines[index];
        }

        public void line(int index, @NotNull Component line) throws IndexOutOfBoundsException {
            Preconditions.checkNotNull((Object)line, (Object)"Line cannot be null!");
            if (index < 0 || index >= this.lines.length) {
                throw new IndexOutOfBoundsException("Index out of bounds: " + index);
            }
            this.lines[index] = line;
        }

        @NotNull
        public String[] getLines() {
            return (String[])Arrays.stream(this.lines).map(arg_0 -> ((LegacyComponentSerializer)LegacyComponentSerializer.legacySection()).serialize(arg_0)).toArray(String[]::new);
        }

        @NotNull
        public String getLine(int index) throws IndexOutOfBoundsException {
            if (index < 0 || index >= this.lines.length) {
                throw new IndexOutOfBoundsException("Index out of bounds: " + index);
            }
            return LegacyComponentSerializer.legacySection().serialize(this.lines[index]);
        }

        public void setLine(int index, String line) throws IndexOutOfBoundsException {
            if (index < 0 || index >= this.lines.length) {
                throw new IndexOutOfBoundsException("Index out of bounds: " + index);
            }
            this.lines[index] = line == null ? Component.empty() : LegacyComponentSerializer.legacySection().deserialize(line);
        }

        public boolean isGlowingText() {
            return this.glowing;
        }

        public void setGlowingText(boolean glowing) {
            this.glowing = glowing;
        }

        @NotNull
        public DyeColor getColor() {
            return this.color;
        }

        public void setColor(@NotNull DyeColor color) {
            Preconditions.checkNotNull((Object)color, (Object)"Color cannot be null!");
            this.color = color;
        }
    }
}

