/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.state;

import be.seeseemelk.mockbukkit.block.state.TileStateMock;
import com.google.common.base.Preconditions;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Structure;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.block.structure.UsageMode;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.BlockVector;
import org.jetbrains.annotations.NotNull;

public class StructureMock
extends TileStateMock
implements Structure {
    private static final int MAX_SIZE = 48;
    private String structureName = "";
    private String author = "";
    private BlockVector relativePosition;
    private BlockVector structureSize;
    private Mirror mirror = Mirror.NONE;
    private StructureRotation rotation = StructureRotation.NONE;
    private UsageMode usageMode = UsageMode.DATA;
    private boolean ignoreEntities = true;
    private boolean showAir = false;
    private boolean showBoundingBox = true;
    private float integrity = 1.0f;
    private long seed = 0L;
    private String metadata = "";

    public StructureMock(@NotNull Material material) {
        super(material);
        this.checkType(material, Material.STRUCTURE_BLOCK);
    }

    protected StructureMock(@NotNull Block block) {
        super(block);
        this.checkType(block, Material.STRUCTURE_BLOCK);
    }

    protected StructureMock(@NotNull StructureMock state) {
        super(state);
        this.structureName = state.structureName;
        this.author = state.author;
        this.relativePosition = state.relativePosition;
        this.structureSize = state.structureSize;
        this.mirror = state.mirror;
        this.rotation = state.rotation;
        this.usageMode = state.usageMode;
        this.ignoreEntities = state.ignoreEntities;
        this.showAir = state.showAir;
        this.showBoundingBox = state.showBoundingBox;
        this.integrity = state.integrity;
        this.seed = state.seed;
        this.metadata = state.metadata;
    }

    @Override
    @NotNull
    public BlockState getSnapshot() {
        return new StructureMock(this);
    }

    @NotNull
    public String getStructureName() {
        return this.structureName;
    }

    public void setStructureName(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Structure name cannot be null");
        this.structureName = name;
    }

    @NotNull
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(@NotNull String author) {
        Preconditions.checkArgument((author != null && !author.isEmpty() ? 1 : 0) != 0, (Object)"Author cannot be null or empty");
        this.author = author;
    }

    public void setAuthor(@NotNull LivingEntity livingEntity) {
        Preconditions.checkNotNull((Object)livingEntity, (Object)"Author cannot be null");
        this.setAuthor(livingEntity.getName());
    }

    @NotNull
    public BlockVector getRelativePosition() {
        return this.relativePosition;
    }

    public void setRelativePosition(@NotNull BlockVector vector) {
        Preconditions.checkNotNull((Object)vector, (Object)"Vector cannot be null");
        Preconditions.checkArgument((boolean)StructureMock.isBetween(vector.getBlockX(), -48.0f, 48.0f), (Object)"Structure Size (X) must be between -48 and 48");
        Preconditions.checkArgument((boolean)StructureMock.isBetween(vector.getBlockY(), -48.0f, 48.0f), (Object)"Structure Size (Y) must be between -48 and 48");
        Preconditions.checkArgument((boolean)StructureMock.isBetween(vector.getBlockZ(), -48.0f, 48.0f), (Object)"Structure Size (Z) must be between -48 and 48");
        this.relativePosition = new BlockVector(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    @NotNull
    public BlockVector getStructureSize() {
        return this.structureSize;
    }

    public void setStructureSize(@NotNull BlockVector vector) {
        Preconditions.checkNotNull((Object)vector, (Object)"Vector cannot be null");
        Preconditions.checkArgument((boolean)StructureMock.isBetween(vector.getBlockX(), 0.0f, 48.0f), (Object)"Structure Size (X) must be between 0 and 48");
        Preconditions.checkArgument((boolean)StructureMock.isBetween(vector.getBlockY(), 0.0f, 48.0f), (Object)"Structure Size (Y) must be between 0 and 48");
        Preconditions.checkArgument((boolean)StructureMock.isBetween(vector.getBlockZ(), 0.0f, 48.0f), (Object)"Structure Size (Z) must be between 0 and 48");
        this.structureSize = new BlockVector(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    public void setMirror(@NotNull Mirror mirror) {
        Preconditions.checkNotNull((Object)mirror, (Object)"Mirror cannot be null");
        this.mirror = mirror;
    }

    @NotNull
    public Mirror getMirror() {
        return this.mirror;
    }

    public void setRotation(@NotNull StructureRotation rotation) {
        Preconditions.checkNotNull((Object)rotation, (Object)"Rotation cannot be null");
        this.rotation = rotation;
    }

    @NotNull
    public StructureRotation getRotation() {
        return this.rotation;
    }

    public void setUsageMode(@NotNull UsageMode mode) {
        Preconditions.checkNotNull((Object)mode, (Object)"Usage Mode cannot be null");
        this.usageMode = mode;
    }

    @NotNull
    public UsageMode getUsageMode() {
        return this.usageMode;
    }

    public void setIgnoreEntities(boolean ignoreEntities) {
        this.ignoreEntities = ignoreEntities;
    }

    public boolean isIgnoreEntities() {
        return this.ignoreEntities;
    }

    public void setShowAir(boolean showAir) {
        this.showAir = showAir;
    }

    public boolean isShowAir() {
        return this.showAir;
    }

    public void setBoundingBoxVisible(boolean showBoundingBox) {
        this.showBoundingBox = showBoundingBox;
    }

    public boolean isBoundingBoxVisible() {
        return this.showBoundingBox;
    }

    public void setIntegrity(float integrity) {
        Preconditions.checkArgument((boolean)StructureMock.isBetween(integrity, 0.0f, 1.0f), (Object)"Integrity must be between 0 and 1");
        this.integrity = integrity;
    }

    public float getIntegrity() {
        return this.integrity;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setMetadata(@NotNull String metadata) {
        Preconditions.checkNotNull((Object)metadata, (Object)"Metadata cannot be null");
        if (this.getUsageMode() == UsageMode.DATA) {
            this.metadata = metadata;
        }
    }

    @NotNull
    public String getMetadata() {
        return this.metadata;
    }

    private static boolean isBetween(float num, float min, float max) {
        return num >= min && num <= max;
    }
}

