/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.command;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;

@FunctionalInterface
public interface MessageTarget {
    @Nullable
    public Component nextComponentMessage();

    @Nullable
    default public String nextMessage() {
        Component comp = this.nextComponentMessage();
        if (comp == null) {
            return null;
        }
        return LegacyComponentSerializer.legacySection().serialize(comp);
    }

    default public void assertSaid(@NotNull Component expected) {
        Component comp = this.nextComponentMessage();
        if (comp == null) {
            Assertions.fail((String)"No more messages were sent");
        } else {
            Assertions.assertEquals((Object)expected, (Object)comp);
        }
    }

    default public void assertSaid(@NotNull String expected) {
        this.assertSaid((Component)LegacyComponentSerializer.legacySection().deserialize(expected));
    }

    default public void assertNoMoreSaid() {
        if (this.nextComponentMessage() != null) {
            Assertions.fail((String)"More messages were available");
        }
    }
}

