/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.damage;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.damage.DamageEffectMock;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.damage.DamageEffect;
import org.bukkit.damage.DamageScaling;
import org.bukkit.damage.DamageType;
import org.bukkit.damage.DeathMessageType;
import org.jetbrains.annotations.NotNull;

public class DamageTypeMock
implements DamageType {
    static final String EXHAUSTION = "exhaustion";
    static final String DEATH_MESSAGE_TYPE = "deathMessageType";
    static final String SOUND = "sound";
    static final String DAMAGE_SCALING = "damageScaling";
    static final String KEY = "key";
    private final DamageScaling damageScaling;
    private final DamageEffectMock damageEffect;
    private final NamespacedKey key;
    private final DeathMessageType deathMessageType;
    private final float exhaustion;

    public static DamageTypeMock from(JsonObject data) {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"JsonObject can't be null");
        Preconditions.checkArgument((boolean)data.has(KEY), (Object)"JsonObject does not have a field named 'key'");
        Preconditions.checkArgument((boolean)data.has(DAMAGE_SCALING), (Object)"JsonObject does not have a field named 'damageScaling'");
        Preconditions.checkArgument((boolean)data.has(SOUND), (Object)"JsonObject does not have a field named 'sound'");
        Preconditions.checkArgument((boolean)data.has(DEATH_MESSAGE_TYPE), (Object)"JsonObject does not have a field named 'deathMessageType'");
        Preconditions.checkArgument((boolean)data.has(EXHAUSTION), (Object)"JsonObject does not have a field named 'exhaustion'");
        String keyValue = data.get(KEY).getAsString();
        String damageScalingValue = data.get(DAMAGE_SCALING).getAsString();
        String soundValue = data.get(SOUND).getAsString();
        String deathMessageTypeValue = data.get(DEATH_MESSAGE_TYPE).getAsString();
        float exhaustion = data.get(EXHAUSTION).getAsFloat();
        NamespacedKey key = NamespacedKey.fromString((String)keyValue);
        DamageScaling damageScaling = DamageScaling.valueOf((String)damageScalingValue);
        Sound sound = (Sound)Registry.SOUNDS.get(NamespacedKey.fromString((String)soundValue));
        DamageEffectMock damageEffect = new DamageEffectMock(sound);
        DeathMessageType deathMessageType = DeathMessageType.valueOf((String)deathMessageTypeValue);
        return new DamageTypeMock(damageScaling, damageEffect, key, deathMessageType, exhaustion);
    }

    public DamageTypeMock(@NotNull DamageScaling damageScaling, @NotNull DamageEffectMock damageEffect, @NotNull NamespacedKey key, @NotNull DeathMessageType deathMessageType, float exhaustion) {
        Preconditions.checkArgument((damageScaling != null ? 1 : 0) != 0, (Object)"DamageScaling cannot be null");
        Preconditions.checkArgument((damageEffect != null ? 1 : 0) != 0, (Object)"DamageEffectMock cannot be null");
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"NamespacedKey cannot be null");
        Preconditions.checkArgument((deathMessageType != null ? 1 : 0) != 0, (Object)"DeathMessageType cannot be null");
        this.damageScaling = damageScaling;
        this.damageEffect = damageEffect;
        this.key = key;
        this.deathMessageType = deathMessageType;
        this.exhaustion = exhaustion;
    }

    @Deprecated(forRemoval=true)
    public DamageTypeMock(JsonObject data) {
        this.damageScaling = DamageScaling.valueOf((String)data.get(DAMAGE_SCALING).getAsString());
        Sound sound = (Sound)Registry.SOUNDS.get(NamespacedKey.fromString((String)data.get(SOUND).getAsString()));
        this.damageEffect = new DamageEffectMock(sound);
        this.key = NamespacedKey.fromString((String)data.get(KEY).getAsString());
        this.deathMessageType = DeathMessageType.valueOf((String)data.get(DEATH_MESSAGE_TYPE).getAsString());
        this.exhaustion = data.get(EXHAUSTION).getAsFloat();
    }

    @NotNull
    public String getTranslationKey() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public DamageScaling getDamageScaling() {
        return this.damageScaling;
    }

    @NotNull
    public DamageEffect getDamageEffect() {
        return this.damageEffect;
    }

    @NotNull
    public DeathMessageType getDeathMessageType() {
        return this.deathMessageType;
    }

    public float getExhaustion() {
        return this.exhaustion;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }
}

