/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.enchantments;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.papermc.paper.enchantments.EnchantmentRarity;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.entity.EntityCategory;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class EnchantmentMock
extends Enchantment {
    private static final String LEVEL = "level";
    private static final String COST = "cost";
    @NotNull
    private final String name;
    private final NamespacedKey key;
    private final boolean tradeable;
    private final boolean discoverable;
    private final Set<NamespacedKey> conflicts;
    private final Set<NamespacedKey> enchantables;
    private boolean treasure;
    private final Component[] displayNames;
    private final int[] maxModifiedCosts;
    private boolean cursed;
    private final int[] minModifiedCosts;
    private int maxLevel;
    private int startLevel;

    public EnchantmentMock(NamespacedKey key, boolean treasure, boolean cursed, int maxLevel, int startLevel, String name, Component[] displayNames, int[] minModifiedCost, int[] maxModifiedCost, boolean tradeable, boolean discoverable, Set<NamespacedKey> conflicts, Set<NamespacedKey> enchantables) {
        this.key = key;
        this.treasure = treasure;
        this.cursed = cursed;
        this.maxLevel = maxLevel;
        this.startLevel = startLevel;
        this.name = name;
        this.displayNames = displayNames;
        this.minModifiedCosts = minModifiedCost;
        this.maxModifiedCosts = maxModifiedCost;
        this.tradeable = tradeable;
        this.discoverable = discoverable;
        this.conflicts = conflicts;
        this.enchantables = enchantables;
    }

    @Deprecated(forRemoval=true)
    public EnchantmentMock(JsonObject data) {
        this.key = NamespacedKey.fromString((String)data.get("key").getAsString());
        this.treasure = data.get("treasure").getAsBoolean();
        this.cursed = data.get("cursed").getAsBoolean();
        this.maxLevel = data.get("maxLevel").getAsInt();
        this.startLevel = data.get("startLevel").getAsInt();
        this.name = data.get("name").getAsString();
        this.displayNames = EnchantmentMock.getDisplayNames(data.get("displayNames").getAsJsonArray(), this.maxLevel);
        this.minModifiedCosts = EnchantmentMock.getModifiedCosts(data.get("minModifiedCosts").getAsJsonArray(), this.maxLevel);
        this.maxModifiedCosts = EnchantmentMock.getModifiedCosts(data.get("maxModifiedCosts").getAsJsonArray(), this.maxLevel);
        this.tradeable = data.get("tradeable").getAsBoolean();
        this.discoverable = data.get("discoverable").getAsBoolean();
        this.conflicts = EnchantmentMock.getConflicts(data.get("conflicts").getAsJsonArray());
        this.enchantables = EnchantmentMock.getEnchantables(data.get("enchantable").getAsJsonArray());
    }

    @NotNull
    public Component displayName(int level) {
        return this.displayNames[level - 1];
    }

    public boolean isTradeable() {
        return this.tradeable;
    }

    public boolean isDiscoverable() {
        return this.discoverable;
    }

    public int getMaxModifiedCost(int level) {
        return this.maxModifiedCosts[level - 1];
    }

    public int getAnvilCost() {
        throw new UnimplementedOperationException();
    }

    public int getMinModifiedCost(int level) {
        return this.minModifiedCosts[level - 1];
    }

    @Deprecated(forRemoval=true, since="1.20.5")
    @NotNull
    public EnchantmentRarity getRarity() {
        throw new UnsupportedOperationException("Enchantments don't have a rarity anymore in 1.20.5+.");
    }

    @Deprecated(forRemoval=true, since="1.20.5")
    public float getDamageIncrease(int level, @NotNull EntityCategory entityCategory) {
        throw new UnimplementedOperationException();
    }

    @Deprecated(forRemoval=true, since="1.21")
    public float getDamageIncrease(int level, @NotNull EntityType entityType) {
        throw new UnimplementedOperationException();
    }

    @Deprecated(forRemoval=true, since="1.21")
    @NotNull
    public Set<EquipmentSlot> getActiveSlots() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Set<EquipmentSlotGroup> getActiveSlotGroups() {
        throw new UnimplementedOperationException();
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public String translationKey() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(int startLevel) {
        this.startLevel = startLevel;
    }

    @Deprecated(forRemoval=true, since="1.20.5")
    @NotNull
    public EnchantmentTarget getItemTarget() {
        throw new UnsupportedOperationException("Method no longer applicable. Use Tags instead.");
    }

    @Deprecated(forRemoval=true)
    public void setItemTarget(@NotNull EnchantmentTarget itemTarget) {
        throw new UnsupportedOperationException("Method no longer applicable. Use Tags instead.");
    }

    public boolean isTreasure() {
        return this.treasure;
    }

    public void setTreasure(boolean isTreasure) {
        this.treasure = isTreasure;
    }

    public boolean isCursed() {
        return this.cursed;
    }

    public void setCursed(boolean isCursed) {
        this.cursed = isCursed;
    }

    public boolean conflictsWith(@NotNull Enchantment other) {
        Preconditions.checkArgument((other != null ? 1 : 0) != 0, (Object)"others can't be null");
        return this.conflicts.contains(other.getKey());
    }

    public boolean canEnchantItem(@NotNull ItemStack item) {
        Preconditions.checkNotNull((Object)item, (Object)"Item cannot be null");
        NamespacedKey namespacedKey = item.getType().getKey();
        return this.enchantables.contains(namespacedKey);
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public String getTranslationKey() {
        throw new UnimplementedOperationException();
    }

    @ApiStatus.Internal
    public static EnchantmentMock from(JsonObject data) {
        Preconditions.checkNotNull((Object)data);
        List<String> expectedArguments = List.of("key", "treasure", "cursed", "maxLevel", "startLevel", "name", "displayNames", "minModifiedCosts", "maxModifiedCosts", "tradeable", "discoverable", "conflicts", "enchantables");
        expectedArguments.forEach(expectedKey -> Preconditions.checkArgument((boolean)data.has(expectedKey), (Object)("Missing json key: " + expectedKey)));
        NamespacedKey key = NamespacedKey.fromString((String)data.get("key").getAsString());
        boolean treasure = data.get("treasure").getAsBoolean();
        boolean cursed = data.get("cursed").getAsBoolean();
        int maxLevel = data.get("maxLevel").getAsInt();
        int startLevel = data.get("startLevel").getAsInt();
        String name = data.get("name").getAsString();
        Component[] displayNames = EnchantmentMock.getDisplayNames(data.get("displayNames").getAsJsonArray(), maxLevel);
        int[] minModifiedCosts = EnchantmentMock.getModifiedCosts(data.get("minModifiedCosts").getAsJsonArray(), maxLevel);
        int[] maxModifiedCosts = EnchantmentMock.getModifiedCosts(data.get("maxModifiedCosts").getAsJsonArray(), maxLevel);
        boolean tradeable = data.get("tradeable").getAsBoolean();
        boolean discoverable = data.get("discoverable").getAsBoolean();
        Set<NamespacedKey> conflicts = EnchantmentMock.getConflicts(data.get("conflicts").getAsJsonArray());
        Set<NamespacedKey> enchantables = EnchantmentMock.getEnchantables(data.get("enchantables").getAsJsonArray());
        return new EnchantmentMock(key, treasure, cursed, maxLevel, startLevel, name, displayNames, minModifiedCosts, maxModifiedCosts, tradeable, discoverable, conflicts, enchantables);
    }

    private static Set<NamespacedKey> getConflicts(JsonArray conflicts) {
        HashSet<NamespacedKey> output = new HashSet<NamespacedKey>();
        for (JsonElement conflict : conflicts) {
            output.add(NamespacedKey.fromString((String)conflict.getAsString()));
        }
        return output;
    }

    private static Set<NamespacedKey> getEnchantables(JsonArray enchantables) {
        HashSet<NamespacedKey> output = new HashSet<NamespacedKey>();
        for (JsonElement enchantable : enchantables) {
            output.add(NamespacedKey.fromString((String)enchantable.getAsString()));
        }
        return output;
    }

    private static Component[] getDisplayNames(JsonArray displayNamesData, int maxLevel) {
        Component[] output = new Component[maxLevel];
        for (JsonElement element : displayNamesData) {
            JsonObject displayNameData = element.getAsJsonObject();
            int level = displayNameData.get(LEVEL).getAsInt();
            GsonComponentSerializer gsonComponentSerializer = GsonComponentSerializer.builder().build();
            output[level - 1] = gsonComponentSerializer.deserializeFromTree(displayNameData.get("text"));
        }
        return output;
    }

    private static int[] getModifiedCosts(JsonArray minModifiedCosts, int maxLevel) {
        int[] output = new int[maxLevel];
        for (JsonElement element : minModifiedCosts) {
            JsonObject minModifiedCost = element.getAsJsonObject();
            int level = minModifiedCost.get(LEVEL).getAsInt();
            output[level - 1] = minModifiedCost.get(COST).getAsInt();
        }
        return output;
    }
}

