/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.AbstractProjectileMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractArrowMock
extends AbstractProjectileMock
implements AbstractArrow {
    private int knockbackStrength = 0;
    private double damage = -1.0;
    private int pierceLevel = 0;
    private boolean critical = false;
    private AbstractArrow.PickupStatus pickupStatus = AbstractArrow.PickupStatus.DISALLOWED;
    private boolean shotFromCrossbow = false;
    private int lifetime = 0;
    private Sound hitSound = Sound.ENTITY_ARROW_HIT;
    private boolean noPhysics = false;

    protected AbstractArrowMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public int getKnockbackStrength() {
        return this.knockbackStrength;
    }

    public void setKnockbackStrength(int knockbackStrength) {
        Preconditions.checkArgument((knockbackStrength >= 0 ? 1 : 0) != 0, (String)"Knockback value (%s) cannot be negative", (int)knockbackStrength);
        this.knockbackStrength = knockbackStrength;
    }

    public double getDamage() {
        if (this.damage < 0.0) {
            return super.getEntityProperty("baseDamage").getAsDouble();
        }
        return this.damage;
    }

    public void setDamage(double damage) {
        Preconditions.checkArgument((damage >= 0.0 ? 1 : 0) != 0, (String)"Damage value (%s) must be positive", (Object)damage);
        this.damage = damage;
    }

    public int getPierceLevel() {
        return this.pierceLevel;
    }

    public void setPierceLevel(int pierceLevel) {
        Preconditions.checkArgument((0 <= pierceLevel && pierceLevel <= 127 ? 1 : 0) != 0, (String)"Pierce level (%s) out of range, expected 0 < level < 127", (int)pierceLevel);
        this.pierceLevel = pierceLevel;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public boolean isInBlock() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Block getAttachedBlock() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public AbstractArrow.PickupStatus getPickupStatus() {
        return this.pickupStatus;
    }

    public void setPickupStatus(@NotNull AbstractArrow.PickupStatus status) {
        Preconditions.checkArgument((status != null ? 1 : 0) != 0, (Object)"PickupStatus cannot be null");
        this.pickupStatus = status;
    }

    public boolean isShotFromCrossbow() {
        return this.shotFromCrossbow;
    }

    public void setShotFromCrossbow(boolean shotFromCrossbow) {
        this.shotFromCrossbow = shotFromCrossbow;
    }

    @NotNull
    public ItemStack getItem() {
        throw new UnimplementedOperationException();
    }

    public void setItem(@NotNull ItemStack item) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public ItemStack getWeapon() {
        throw new UnimplementedOperationException();
    }

    public void setWeapon(@NotNull ItemStack item) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemStack getItemStack() {
        throw new UnimplementedOperationException();
    }

    public void setItemStack(@NotNull ItemStack itemStack) {
        throw new UnimplementedOperationException();
    }

    public void setLifetimeTicks(int ticks) {
        this.lifetime = ticks;
    }

    public int getLifetimeTicks() {
        return this.lifetime;
    }

    @NotNull
    public Sound getHitSound() {
        return this.hitSound;
    }

    public void setHitSound(@NotNull Sound sound) {
        Preconditions.checkArgument((sound != null ? 1 : 0) != 0, (Object)"Sound can not be null");
        this.hitSound = sound;
    }

    public void setShooter(@Nullable ProjectileSource projectileSource, boolean b) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setNoPhysics(boolean noPhysics) {
        this.noPhysics = noPhysics;
    }

    @Override
    public boolean hasNoPhysics() {
        return this.noPhysics;
    }
}

