/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.EntityMock;
import be.seeseemelk.mockbukkit.potion.PotionUtils;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.EntityType;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AreaEffectCloudMock
extends EntityMock
implements AreaEffectCloud {
    private int duration = 600;
    private int waitTime = 20;
    private int reapplicationDelay = 20;
    private int durationOnUse = 0;
    private float radius = 3.0f;
    private float radiusOnUse = 0.0f;
    private float radiusPerTick = 0.0f;
    private PotionType potionType;
    private Particle particle = Particle.ENTITY_EFFECT;
    private final List<PotionEffect> customEffects = new ArrayList<PotionEffect>();
    private int color = 0;
    private ProjectileSource source = null;
    private UUID ownerId = null;

    public AreaEffectCloudMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    public int getReapplicationDelay() {
        return this.reapplicationDelay;
    }

    public void setReapplicationDelay(int delay) {
        this.reapplicationDelay = delay;
    }

    public int getDurationOnUse() {
        return this.durationOnUse;
    }

    public void setDurationOnUse(int duration) {
        this.durationOnUse = duration;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getRadiusOnUse() {
        return this.radiusOnUse;
    }

    public void setRadiusOnUse(float radius) {
        this.radiusOnUse = radius;
    }

    public float getRadiusPerTick() {
        return this.radiusPerTick;
    }

    public void setRadiusPerTick(float radius) {
        this.radiusPerTick = radius;
    }

    @NotNull
    public Particle getParticle() {
        return this.particle;
    }

    public void setParticle(@NotNull Particle particle) {
        this.setParticle(particle, null);
    }

    public <T> void setParticle(@NotNull Particle particle, @Nullable T data) {
        Preconditions.checkNotNull((Object)particle, (Object)"Particle cannot be null");
        this.particle = particle;
    }

    public void setBasePotionData(@Nullable PotionData data) {
        this.setBasePotionType(PotionUtils.fromBukkit(data));
    }

    @Nullable
    public PotionData getBasePotionData() {
        return PotionUtils.toBukkit(this.getBasePotionType());
    }

    public void setBasePotionType(@Nullable PotionType type) {
        this.potionType = type;
    }

    @Nullable
    public PotionType getBasePotionType() {
        return this.potionType;
    }

    public boolean hasCustomEffects() {
        return !this.customEffects.isEmpty();
    }

    @NotNull
    public List<PotionEffect> getCustomEffects() {
        return this.customEffects;
    }

    public boolean addCustomEffect(@NotNull PotionEffect effect, boolean overwrite) {
        PotionEffect existingEffect = this.customEffects.stream().filter(e -> e.getType().equals(effect.getType())).findFirst().orElse(null);
        if (existingEffect != null) {
            if (overwrite) {
                this.customEffects.remove(existingEffect);
                this.customEffects.add(effect);
                return true;
            }
            return false;
        }
        this.customEffects.add(effect);
        return true;
    }

    public boolean removeCustomEffect(@NotNull PotionEffectType type) {
        PotionEffect existingEffect = this.customEffects.stream().filter(e -> e.getType().equals(type)).findFirst().orElse(null);
        if (existingEffect != null) {
            this.customEffects.remove(existingEffect);
            return true;
        }
        return false;
    }

    public boolean hasCustomEffect(@Nullable PotionEffectType type) {
        return this.customEffects.stream().anyMatch(effect -> effect.getType().equals(type));
    }

    public void clearCustomEffects() {
        this.customEffects.clear();
    }

    @NotNull
    public Color getColor() {
        return Color.fromRGB((int)this.color);
    }

    public void setColor(@NotNull Color color) {
        Preconditions.checkNotNull((Object)color, (Object)"Color cannot be null");
        this.color = color.asRGB();
    }

    @Nullable
    public ProjectileSource getSource() {
        return this.source;
    }

    public void setSource(@Nullable ProjectileSource source) {
        this.source = source;
    }

    @Nullable
    public UUID getOwnerUniqueId() {
        return this.ownerId;
    }

    public void setOwnerUniqueId(@Nullable UUID ownerUuid) {
        this.ownerId = ownerUuid;
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.AREA_EFFECT_CLOUD;
    }
}

