/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.VehicleMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.entity.Boat;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public class BoatMock
extends VehicleMock
implements Boat {
    @NotNull
    private Boat.Type boatType = Boat.Type.OAK;
    private double maxSpeed = 0.4;
    private double ocupiedDeceleration = 0.2;
    private double unoccupiedDeceleration = -1.0;
    private boolean workOnLand = false;

    public BoatMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    @Deprecated
    @NotNull
    public TreeSpecies getWoodType() {
        return switch (this.boatType) {
            case Boat.Type.SPRUCE -> TreeSpecies.REDWOOD;
            case Boat.Type.BIRCH -> TreeSpecies.BIRCH;
            case Boat.Type.JUNGLE -> TreeSpecies.JUNGLE;
            case Boat.Type.ACACIA -> TreeSpecies.ACACIA;
            case Boat.Type.DARK_OAK -> TreeSpecies.DARK_OAK;
            default -> TreeSpecies.GENERIC;
        };
    }

    @Deprecated
    public void setWoodType(@NotNull TreeSpecies species) {
        Boat.Type type;
        Preconditions.checkNotNull((Object)species, (Object)"Species can not be null");
        this.boatType = type = (switch (species) {
            default -> throw new MatchException(null, null);
            case TreeSpecies.GENERIC -> Boat.Type.OAK;
            case TreeSpecies.BIRCH -> Boat.Type.BIRCH;
            case TreeSpecies.ACACIA -> Boat.Type.ACACIA;
            case TreeSpecies.JUNGLE -> Boat.Type.JUNGLE;
            case TreeSpecies.DARK_OAK -> Boat.Type.DARK_OAK;
            case TreeSpecies.REDWOOD -> Boat.Type.SPRUCE;
        });
    }

    @NotNull
    public Boat.Type getBoatType() {
        return this.boatType;
    }

    public void setBoatType(@NotNull Boat.Type type) {
        Preconditions.checkNotNull((Object)type, (Object)"Type cannot be null");
        this.boatType = type;
    }

    @Deprecated
    public double getMaxSpeed() {
        return this.maxSpeed;
    }

    @Deprecated
    public void setMaxSpeed(double speed) {
        Preconditions.checkArgument((speed >= 0.0 ? 1 : 0) != 0, (Object)"Speed cannot be negative");
        this.maxSpeed = speed;
    }

    @Deprecated
    public double getOccupiedDeceleration() {
        return this.ocupiedDeceleration;
    }

    @Deprecated
    public void setOccupiedDeceleration(double rate) {
        Preconditions.checkArgument((rate >= 0.0 ? 1 : 0) != 0, (Object)"Rate cannot be negative");
        this.ocupiedDeceleration = rate;
    }

    @Deprecated
    public double getUnoccupiedDeceleration() {
        return this.unoccupiedDeceleration;
    }

    @Deprecated
    public void setUnoccupiedDeceleration(double rate) {
        this.unoccupiedDeceleration = rate;
    }

    @Deprecated
    public boolean getWorkOnLand() {
        return this.workOnLand;
    }

    @Deprecated
    public void setWorkOnLand(boolean workOnLand) {
        this.workOnLand = workOnLand;
    }

    @NotNull
    public Boat.Status getStatus() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Material getBoatMaterial() {
        return switch (this.boatType) {
            default -> throw new MatchException(null, null);
            case Boat.Type.OAK -> Material.OAK_BOAT;
            case Boat.Type.SPRUCE -> Material.SPRUCE_BOAT;
            case Boat.Type.BIRCH -> Material.BIRCH_BOAT;
            case Boat.Type.JUNGLE -> Material.JUNGLE_BOAT;
            case Boat.Type.ACACIA -> Material.ACACIA_BOAT;
            case Boat.Type.CHERRY -> Material.CHERRY_BOAT;
            case Boat.Type.DARK_OAK -> Material.DARK_OAK_BOAT;
            case Boat.Type.MANGROVE -> Material.MANGROVE_BOAT;
            case Boat.Type.BAMBOO -> Material.BAMBOO_RAFT;
        };
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.BOAT;
    }
}

