/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.MonsterMock;
import com.destroystokyo.paper.event.entity.CreeperIgniteEvent;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreeperMock
extends MonsterMock
implements Creeper {
    private boolean powered = false;
    private int maxFuseTicks = 30;
    private int fuseTicks = 0;
    private int explosionRadius = 3;
    private boolean ignited = false;

    public CreeperMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean value) {
        CreeperPowerEvent.PowerCause cause;
        CreeperPowerEvent.PowerCause powerCause = cause = this.powered ? CreeperPowerEvent.PowerCause.SET_ON : CreeperPowerEvent.PowerCause.SET_OFF;
        if (new CreeperPowerEvent((Creeper)this, cause).callEvent()) {
            this.powered = value;
        }
    }

    public void setMaxFuseTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"Ticks need to be bigger than 0");
        this.maxFuseTicks = ticks;
    }

    public int getMaxFuseTicks() {
        return this.maxFuseTicks;
    }

    public void setFuseTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"Ticks need to be bigger than 0");
        Preconditions.checkArgument((ticks <= this.getMaxFuseTicks() ? 1 : 0) != 0, (Object)"Ticks need to be smaller than maxFuseTicks");
        this.fuseTicks = ticks;
    }

    public int getFuseTicks() {
        return this.fuseTicks;
    }

    public void setExplosionRadius(int radius) {
        Preconditions.checkArgument((radius >= 0 ? 1 : 0) != 0, (Object)"Radius needs to be bigger than 0");
        this.explosionRadius = radius;
    }

    public int getExplosionRadius() {
        return this.explosionRadius;
    }

    public void explode() {
        float f = this.isPowered() ? 2.0f : 1.0f;
        ExplosionPrimeEvent event = new ExplosionPrimeEvent((Entity)this, (float)this.getExplosionRadius() * f, false);
        this.getServer().getPluginManager().callEvent((Event)event);
        this.remove();
    }

    public void ignite() {
        this.setIgnited(true);
    }

    public void ignite(@NotNull Entity entity) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Entity getIgniter() {
        throw new UnimplementedOperationException();
    }

    public void setIgnited(boolean ignited) {
        if (this.isIgnited() == ignited) {
            return;
        }
        CreeperIgniteEvent event = new CreeperIgniteEvent((Creeper)this, ignited);
        if (event.callEvent()) {
            this.ignited = ignited;
        }
    }

    public boolean isIgnited() {
        return this.ignited;
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.CREEPER;
    }
}

