/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.AnimalsMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hoglin;
import org.jetbrains.annotations.NotNull;

public class HoglinMock
extends AnimalsMock
implements Hoglin {
    private boolean immuneToZombification = false;
    private boolean huntable = false;
    private int conversionTime = -1;

    public HoglinMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.HOGLIN;
    }

    public boolean isImmuneToZombification() {
        return this.immuneToZombification;
    }

    public void setImmuneToZombification(boolean isImmune) {
        this.immuneToZombification = isImmune;
    }

    public boolean isAbleToBeHunted() {
        return this.huntable;
    }

    public void setIsAbleToBeHunted(boolean isHuntable) {
        this.huntable = isHuntable;
    }

    public int getConversionTime() {
        Preconditions.checkState((boolean)this.isConverting(), (Object)"Entity not converting");
        return this.conversionTime;
    }

    public void setConversionTime(int time) {
        if (time < 0) {
            this.conversionTime = -1;
            this.setImmuneToZombification(false);
        } else {
            this.conversionTime = time;
        }
    }

    public boolean isConverting() {
        return !this.isImmuneToZombification() && this.hasAI();
    }
}

