/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.MinecartMock;
import com.destroystokyo.paper.loottable.LootableInventory;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.loot.LootTable;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LootableMinecart
extends MinecartMock
implements LootableInventory {
    private long nextRefill = -1L;
    private long lastFilled = -1L;
    private Map<UUID, Long> lootedPlayers;
    private boolean refillEnabled;

    protected LootableMinecart(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public boolean isRefillEnabled() {
        return this.refillEnabled;
    }

    public void setRefillEnabled(boolean refillEnabled) {
        this.refillEnabled = refillEnabled;
    }

    public boolean hasBeenFilled() {
        return this.lastFilled != -1L;
    }

    public boolean hasPlayerLooted(@NotNull UUID player) {
        return this.lootedPlayers != null && this.lootedPlayers.containsKey(player);
    }

    @Nullable
    public Long getLastLooted(@NotNull UUID player) {
        return this.lootedPlayers != null ? this.lootedPlayers.get(player) : null;
    }

    public boolean setHasPlayerLooted(@NotNull UUID player, boolean looted) {
        boolean hasLooted = this.hasPlayerLooted(player);
        if (this.lootedPlayers == null) {
            this.lootedPlayers = new HashMap<UUID, Long>();
        }
        if (hasLooted != looted) {
            if (looted) {
                this.lootedPlayers.computeIfAbsent(player, p -> System.currentTimeMillis());
            } else {
                this.lootedPlayers.remove(player);
            }
        }
        return hasLooted;
    }

    public boolean hasPendingRefill() {
        return this.nextRefill != -1L;
    }

    public long getLastFilled() {
        return this.lastFilled;
    }

    public long getNextRefill() {
        return this.nextRefill;
    }

    public long setNextRefill(long refillAt) {
        long oldRefill = this.nextRefill;
        this.nextRefill = refillAt;
        new BukkitRunnable(){

            public void run() {
                if (LootableMinecart.this.nextRefill == LootableMinecart.this.server.getScheduler().getCurrentTick()) {
                    LootableMinecart.this.nextRefill = -1L;
                    LootableMinecart.this.lastFilled = LootableMinecart.this.server.getScheduler().getCurrentTick();
                }
            }
        }.runTaskTimer(null, 1L, 1L);
        return oldRefill;
    }

    public void setLootTable(@Nullable LootTable table) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public LootTable getLootTable() {
        throw new UnimplementedOperationException();
    }

    public void setSeed(long seed) {
        throw new UnimplementedOperationException();
    }

    public long getSeed() {
        throw new UnimplementedOperationException();
    }
}

