/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.GolemMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.DyeColor;
import org.bukkit.Sound;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Shulker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShulkerMock
extends GolemMock
implements Shulker {
    private int peekAmount = 0;
    private BlockFace attachedFace = BlockFace.DOWN;
    private DyeColor dyeColor;

    public ShulkerMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public float getPeek() {
        return (float)this.peekAmount / 100.0f;
    }

    public void setPeek(float value) {
        Preconditions.checkArgument((value >= 0.0f && value <= 1.0f ? 1 : 0) != 0, (Object)"value needs to be in between or equal to 0 and 1");
        this.peekAmount = (int)(value * 100.0f);
    }

    @NotNull
    public BlockFace getAttachedFace() {
        return this.attachedFace;
    }

    public void setAttachedFace(@NotNull BlockFace face) {
        Preconditions.checkNotNull((Object)face, (Object)"face cannot be null");
        Preconditions.checkArgument((boolean)face.isCartesian(), (String)"%s is not a valid block face to attach a shulker to, a cartesian block face is expected", (Object)face);
        this.attachedFace = face;
    }

    @Nullable
    public DyeColor getColor() {
        return this.dyeColor;
    }

    public void setColor(DyeColor color) {
        this.dyeColor = color;
    }

    @Override
    @Nullable
    public Sound getAmbientSound() {
        return Sound.ENTITY_SHULKER_AMBIENT;
    }

    @Override
    @Nullable
    public Sound getHurtSound() {
        return Sound.ENTITY_SHULKER_HURT;
    }

    @Override
    @Nullable
    public Sound getDeathSound() {
        return Sound.ENTITY_SHULKER_DEATH;
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.SHULKER;
    }
}

