/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.AbstractArrowMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Trident;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TridentMock
extends AbstractArrowMock
implements Trident {
    private boolean glint;
    private int loyaltyLevel;
    private boolean dealtDamage = false;

    public TridentMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
        super.setHitSound(Sound.ITEM_TRIDENT_HIT);
    }

    public boolean hasGlint() {
        return this.glint;
    }

    public void setGlint(boolean glint) {
        this.glint = glint;
    }

    public int getLoyaltyLevel() {
        return this.loyaltyLevel;
    }

    public void setLoyaltyLevel(int loyaltyLevel) {
        Preconditions.checkArgument((loyaltyLevel >= 0 && loyaltyLevel <= 127 ? 1 : 0) != 0, (Object)"The loyalty level has to be between 0 and 127");
        this.loyaltyLevel = loyaltyLevel;
    }

    public boolean hasDealtDamage() {
        return this.dealtDamage;
    }

    public void setHasDealtDamage(boolean hasDealtDamage) {
        this.dealtDamage = hasDealtDamage;
    }

    @Override
    @NotNull
    public ItemStack getItem() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setItem(@NotNull ItemStack item) {
        throw new UnimplementedOperationException();
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.TRIDENT;
    }
}

