/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.MockRangedEntity;
import be.seeseemelk.mockbukkit.entity.RaiderMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Witch;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WitchMock
extends RaiderMock
implements Witch,
MockRangedEntity<WitchMock> {
    private ItemStack drinkingPotion = ItemStack.empty();
    private int drinkingTimeLeft;
    private boolean drinking;

    public WitchMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public boolean isDrinkingPotion() {
        return this.drinking;
    }

    public void setDrinkingPotion(boolean drinking) {
        this.drinking = drinking;
    }

    public int getPotionUseTimeLeft() {
        return this.drinkingTimeLeft;
    }

    public void setPotionUseTimeLeft(int ticks) {
        this.drinkingTimeLeft = ticks;
    }

    @NotNull
    public ItemStack getDrinkingPotion() {
        return this.drinkingPotion;
    }

    public void setDrinkingPotion(@Nullable ItemStack potion) {
        Preconditions.checkArgument((potion == null || potion.getType().isEmpty() || potion.getType() == Material.POTION ? 1 : 0) != 0, (Object)"must be potion, air, or null");
        this.drinkingPotion = potion == null ? ItemStack.empty() : potion.clone();
    }

    @NotNull
    public Sound getCelebrationSound() {
        return Sound.ENTITY_WITCH_CELEBRATE;
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.WITCH;
    }
}

