/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.TameableAnimalMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.DyeColor;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Wolf;
import org.jetbrains.annotations.NotNull;

public class WolfMock
extends TameableAnimalMock
implements Wolf {
    private boolean isAngry = false;
    @NotNull
    private DyeColor collarColor = DyeColor.RED;
    private boolean isWet = false;
    private boolean interested = false;

    public WolfMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public boolean isAngry() {
        return this.isAngry;
    }

    public void setAngry(boolean angry) {
        this.isAngry = angry;
    }

    @NotNull
    public DyeColor getCollarColor() {
        return this.collarColor;
    }

    public void setCollarColor(@NotNull DyeColor color) {
        Preconditions.checkNotNull((Object)color, (Object)"Collar color cannot be null");
        this.collarColor = color;
    }

    public boolean isWet() {
        return this.isWet;
    }

    public void setWet(boolean wet) {
        this.isWet = wet;
    }

    public float getTailAngle() {
        return this.isAngry() ? 1.5393804f : this.calculateNonAngryTailAngle();
    }

    public boolean isInterested() {
        return this.interested;
    }

    public void setInterested(boolean interested) {
        this.interested = interested;
    }

    @NotNull
    public Wolf.Variant getVariant() {
        throw new UnimplementedOperationException();
    }

    public void setVariant(@NotNull Wolf.Variant variant) {
        throw new UnimplementedOperationException();
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.WOLF;
    }

    private float calculateNonAngryTailAngle() {
        return this.isTamed() ? (float)(((double)0.55f - (this.getMaxHealth() - this.getHealth()) * (double)0.02f) * 3.1415927410125732) : 0.62831855f;
    }
}

