/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.food;

import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.potion.MockInternalPotionData;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record FoodConsumption(Material name, int nutrition, float saturationModifier, boolean canAlwaysEat, int eatDurationTicks, List<FoodEffect> foodEffects) {
    private static Map<Material, FoodConsumption> ALL_FOODS = null;

    private static FoodConsumption loadFoodConsumptionFrom(JsonObject jsonObject) {
        return new FoodConsumption(Material.matchMaterial((String)jsonObject.get("name").getAsString()), jsonObject.get("nutrition").getAsInt(), jsonObject.get("saturationModifier").getAsFloat(), jsonObject.get("canAlwaysEat").getAsBoolean(), jsonObject.get("eatDurationTicks").getAsInt(), FoodConsumption.loadFoodEffectsFrom(jsonObject.get("effects").getAsJsonArray()));
    }

    private static List<FoodEffect> loadFoodEffectsFrom(JsonArray jsonArray) {
        return jsonArray.asList().stream().map(jsonElement -> FoodConsumption.loadFoodEffectFrom(jsonElement.getAsJsonObject())).toList();
    }

    private static FoodEffect loadFoodEffectFrom(JsonObject jsonObject) {
        return new FoodEffect(MockInternalPotionData.getPotionEffectFromData((JsonElement)jsonObject), jsonObject.get("probability").getAsFloat());
    }

    @ApiStatus.Internal
    public static Map<Material, FoodConsumption> getOrCreateAllFoods() {
        if (ALL_FOODS == null) {
            String path = "/foods/food_properties.json";
            if (MockBukkit.class.getResource(path) == null) {
                try {
                    throw new FileNotFoundException(path);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(MockBukkit.class.getResourceAsStream(path), StandardCharsets.UTF_8));){
                JsonArray jsonArray = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                ALL_FOODS = jsonArray.asList().stream().map(jsonElement -> FoodConsumption.loadFoodConsumptionFrom(jsonElement.getAsJsonObject())).collect(Collectors.toMap(FoodConsumption::name, Function.identity()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return ALL_FOODS;
    }

    @ApiStatus.Internal
    public static FoodConsumption getFor(Material material) {
        return FoodConsumption.getOrCreateAllFoods().get(material);
    }

    @ApiStatus.Internal
    public record FoodEffect(PotionEffect potionEffect, float probability) {
    }
}

