/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.generator.structure;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.generator.structure.Structure;
import org.bukkit.generator.structure.StructureType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class StructureMock
extends Structure {
    private final NamespacedKey key;
    private final StructureType type;

    public StructureMock(NamespacedKey key, StructureType type) {
        this.key = key;
        this.type = type;
    }

    @Deprecated(forRemoval=true)
    public StructureMock(JsonObject data) {
        Preconditions.checkNotNull((Object)data);
        this.key = NamespacedKey.fromString((String)data.get("key").getAsString());
        this.type = (StructureType)Registry.STRUCTURE_TYPE.get((NamespacedKey)Preconditions.checkNotNull((Object)NamespacedKey.fromString((String)data.get("type").getAsString())));
    }

    @ApiStatus.Internal
    public static StructureMock from(JsonObject data) {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkArgument((boolean)data.has("key"), (Object)"Missing json key");
        Preconditions.checkArgument((boolean)data.has("type"), (Object)"Missing json key");
        NamespacedKey key = NamespacedKey.fromString((String)data.get("key").getAsString());
        StructureType type = (StructureType)Registry.STRUCTURE_TYPE.get((NamespacedKey)Preconditions.checkNotNull((Object)NamespacedKey.fromString((String)data.get("type").getAsString())));
        return new StructureMock(key, type);
    }

    @NotNull
    public StructureType getStructureType() {
        return this.type;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }
}

