/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import com.google.common.base.Preconditions;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InventoryViewMock
implements InventoryView {
    private Inventory topInventory;
    private Inventory bottomInventory;
    private HumanEntity player;
    private InventoryType type;
    private String name;
    private String originalTitle;
    private boolean titleChanged = false;
    private ItemStack cursor = null;

    protected InventoryViewMock(HumanEntity player, String name, Inventory top, Inventory bottom, InventoryType type) {
        this.player = player;
        this.type = type;
        this.name = name;
        this.topInventory = top;
        this.bottomInventory = bottom;
    }

    public void setTopInventory(Inventory inventory) {
        this.topInventory = inventory;
    }

    public void setBottomInventory(Inventory inventory) {
        this.bottomInventory = inventory;
    }

    public void setPlayer(HumanEntity player) {
        this.player = player;
    }

    public void setType(InventoryType type) {
        this.type = type;
    }

    @NotNull
    public Inventory getTopInventory() {
        return this.topInventory;
    }

    @NotNull
    public Inventory getBottomInventory() {
        return this.bottomInventory;
    }

    @NotNull
    public HumanEntity getPlayer() {
        return this.player;
    }

    @NotNull
    public InventoryType getType() {
        return this.type;
    }

    @NotNull
    public String getTitle() {
        return this.name;
    }

    @NotNull
    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public void setTitle(@NotNull String title) {
        if (!this.titleChanged) {
            this.originalTitle = this.name;
            this.titleChanged = true;
        }
        this.name = title;
    }

    public void setCursor(@Nullable ItemStack item) {
        this.player.setItemOnCursor(item);
    }

    @NotNull
    public ItemStack getCursor() {
        return this.player.getItemOnCursor();
    }

    public void setItem(int slot, @Nullable ItemStack item) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public ItemStack getItem(int slot) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Inventory getInventory(int rawSlot) {
        if (rawSlot == -999 || rawSlot == -1) {
            return null;
        }
        Preconditions.checkArgument((rawSlot >= 0 ? 1 : 0) != 0, (String)"Negative, non outside slot %s", (int)rawSlot);
        Preconditions.checkArgument((rawSlot < this.countSlots() ? 1 : 0) != 0, (String)"Slot %s greater than inventory slot count", (int)rawSlot);
        if (rawSlot < this.getTopInventory().getSize()) {
            return this.getTopInventory();
        }
        return this.getBottomInventory();
    }

    public int convertSlot(int rawSlot) {
        int numInTop = this.getTopInventory().getSize();
        if (rawSlot < numInTop) {
            return rawSlot;
        }
        int slot = rawSlot - numInTop;
        if (this.getType() == InventoryType.CRAFTING || this.getType() == InventoryType.CREATIVE) {
            if (slot < 4) {
                return 39 - slot;
            }
            if (slot > 39) {
                return slot;
            }
            slot -= 4;
        }
        slot = slot >= 27 ? (slot -= 27) : (slot += 9);
        return slot;
    }

    @NotNull
    public InventoryType.SlotType getSlotType(int slot) {
        throw new UnimplementedOperationException();
    }

    public void close() {
        throw new UnimplementedOperationException();
    }

    public int countSlots() {
        return this.getTopInventory().getSize() + this.getBottomInventory().getSize();
    }

    public boolean setProperty(@NotNull InventoryView.Property prop, int value) {
        throw new UnimplementedOperationException();
    }
}

