/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory;

import be.seeseemelk.mockbukkit.inventory.ItemTypeMock;
import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStackMock
extends ItemStack {
    private ItemType type = ItemTypeMock.AIR;
    private int amount = 1;
    private ItemMeta itemMeta = new ItemMetaMock();
    private short durability;
    private static final ItemStackMock EMPTY = new ItemStackMock((Void)null);
    private static final String ITEMMETA_INITIALIZATION_ERROR = "Failed to instanciate item meta class ";

    protected ItemStackMock() {
    }

    public ItemStackMock(@NotNull Material type) {
        this(type, 1);
    }

    public ItemStackMock(@NotNull ItemStack stack) throws IllegalArgumentException {
        this.type = stack.getType().asItemType();
        this.amount = stack.getAmount();
        this.durability = this.type.getMaxDurability();
        if (this.type.asMaterial() != Material.AIR && this.type.getItemMetaClass() != ItemMeta.class) {
            try {
                this.itemMeta = (ItemMeta)this.type.getItemMetaClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(ITEMMETA_INITIALIZATION_ERROR + String.valueOf(this.type.getItemMetaClass()), e);
            }
        }
    }

    public ItemStackMock(@NotNull Material type, int amount) {
        this.type = type.asItemType();
        this.amount = amount;
        this.durability = type.getMaxDurability();
        if (type != Material.AIR && type.asItemType().getItemMetaClass() != ItemMeta.class) {
            try {
                this.itemMeta = (ItemMeta)type.asItemType().getItemMetaClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(ITEMMETA_INITIALIZATION_ERROR + String.valueOf(type.asItemType().getItemMetaClass()), e);
            }
        }
    }

    private ItemStackMock(@javax.annotation.Nullable Void v) {
        this.type = ItemTypeMock.AIR;
        this.amount = 0;
    }

    private ItemStackMock(@NotNull ItemType type) {
        this.type = type;
        this.durability = type.getMaxDurability();
        if (type.asMaterial() != Material.AIR && type.getItemMetaClass() != ItemMeta.class) {
            try {
                this.itemMeta = (ItemMeta)type.getItemMetaClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(ITEMMETA_INITIALIZATION_ERROR + String.valueOf(type.getItemMetaClass()), e);
            }
        }
    }

    public void setType(@NotNull Material type) {
        this.type = type.asItemType();
    }

    @NotNull
    public Material getType() {
        return this.type.asMaterial();
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.type == ItemTypeMock.AIR || this.amount <= 0;
    }

    public boolean setItemMeta(@Nullable ItemMeta itemMeta) {
        if (this.type == ItemTypeMock.AIR) {
            return false;
        }
        this.itemMeta = itemMeta;
        return true;
    }

    public ItemMeta getItemMeta() {
        return this.itemMeta;
    }

    public boolean hasItemMeta() {
        return this.itemMeta != null && !Bukkit.getItemFactory().equals(this.itemMeta, null);
    }

    public int getMaxStackSize() {
        return this.type.getMaxStackSize();
    }

    public short getDurability() {
        return this.durability;
    }

    public void setDurability(short durability) {
        this.durability = (short)Math.min(Math.max(durability, 0), this.type.getMaxDurability());
    }

    public void addUnsafeEnchantment(@NotNull Enchantment ench, int level) {
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        ItemMeta meta = this.getItemMeta();
        if (meta != null) {
            meta.addEnchant(ench, level, true);
            this.setItemMeta(meta);
        }
    }

    public boolean isSimilar(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (!(stack instanceof ItemStackMock)) {
            return false;
        }
        ItemStackMock bukkit = (ItemStackMock)stack;
        if (this == bukkit) {
            return true;
        }
        return this.type == bukkit.type;
    }

    public static ItemStackMock empty() {
        return EMPTY;
    }

    @NotNull
    public ItemStack clone() {
        ItemStackMock clone = new ItemStackMock(this.type);
        clone.setAmount(this.amount);
        clone.setDurability(this.durability);
        clone.setItemMeta(this.itemMeta);
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemStackMock)) {
            return false;
        }
        ItemStackMock bukkit = (ItemStackMock)((Object)obj);
        return this.isSimilar(bukkit) && this.amount == bukkit.getAmount();
    }

    @NotNull
    public static ItemStack deserialize(@NotNull Map<String, Object> args) {
        int version = args.containsKey("v") ? ((Number)args.get("v")).intValue() : -1;
        short damage = 0;
        String damageKey = "damage";
        if (args.containsKey(damageKey)) {
            damage = ((Number)args.get(damageKey)).shortValue();
        }
        Material type = Bukkit.getUnsafe().getMaterial((String)args.get("type"), version);
        ItemStackMock result = new ItemStackMock(type);
        if (args.containsKey("enchantments")) {
            ItemStackMock.handleLegacyEnchantmentsForDeserialization(args, result);
        } else if (args.containsKey("meta")) {
            ItemStackMock.handleMetaForDeserialization(args, version, result);
        }
        if (version < 0 && args.containsKey(damageKey)) {
            result.setDurability(damage);
        }
        return result;
    }

    private static void handleMetaForDeserialization(@NotNull Map<String, Object> args, int version, ItemStack result) {
        Object raw = args.get("meta");
        if (raw instanceof ItemMeta) {
            ((ItemMeta)raw).setVersion(version);
            if (version < 3837 && ((ItemMeta)raw).hasItemFlag(ItemFlag.HIDE_ADDITIONAL_TOOLTIP)) {
                ((ItemMeta)raw).addItemFlags(new ItemFlag[]{ItemFlag.HIDE_STORED_ENCHANTS});
            }
            result.setItemMeta((ItemMeta)raw);
        }
    }

    private static void handleLegacyEnchantmentsForDeserialization(@NotNull Map<String, Object> args, ItemStack result) {
        Object raw = args.get("enchantments");
        if (raw instanceof Map) {
            Map map = (Map)raw;
            for (Map.Entry entry : map.entrySet()) {
                String stringKey = entry.getKey().toString();
                stringKey = Bukkit.getUnsafe().get(Enchantment.class, stringKey);
                NamespacedKey key = NamespacedKey.fromString((String)stringKey.toLowerCase(Locale.ROOT));
                Enchantment enchantment = (Enchantment)Bukkit.getUnsafe().get(Registry.ENCHANTMENT, key);
                if (enchantment == null || !(entry.getValue() instanceof Integer)) continue;
                result.addUnsafeEnchantment(enchantment, ((Integer)entry.getValue()).intValue());
            }
        }
    }
}

