/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.inventory.ItemStackMock;
import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockType;
import org.bukkit.inventory.CreativeCategory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ItemTypeMock<M extends ItemMeta>
implements ItemType.Typed<M> {
    private final NamespacedKey namespacedKey;
    private final boolean blockType;
    private final int maxStackSize;
    private final short maxDurability;
    private final boolean edible;
    private final boolean hasRecord;
    private final boolean fuel;
    private final String translationKey;
    private final Class<M> metaClass;

    private ItemTypeMock(NamespacedKey namespacedKey, int maxStackSize, short maxDurability, boolean edible, boolean hasRecord, boolean fuel, boolean blockType, String translationKey, Class<M> metaClass) {
        this.namespacedKey = namespacedKey;
        this.maxStackSize = maxStackSize;
        this.maxDurability = maxDurability;
        this.edible = edible;
        this.hasRecord = hasRecord;
        this.fuel = fuel;
        this.blockType = blockType;
        this.translationKey = translationKey;
        this.metaClass = metaClass;
    }

    @ApiStatus.Internal
    public static ItemType from(JsonObject jsonObject) {
        NamespacedKey key = NamespacedKey.fromString((String)jsonObject.get("key").getAsString());
        int maxStackSize = jsonObject.get("maxStackSize").getAsInt();
        short maxDurability = jsonObject.get("maxDurability").getAsShort();
        boolean edible = jsonObject.get("edible").getAsBoolean();
        boolean hasRecord = jsonObject.get("record").getAsBoolean();
        boolean fuel = jsonObject.get("fuel").getAsBoolean();
        boolean blockType = jsonObject.get("blockType").getAsBoolean();
        String translationKey = jsonObject.get("translationKey").getAsString();
        Class metaClass = null;
        String metaClassKey = "metaClass";
        if (jsonObject.has(metaClassKey)) {
            String metaClassAsString = jsonObject.get(metaClassKey).getAsString();
            try {
                if (metaClassAsString.equals("BlockStateMeta") || metaClassAsString.equals("BlockDataMeta") || metaClassAsString.equals("EnchantmentStorageMeta") || metaClassAsString.equals("MusicInstrumentMeta") || metaClassAsString.equals("OminousBottleMeta") || metaClassAsString.equals("BundleMeta")) {
                    metaClass = ItemMetaMock.class;
                } else {
                    String metaClassName = "be.seeseemelk.mockbukkit.inventory.meta." + jsonObject.get(metaClassKey).getAsString() + "Mock";
                    metaClass = Class.forName(metaClassName);
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not find class: " + jsonObject.get(metaClassKey).getAsString());
            }
        }
        return new ItemTypeMock<ItemMetaMock>(key, maxStackSize, maxDurability, edible, hasRecord, fuel, blockType, translationKey, metaClass);
    }

    @NotNull
    public ItemType.Typed<ItemMeta> typed() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public <M extends ItemMeta> ItemType.Typed<M> typed(@NotNull Class<M> itemMetaType) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemStack createItemStack() {
        return this.createItemStack(1);
    }

    @NotNull
    public ItemStack createItemStack(int amount) {
        return new ItemStackMock(this.asMaterial(), amount);
    }

    public boolean hasBlockType() {
        return this.blockType;
    }

    @NotNull
    public BlockType getBlockType() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Class<M> getItemMetaClass() {
        if (this == ItemType.AIR) {
            throw new UnsupportedOperationException("Air does not have ItemMeta");
        }
        return this.metaClass;
    }

    @NotNull
    public ItemStack createItemStack(@Nullable Consumer<? super M> metaConfigurator) {
        return null;
    }

    @NotNull
    public ItemStack createItemStack(int amount, @Nullable Consumer<? super M> metaConfigurator) {
        return null;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public short getMaxDurability() {
        return this.maxDurability;
    }

    public boolean isEdible() {
        return this.edible;
    }

    public boolean isRecord() {
        return this.hasRecord;
    }

    public boolean isFuel() {
        return this.fuel;
    }

    public boolean isCompostable() {
        throw new UnimplementedOperationException();
    }

    public float getCompostChance() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public ItemType getCraftingRemainingItem() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public @Unmodifiable Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(@NotNull EquipmentSlot slot) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public CreativeCategory getCreativeCategory() {
        throw new UnimplementedOperationException();
    }

    public boolean isEnabledByFeature(@NotNull World world) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Material asMaterial() {
        return (Material)Registry.MATERIAL.get(this.namespacedKey);
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.namespacedKey;
    }

    @NotNull
    public String getTranslationKey() {
        return this.translationKey;
    }

    @Nullable
    public ItemRarity getItemRarity() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public String translationKey() {
        return this.translationKey;
    }
}

