/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.block.banner.Pattern;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class BannerMetaMock
extends ItemMetaMock
implements BannerMeta {
    private List<Pattern> patterns;

    public BannerMetaMock() {
        this.patterns = new ArrayList<Pattern>();
    }

    public BannerMetaMock(@NotNull BannerMeta meta) {
        super((ItemMeta)meta);
        this.patterns = new ArrayList<Pattern>(meta.getPatterns());
    }

    @NotNull
    public List<Pattern> getPatterns() {
        return new ArrayList<Pattern>(this.patterns);
    }

    public void setPatterns(@NotNull List<Pattern> patterns) {
        this.patterns = new ArrayList<Pattern>(patterns);
    }

    public void addPattern(@NotNull Pattern pattern) {
        this.patterns.add(pattern);
    }

    @NotNull
    public Pattern getPattern(int i) {
        return this.patterns.get(i);
    }

    @NotNull
    public Pattern removePattern(int i) {
        return this.patterns.remove(i);
    }

    public void setPattern(int i, @NotNull Pattern pattern) {
        this.patterns.set(i, pattern);
    }

    public int numberOfPatterns() {
        return this.patterns.size();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.patterns.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BannerMeta)) {
            return false;
        }
        BannerMeta meta = (BannerMeta)obj;
        return super.equals(obj) && this.patterns.equals(meta.getPatterns());
    }

    @Override
    @NotNull
    public BannerMetaMock clone() {
        BannerMetaMock clone = (BannerMetaMock)super.clone();
        clone.patterns = new ArrayList<Pattern>(this.patterns);
        return clone;
    }

    @NotNull
    public static BannerMetaMock deserialize(@NotNull Map<String, Object> args) {
        BannerMetaMock serialMock = new BannerMetaMock();
        serialMock.deserializeInternal(args);
        serialMock.setPatterns(((List)args.get("patterns")).stream().map(Pattern::new).toList());
        return serialMock;
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        Map<String, Object> serialized = super.serialize();
        serialized.put("patterns", this.patterns.stream().map(Pattern::serialize).toList());
        return serialized;
    }

    @Override
    protected String getTypeName() {
        return "BANNER";
    }
}

