/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.metadata;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class MetadataTable
implements Metadatable {
    @NotNull
    private final Map<String, Map<Plugin, MetadataValue>> metadata;

    @ApiStatus.Internal
    public MetadataTable() {
        this.metadata = new HashMap<String, Map<Plugin, MetadataValue>>();
    }

    @ApiStatus.Internal
    public MetadataTable(@NotNull MetadataTable table) {
        this.metadata = new HashMap<String, Map<Plugin, MetadataValue>>(table.metadata);
    }

    public void setMetadata(@NotNull String metadataKey, @NotNull MetadataValue newMetadataValue) {
        Map values = this.metadata.computeIfAbsent(metadataKey, key -> new HashMap());
        values.put(newMetadataValue.getOwningPlugin(), newMetadataValue);
    }

    @NotNull
    public List<MetadataValue> getMetadata(@NotNull String metadataKey) {
        Map<Plugin, MetadataValue> values = this.metadata.get(metadataKey);
        return values == null ? List.of() : List.copyOf(values.values());
    }

    public boolean hasMetadata(@NotNull String metadataKey) {
        return this.metadata.containsKey(metadataKey) && this.metadata.get(metadataKey).size() > 0;
    }

    public void removeMetadata(@NotNull String metadataKey, @NotNull Plugin owningPlugin) {
        if (this.metadata.containsKey(metadataKey)) {
            this.metadata.get(metadataKey).remove(owningPlugin);
        }
    }

    public void clearMetadata(@NotNull Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin cannot be null");
        Iterator<Map<Plugin, MetadataValue>> iterator = this.metadata.values().iterator();
        while (iterator.hasNext()) {
            Map<Plugin, MetadataValue> values = iterator.next();
            values.remove(plugin);
            if (!values.isEmpty()) continue;
            iterator.remove();
        }
    }
}

