/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.profile;

import be.seeseemelk.mockbukkit.profile.PlayerProfileMock;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.annotation.Nonnull;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerTexturesMock
implements PlayerTextures {
    private static final String PROPERTY_NAME = "textures";
    private final PlayerProfileMock profile;
    private long timestamp;
    private URL skin;
    private PlayerTextures.SkinModel skinModel = PlayerTextures.SkinModel.CLASSIC;
    private URL cape;
    private boolean dirty = false;

    private void markDirty() {
        this.dirty = true;
        this.timestamp = 0L;
    }

    public PlayerTexturesMock(@Nonnull PlayerProfileMock profile) {
        this.profile = profile;
    }

    public boolean isEmpty() {
        return this.skin == null && this.cape == null;
    }

    public void clear() {
        this.profile.removeProperty(PROPERTY_NAME);
        this.timestamp = 0L;
        this.skin = null;
        this.skinModel = PlayerTextures.SkinModel.CLASSIC;
        this.cape = null;
        this.dirty = false;
    }

    @Nullable
    public URL getSkin() {
        return this.skin;
    }

    public void setSkin(@Nullable URL skinUrl) {
        this.setSkin(skinUrl, PlayerTextures.SkinModel.CLASSIC);
    }

    public void setSkin(@Nullable URL skinUrl, @Nullable PlayerTextures.SkinModel skinModel) {
        this.skin = skinUrl;
        this.skinModel = skinUrl != null ? skinModel : PlayerTextures.SkinModel.CLASSIC;
        this.dirty = true;
        this.markDirty();
        this.setProperty();
    }

    @NotNull
    public PlayerTextures.SkinModel getSkinModel() {
        return this.skinModel;
    }

    @Nullable
    public URL getCape() {
        return this.cape;
    }

    public void setCape(@Nullable URL capeUrl) {
        this.cape = capeUrl;
        this.dirty = true;
        this.markDirty();
        this.setProperty();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isSigned() {
        if (this.dirty) {
            return false;
        }
        ProfileProperty property = this.getProperty();
        return property != null;
    }

    @Nullable
    ProfileProperty getProperty() {
        return this.profile.getProperty(PROPERTY_NAME);
    }

    public int hashCode() {
        ProfileProperty property = this.getProperty();
        return property == null ? 0 : property.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PlayerTextures)) {
            return false;
        }
        PlayerTexturesMock other = (PlayerTexturesMock)obj;
        ProfileProperty property = this.getProperty();
        ProfileProperty otherProperty = other.getProperty();
        if (property == null && otherProperty == null) {
            return true;
        }
        if (property == null || otherProperty == null) {
            return false;
        }
        return property.equals((Object)otherProperty);
    }

    private void setProperty() {
        this.timestamp = System.currentTimeMillis();
        JsonObject json = new JsonObject();
        json.addProperty("timestamp", (Number)this.timestamp);
        json.addProperty("profileId", this.profile.getUniqueId().toString().replace("-", ""));
        json.addProperty("profileName", this.profile.getName());
        JsonObject textures = new JsonObject();
        if (this.skin != null) {
            textures.addProperty("SKIN", this.skin.toString());
            textures.addProperty("SKIN_MODEL", this.skinModel.name());
        }
        if (this.cape != null) {
            textures.addProperty("CAPE", this.cape.toString());
        }
        json.add(PROPERTY_NAME, (JsonElement)textures);
        String base64Encoded = Base64.getEncoder().encodeToString(json.toString().getBytes(StandardCharsets.UTF_8));
        ProfileProperty property = new ProfileProperty(PROPERTY_NAME, base64Encoded);
        this.profile.setProperty(property);
    }
}

