/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.scheduler;

import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.scheduler.AsyncTaskException;
import be.seeseemelk.mockbukkit.scheduler.RepeatingTask;
import be.seeseemelk.mockbukkit.scheduler.ScheduledTask;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scheduler.BukkitWorker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import org.opentest4j.AssertionFailedError;

public class BukkitSchedulerMock
implements BukkitScheduler {
    private static final String LOGGER_NAME = "BukkitSchedulerMock";
    private final ThreadPoolExecutor pool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private final ExecutorService asyncEventExecutor = Executors.newCachedThreadPool();
    private final List<Future<?>> queuedAsyncEvents = new ArrayList();
    private final TaskList scheduledTasks = new TaskList();
    private final List<BukkitWorker> activeWorkers = new ArrayList<BukkitWorker>();
    private final AtomicReference<Exception> asyncException = new AtomicReference();
    private long currentTick = 0L;
    private final AtomicInteger id = new AtomicInteger();
    private long executorTimeout = 60000L;
    private final List<BukkitWorker> overdueTasks = new ArrayList<BukkitWorker>();

    @NotNull
    private Runnable wrapTask(@NotNull ScheduledTask task) {
        return () -> {
            task.setRunning(true);
            if (!task.isSync()) {
                this.activeWorkers.add(task);
            }
            task.run();
            if (!task.isSync()) {
                this.activeWorkers.remove(task);
            }
            task.setRunning(false);
        };
    }

    public void setShutdownTimeout(long timeout) {
        this.executorTimeout = timeout;
    }

    public void shutdown() {
        this.waitAsyncTasksFinished();
        this.shutdownPool(this.pool);
        if (this.asyncException.get() != null) {
            throw new AsyncTaskException(this.asyncException.get());
        }
        this.waitAsyncEventsFinished();
        this.shutdownPool(this.asyncEventExecutor);
    }

    private void shutdownPool(@NotNull ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(this.executorTimeout, TimeUnit.MILLISECONDS)) {
                pool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @NotNull
    public Future<?> executeAsyncEvent(@NotNull Event event) {
        return this.executeAsyncEvent(event, null);
    }

    @NotNull
    public <T extends Event> Future<?> executeAsyncEvent(@NotNull T event, @Nullable Consumer<T> func) {
        MockBukkit.ensureMocking();
        Preconditions.checkNotNull(event, (Object)"Cannot call a null event!");
        Future<?> future = this.asyncEventExecutor.submit(() -> {
            MockBukkit.getMock().getPluginManager().callEvent(event);
            if (func != null) {
                func.accept(event);
            }
        });
        this.queuedAsyncEvents.add(future);
        return future;
    }

    public synchronized long getCurrentTick() {
        return this.currentTick;
    }

    public synchronized void performOneTick() {
        ++this.currentTick;
        List<ScheduledTask> oldTasks = this.scheduledTasks.getCurrentTaskList();
        for (ScheduledTask task : oldTasks) {
            if (task.getScheduledTick() != this.currentTick || task.isCancelled()) continue;
            if (task.isSync()) {
                this.wrapTask(task).run();
            } else {
                this.pool.submit(this.wrapTask(task));
                task.submitted();
            }
            if (task instanceof RepeatingTask) {
                RepeatingTask repeatingTask = (RepeatingTask)task;
                if (task.isCancelled()) continue;
                repeatingTask.updateScheduledTick();
                this.scheduledTasks.addTask(task);
                continue;
            }
            task.cancel();
        }
    }

    public void performTicks(long ticks) {
        for (long i = 0L; i < ticks; ++i) {
            this.performOneTick();
        }
    }

    public int getNumberOfQueuedAsyncTasks() {
        int queuedAsync = 0;
        for (ScheduledTask task : this.scheduledTasks.getCurrentTaskList()) {
            if (task.isSync() || task.isCancelled() || task.isRunning()) continue;
            ++queuedAsync;
        }
        return queuedAsync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAsyncTasksFinished() {
        Map<Integer, ScheduledTask> map = this.scheduledTasks.tasks;
        synchronized (map) {
            this.scheduledTasks.tasks.entrySet().stream().filter(entry -> entry.getValue() instanceof RepeatingTask).forEach(entry -> this.scheduledTasks.cancelTask((Integer)entry.getKey()));
            while (this.scheduledTasks.getScheduledTaskCount() > 0) {
                this.performOneTick();
            }
        }
        long systemTime = System.currentTimeMillis();
        while (this.pool.getActiveCount() > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            if (System.currentTimeMillis() <= systemTime + this.executorTimeout) continue;
            for (ScheduledTask task : this.scheduledTasks.getCurrentTaskList()) {
                if (!task.isRunning()) continue;
                task.cancel();
                this.cancelTask(task.getTaskId());
                throw new RuntimeException("Forced Cancellation of task owned by " + task.getOwner().getName());
            }
            this.pool.shutdownNow();
        }
    }

    public void waitAsyncEventsFinished() {
        for (Future<?> futureEvent : List.copyOf(this.queuedAsyncEvents)) {
            if (futureEvent.isDone()) {
                this.queuedAsyncEvents.remove(futureEvent);
                continue;
            }
            try {
                this.queuedAsyncEvents.remove(futureEvent);
                futureEvent.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @NotNull
    public synchronized BukkitTask runTask(@NotNull Plugin plugin, @NotNull Runnable task) {
        return this.runTaskLater(plugin, task, 1L);
    }

    @Deprecated(since="1.7.10")
    @NotNull
    public synchronized BukkitTask runTask(@NotNull Plugin plugin, @NotNull BukkitRunnable task) {
        return this.runTask(plugin, (Runnable)task);
    }

    @NotNull
    public synchronized BukkitTask runTaskLater(@NotNull Plugin plugin, @NotNull Runnable task, long delay) {
        delay = Math.max(delay, 1L);
        ScheduledTask scheduledTask = new ScheduledTask(this.id.getAndIncrement(), plugin, true, this.currentTick + delay, task);
        this.scheduledTasks.addTask(scheduledTask);
        return scheduledTask;
    }

    @NotNull
    public synchronized BukkitTask runTaskTimer(@NotNull Plugin plugin, @NotNull Runnable task, long delay, long period) {
        delay = Math.max(delay, 1L);
        RepeatingTask repeatingTask = new RepeatingTask(this.id.getAndIncrement(), plugin, true, this.currentTick + delay, period, task);
        this.scheduledTasks.addTask(repeatingTask);
        return repeatingTask;
    }

    @Deprecated(since="1.7.10")
    @NotNull
    public synchronized BukkitTask runTaskTimer(@NotNull Plugin plugin, @NotNull BukkitRunnable task, long delay, long period) {
        return this.runTaskTimer(plugin, (Runnable)task, delay, period);
    }

    public synchronized int scheduleSyncDelayedTask(@NotNull Plugin plugin, @NotNull Runnable task, long delay) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTaskLater instead of scheduleSyncDelayTask");
        return this.runTaskLater(plugin, task, delay).getTaskId();
    }

    @Deprecated(since="1.7.10")
    public synchronized int scheduleSyncDelayedTask(@NotNull Plugin plugin, @NotNull BukkitRunnable task, long delay) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTaskLater instead of scheduleSyncDelayTask");
        return this.runTaskLater(plugin, (Runnable)task, delay).getTaskId();
    }

    public synchronized int scheduleSyncDelayedTask(@NotNull Plugin plugin, @NotNull Runnable task) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTask instead of scheduleSyncDelayTask");
        return this.runTask(plugin, task).getTaskId();
    }

    @Deprecated(since="1.7.10")
    public synchronized int scheduleSyncDelayedTask(@NotNull Plugin plugin, @NotNull BukkitRunnable task) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTask instead of scheduleSyncDelayTask");
        return this.runTask(plugin, (Runnable)task).getTaskId();
    }

    public synchronized int scheduleSyncRepeatingTask(@NotNull Plugin plugin, @NotNull Runnable task, long delay, long period) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTaskTimer instead of scheduleSyncRepeatingTask");
        return this.runTaskTimer(plugin, task, delay, period).getTaskId();
    }

    @Deprecated(since="1.7.10")
    public synchronized int scheduleSyncRepeatingTask(@NotNull Plugin plugin, @NotNull BukkitRunnable task, long delay, long period) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTaskTimer instead of scheduleSyncRepeatingTask");
        return this.runTaskTimer(plugin, (Runnable)task, delay, period).getTaskId();
    }

    @Deprecated(since="1.5")
    public synchronized int scheduleAsyncDelayedTask(@NotNull Plugin plugin, @NotNull Runnable task, long delay) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTaskLaterAsynchronously instead of scheduleAsyncDelayedTask");
        return this.runTaskLaterAsynchronously(plugin, task, delay).getTaskId();
    }

    @Deprecated(since="1.5")
    public synchronized int scheduleAsyncDelayedTask(@NotNull Plugin plugin, @NotNull Runnable task) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTaskAsynchronously instead of scheduleAsyncDelayedTask");
        return this.runTaskAsynchronously(plugin, task).getTaskId();
    }

    @Deprecated(since="1.5")
    public synchronized int scheduleAsyncRepeatingTask(@NotNull Plugin plugin, @NotNull Runnable task, long delay, long period) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTaskTimerAsynchronously instead of scheduleAsyncRepeatingTask");
        return this.runTaskTimerAsynchronously(plugin, task, delay, period).getTaskId();
    }

    @NotNull
    public synchronized <T> Future<T> callSyncMethod(@NotNull Plugin plugin, @NotNull Callable<T> task) {
        throw new UnimplementedOperationException();
    }

    public void cancelTask(int taskId) {
        this.scheduledTasks.cancelTask(taskId);
    }

    public void cancelTasks(@NotNull Plugin plugin) {
        for (ScheduledTask task : this.scheduledTasks.getCurrentTaskList()) {
            if (!Objects.equals(task.getOwner(), plugin)) continue;
            task.cancel();
        }
    }

    public boolean isCurrentlyRunning(int taskId) {
        return this.scheduledTasks.tasks.containsKey(taskId);
    }

    public boolean isQueued(int taskId) {
        for (ScheduledTask task : this.scheduledTasks.getCurrentTaskList()) {
            if (task.getTaskId() != taskId) continue;
            return !task.isCancelled();
        }
        return false;
    }

    @NotNull
    public List<BukkitWorker> getActiveWorkers() {
        return this.activeWorkers;
    }

    @NotNull
    public List<BukkitTask> getPendingTasks() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public synchronized BukkitTask runTaskAsynchronously(@NotNull Plugin plugin, @NotNull Runnable task) {
        ScheduledTask scheduledTask = new ScheduledTask(this.id.getAndIncrement(), plugin, false, this.currentTick, new AsyncRunnable(task));
        this.pool.execute(this.wrapTask(scheduledTask));
        return scheduledTask;
    }

    @NotNull
    public synchronized BukkitTask runTaskAsynchronously(@NotNull Plugin plugin, @NotNull BukkitRunnable task) {
        return this.runTaskAsynchronously(plugin, (Runnable)task);
    }

    @NotNull
    public synchronized BukkitTask runTaskLater(@NotNull Plugin plugin, @NotNull BukkitRunnable task, long delay) {
        return this.runTaskLater(plugin, (Runnable)task, delay);
    }

    @NotNull
    public synchronized BukkitTask runTaskLaterAsynchronously(@NotNull Plugin plugin, @NotNull Runnable task, long delay) {
        delay = Math.max(delay, 1L);
        ScheduledTask scheduledTask = new ScheduledTask(this.id.getAndIncrement(), plugin, false, this.currentTick + delay, new AsyncRunnable(task));
        this.scheduledTasks.addTask(scheduledTask);
        return scheduledTask;
    }

    @NotNull
    public synchronized BukkitTask runTaskLaterAsynchronously(@NotNull Plugin plugin, @NotNull BukkitRunnable task, long delay) {
        return this.runTaskLaterAsynchronously(plugin, (Runnable)task, delay);
    }

    @NotNull
    public synchronized BukkitTask runTaskTimerAsynchronously(@NotNull Plugin plugin, @NotNull Runnable task, long delay, long period) {
        delay = Math.max(delay, 1L);
        RepeatingTask scheduledTask = new RepeatingTask(this.id.getAndIncrement(), plugin, false, this.currentTick + delay, period, new AsyncRunnable(task));
        this.scheduledTasks.addTask(scheduledTask);
        return scheduledTask;
    }

    @NotNull
    public synchronized BukkitTask runTaskTimerAsynchronously(@NotNull Plugin plugin, @NotNull BukkitRunnable task, long delay, long period) {
        return this.runTaskTimerAsynchronously(plugin, (Runnable)task, delay, period);
    }

    public synchronized void runTask(@NotNull Plugin plugin, @NotNull Consumer<? super BukkitTask> task) {
        this.runTaskLater(plugin, task, 0L);
    }

    public synchronized void runTaskAsynchronously(@NotNull Plugin plugin, @NotNull Consumer<? super BukkitTask> task) {
        ScheduledTask scheduledTask = new ScheduledTask(this.id.getAndIncrement(), plugin, false, this.currentTick, task);
        this.pool.execute(this.wrapTask(scheduledTask));
    }

    public synchronized void runTaskLater(@NotNull Plugin plugin, @NotNull Consumer<? super BukkitTask> task, long delay) {
        delay = Math.max(delay, 1L);
        ScheduledTask scheduledTask = new ScheduledTask(this.id.getAndIncrement(), plugin, true, this.currentTick + delay, task);
        this.scheduledTasks.addTask(scheduledTask);
    }

    public synchronized void runTaskLaterAsynchronously(@NotNull Plugin plugin, @NotNull Consumer<? super BukkitTask> task, long delay) {
        throw new UnimplementedOperationException();
    }

    public synchronized void runTaskTimer(@NotNull Plugin plugin, @NotNull Consumer<? super BukkitTask> task, long delay, long period) {
        delay = Math.max(delay, 1L);
        RepeatingTask repeatingTask = new RepeatingTask(this.id.getAndIncrement(), plugin, true, this.currentTick + delay, period, task);
        this.scheduledTasks.addTask(repeatingTask);
    }

    public synchronized void runTaskTimerAsynchronously(@NotNull Plugin plugin, @NotNull Consumer<? super BukkitTask> task, long delay, long period) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Executor getMainThreadExecutor(@NotNull Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin cannot be null");
        return command -> {
            Preconditions.checkNotNull((Object)command, (Object)"Command cannot be null");
            this.runTask(plugin, command);
        };
    }

    protected int getActiveRunningCount() {
        return this.pool.getActiveCount();
    }

    public void saveOverdueTasks() {
        this.overdueTasks.clear();
        this.overdueTasks.addAll(this.getActiveWorkers());
    }

    @NotNull
    public @UnmodifiableView List<BukkitWorker> getOverdueTasks() {
        return Collections.unmodifiableList(this.overdueTasks);
    }

    public void assertNoOverdueTasks() {
        if (!this.overdueTasks.isEmpty()) {
            throw new AssertionFailedError("There are overdue tasks: " + String.valueOf(this.overdueTasks));
        }
    }

    private static class TaskList {
        @NotNull
        private final Map<Integer, ScheduledTask> tasks = Collections.synchronizedMap(new HashMap());

        private TaskList() {
        }

        private boolean addTask(@Nullable ScheduledTask task) {
            if (task == null) {
                return false;
            }
            this.tasks.put(task.getTaskId(), task);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        protected final List<ScheduledTask> getCurrentTaskList() {
            ArrayList<ScheduledTask> out = new ArrayList<ScheduledTask>();
            Map<Integer, ScheduledTask> map = this.tasks;
            synchronized (map) {
                if (this.tasks.size() != 0) {
                    out.addAll(this.tasks.values());
                }
            }
            return out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int getScheduledTaskCount() {
            int scheduled = 0;
            Map<Integer, ScheduledTask> map = this.tasks;
            synchronized (map) {
                if (this.tasks.size() == 0) {
                    return 0;
                }
                for (ScheduledTask task : this.tasks.values()) {
                    if (task.isCancelled() || task.isRunning()) continue;
                    ++scheduled;
                }
            }
            return scheduled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean cancelTask(int taskID) {
            Map<Integer, ScheduledTask> map = this.tasks;
            synchronized (map) {
                ScheduledTask task = this.tasks.get(taskID);
                if (task != null) {
                    task.cancel();
                    return true;
                }
            }
            return false;
        }
    }

    private final class AsyncRunnable
    implements Runnable {
        private final Runnable task;

        private AsyncRunnable(Runnable task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                this.task.run();
            }
            catch (Exception t) {
                BukkitSchedulerMock.this.asyncException.set(t);
            }
        }
    }
}

