/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.MockPlugin;
import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.plugin.PluginManagerMock;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockBukkit {
    @Nullable
    private static ServerMock mock = null;

    private MockBukkit() {
        throw new UnsupportedOperationException("Utility class");
    }

    protected static void setServerInstanceToNull() {
        try {
            Field server = Bukkit.class.getDeclaredField("server");
            server.setAccessible(true);
            server.set(null, null);
            mock = null;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static ServerMock mock() {
        return MockBukkit.mock(new ServerMock());
    }

    @NotNull
    public static <T extends ServerMock> T mock(@NotNull T serverMockImplementation) {
        if (mock != null) {
            throw new IllegalStateException("Already mocking");
        }
        mock = serverMockImplementation;
        Level defaultLevel = mock.getLogger().getLevel();
        mock.getLogger().setLevel(Level.WARNING);
        Bukkit.setServer((Server)mock);
        mock.getLogger().setLevel(defaultLevel);
        return serverMockImplementation;
    }

    @Nullable
    public static ServerMock getOrCreateMock() {
        if (!MockBukkit.isMocked()) {
            MockBukkit.mock();
        }
        return mock;
    }

    @Nullable
    public static ServerMock getMock() {
        return mock;
    }

    public static boolean isMocked() {
        return mock != null;
    }

    public static Plugin loadJar(@NotNull String path) {
        try {
            return MockBukkit.loadJar(new File(path));
        }
        catch (InvalidPluginException e) {
            throw new RuntimeException(e);
        }
    }

    public static Plugin loadJar(@NotNull File jarFile) throws InvalidPluginException {
        return mock.getPluginManager().loadPlugin(jarFile);
    }

    @NotNull
    public static <T extends JavaPlugin> T load(@NotNull Class<T> plugin) {
        return MockBukkit.load(plugin, new Object[0]);
    }

    @NotNull
    public static <T extends JavaPlugin> T load(@NotNull Class<T> plugin, Object ... parameters) {
        MockBukkit.ensureMocking();
        PluginManagerMock pluginManager = mock.getPluginManager();
        JavaPlugin instance = pluginManager.loadPlugin(plugin, parameters);
        return MockBukkit.processFinalLoad(plugin, instance, pluginManager);
    }

    @NotNull
    public static <T extends JavaPlugin> T loadWith(@NotNull Class<T> plugin, @NotNull PluginDescriptionFile descriptionFile, Object ... parameters) {
        MockBukkit.ensureMocking();
        JavaPlugin instance = mock.getPluginManager().loadPlugin(plugin, descriptionFile, parameters);
        mock.getPluginManager().enablePlugin((Plugin)instance);
        return (T)((JavaPlugin)plugin.cast(instance));
    }

    @NotNull
    public static <T extends JavaPlugin> T loadWith(@NotNull Class<T> plugin, @NotNull InputStream descriptionInput, Object ... parameters) {
        try {
            return MockBukkit.loadWith(plugin, new PluginDescriptionFile(descriptionInput), parameters);
        }
        catch (InvalidDescriptionException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static <T extends JavaPlugin> T loadWith(@NotNull Class<T> plugin, @NotNull File descriptionFile, Object ... parameters) {
        try {
            return MockBukkit.loadWith(plugin, new FileInputStream(descriptionFile), parameters);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static <T extends JavaPlugin> T loadWith(@NotNull Class<T> plugin, String descriptionFileName, Object ... parameters) {
        return MockBukkit.loadWith(plugin, ClassLoader.getSystemResourceAsStream(descriptionFileName), parameters);
    }

    @NotNull
    public static <T extends JavaPlugin> T loadWithConfig(@NotNull Class<T> plugin, InputStream configStream, Object ... parameters) {
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load((Reader)new InputStreamReader(configStream));
        }
        catch (IOException | InvalidConfigurationException e) {
            throw new RuntimeException("Couldn't read config input stream", e);
        }
        return MockBukkit.loadWithConfig(plugin, (FileConfiguration)config, parameters);
    }

    @NotNull
    public static <T extends JavaPlugin> T loadWithConfig(@NotNull Class<T> plugin, File configFile, Object ... parameters) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        return MockBukkit.loadWithConfig(plugin, (FileConfiguration)config, parameters);
    }

    @NotNull
    public static <T extends JavaPlugin> T loadWithConfig(@NotNull Class<T> plugin, FileConfiguration fileConfiguration, Object ... parameters) {
        MockBukkit.ensureMocking();
        PluginManagerMock pluginManager = mock.getPluginManager();
        JavaPlugin instance = pluginManager.loadPlugin(plugin, parameters);
        try {
            Field configField = JavaPlugin.class.getDeclaredField("newConfig");
            configField.setAccessible(true);
            configField.set(instance, fileConfiguration);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Can't load config", e);
        }
        return MockBukkit.processFinalLoad(plugin, instance, pluginManager);
    }

    @NotNull
    private static <T extends JavaPlugin> T processFinalLoad(@NotNull Class<T> plugin, JavaPlugin instance, PluginManagerMock pluginManager) {
        List permissionList = instance.getDescription().getPermissions();
        ArrayList<Permission> permissionsToLoad = new ArrayList<Permission>();
        permissionList.stream().filter(permission -> pluginManager.getPermission(permission.getName()) == null).forEach(permissionsToLoad::add);
        pluginManager.addPermissions(permissionsToLoad);
        pluginManager.enablePlugin((Plugin)instance);
        return (T)((JavaPlugin)plugin.cast(instance));
    }

    @NotNull
    public static <T extends JavaPlugin> T loadSimple(@NotNull Class<T> plugin, Object ... parameters) {
        MockBukkit.ensureMocking();
        PluginDescriptionFile description = new PluginDescriptionFile(plugin.getSimpleName(), "1.0.0", plugin.getCanonicalName());
        JavaPlugin instance = mock.getPluginManager().loadPlugin(plugin, description, parameters);
        mock.getPluginManager().enablePlugin((Plugin)instance);
        return (T)((JavaPlugin)plugin.cast(instance));
    }

    public static void unmock() {
        if (mock == null) {
            return;
        }
        if (mock.getPluginManager() != null) {
            mock.getPluginManager().disablePlugins();
        }
        try {
            mock.getScheduler().shutdown();
        }
        finally {
            mock.getPluginManager().unload();
            MockBukkit.setServerInstanceToNull();
        }
    }

    @NotNull
    public static MockPlugin createMockPlugin() {
        return MockBukkit.createMockPlugin("MockPlugin");
    }

    @NotNull
    public static MockPlugin createMockPlugin(@NotNull String pluginName) {
        return MockBukkit.createMockPlugin(pluginName, "1.0.0");
    }

    @NotNull
    public static MockPlugin createMockPlugin(@NotNull String pluginName, @NotNull String pluginVersion) {
        MockBukkit.ensureMocking();
        PluginDescriptionFile description = new PluginDescriptionFile(pluginName, pluginVersion, MockPlugin.class.getName());
        JavaPlugin instance = mock.getPluginManager().loadPlugin(MockPlugin.class, description, new Object[0]);
        mock.getPluginManager().enablePlugin((Plugin)instance);
        return (MockPlugin)instance;
    }

    public static void ensureMocking() {
        if (!MockBukkit.isMocked()) {
            throw new IllegalStateException("Not mocking");
        }
    }
}

