/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.ServerMock;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Optional;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class MockPlugin
extends JavaPlugin {
    public MockPlugin() {
    }

    protected MockPlugin(@NotNull JavaPluginLoader loader, @NotNull PluginDescriptionFile description, @NotNull File dataFolder, @NotNull File file) {
        super(loader, description, dataFolder, file);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Optional<Runnable> onLoad = Optional.empty();
        private Optional<Runnable> onEnable = Optional.empty();
        private Optional<Runnable> onDisable = Optional.empty();
        private String pluginName = "MockPlugin";
        private String pluginVersion = "1.0.0";

        private Builder() {
        }

        public Builder withOnLoad(@NotNull Runnable onLoad) {
            this.onLoad = Optional.of(onLoad);
            return this;
        }

        public Builder withOnEnable(@NotNull Runnable onEnable) {
            this.onEnable = Optional.of(onEnable);
            return this;
        }

        public Builder withOnDisable(@NotNull Runnable onDisable) {
            this.onDisable = Optional.of(onDisable);
            return this;
        }

        public Builder withPluginName(@NotNull String name) {
            Preconditions.checkNotNull((Object)name);
            this.pluginName = name;
            return this;
        }

        public Builder withPluginVersion(@NotNull String version) {
            Preconditions.checkNotNull((Object)version);
            this.pluginVersion = version;
            return this;
        }

        public MockPlugin build() {
            MockBukkit.ensureMocking();
            PluginDescriptionFile description = new PluginDescriptionFile(this.pluginName, this.pluginVersion, InternalMockPlugin.class.getName());
            ServerMock mock = MockBukkit.getMock();
            JavaPlugin instance = mock.getPluginManager().loadPlugin(InternalMockPlugin.class, description, new Object[]{this.onEnable, this.onDisable, this.onLoad});
            mock.getPluginManager().enablePlugin((Plugin)instance);
            return (MockPlugin)instance;
        }
    }

    @ApiStatus.Internal
    public static class InternalMockPlugin
    extends MockPlugin {
        private final Optional<Runnable> onEnable;
        private final Optional<Runnable> onDisable;
        private final Optional<Runnable> onLoad;

        public InternalMockPlugin(Optional<Runnable> onEnable, Optional<Runnable> onDisable, Optional<Runnable> onLoad) {
            this.onEnable = onEnable;
            this.onDisable = onDisable;
            this.onLoad = onLoad;
        }

        public void onEnable() {
            this.onEnable.ifPresent(Runnable::run);
        }

        public void onDisable() {
            this.onDisable.ifPresent(Runnable::run);
        }

        public void onLoad() {
            this.onLoad.ifPresent(Runnable::run);
        }
    }
}

