/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.boss.BossBarMock;
import be.seeseemelk.mockbukkit.persistence.PersistentDataContainerMock;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Difficulty;
import org.bukkit.Location;
import org.bukkit.Raid;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Raider;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;

public class RaidMock
implements Raid {
    private static final int MAXIMUM_BAD_OMEN_LEVEL = 5;
    private static final String BOSS_BAR_TITLE = "Raid";
    private final int id;
    private final Location location;
    private final BossBar bossBar = new BossBarMock("Raid", BarColor.RED, BarStyle.SEGMENTED_10, new BarFlag[0]);
    private final PersistentDataContainer persistentDataContainer = new PersistentDataContainerMock();
    private Set<UUID> heroes = Collections.emptySet();
    private List<Raider> raiders = Collections.emptyList();
    private boolean started;
    private long activeTicks;
    private int badOmenLevel;
    private int spawnedGroups;
    private int waves;
    private Raid.RaidStatus status = Raid.RaidStatus.ONGOING;

    public RaidMock(int id, Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        this.id = id;
        this.location = location;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public long getActiveTicks() {
        return this.activeTicks;
    }

    public void setActiveTicks(long activeTicks) {
        Preconditions.checkArgument((activeTicks >= 0L ? 1 : 0) != 0, (Object)"active ticks cannot be negative");
        this.activeTicks = activeTicks;
    }

    public int getBadOmenLevel() {
        return this.badOmenLevel;
    }

    public void setBadOmenLevel(int badOmenLevel) {
        Preconditions.checkArgument((0 <= badOmenLevel && badOmenLevel <= 5 ? 1 : 0) != 0, (String)"Bad Omen level must be between 0 and %s", (int)5);
        this.badOmenLevel = badOmenLevel;
    }

    @NotNull
    public Location getLocation() {
        return this.location;
    }

    @NotNull
    public Raid.RaidStatus getStatus() {
        return this.status;
    }

    public void setStatus(Raid.RaidStatus status) {
        Preconditions.checkArgument((status != null ? 1 : 0) != 0, (Object)"status cannot be null");
        this.status = status;
    }

    public int getSpawnedGroups() {
        return this.spawnedGroups;
    }

    public void setSpawnedGroups(int spawnedGroups) {
        Preconditions.checkArgument((spawnedGroups >= 0 ? 1 : 0) != 0, (Object)"spawnedGroups cannot be negative");
        this.spawnedGroups = spawnedGroups;
    }

    public int getTotalGroups() {
        return this.waves + (this.getBadOmenLevel() > 1 ? 1 : 0);
    }

    public int getTotalWaves() {
        return this.waves;
    }

    public void setWaves(int waves) {
        Preconditions.checkArgument((waves >= 0 ? 1 : 0) != 0, (Object)"waves cannot be negative");
        this.waves = waves;
    }

    public void setWaves(Difficulty difficulty) {
        Preconditions.checkArgument((difficulty != null ? 1 : 0) != 0, (Object)"difficulty cannot be null");
        switch (difficulty) {
            case EASY: {
                this.setWaves(3);
                break;
            }
            case NORMAL: {
                this.setWaves(5);
                break;
            }
            case HARD: {
                this.setWaves(7);
                break;
            }
            default: {
                this.setWaves(0);
            }
        }
    }

    public float getTotalHealth() {
        double totalHealth = 0.0;
        for (Raider raider : this.getRaiders()) {
            totalHealth += raider.getHealth();
        }
        return (float)totalHealth;
    }

    @NotNull
    public Set<UUID> getHeroes() {
        return Collections.unmodifiableSet(this.heroes);
    }

    public void setHeroes(Set<UUID> heroes) {
        Preconditions.checkArgument((heroes != null ? 1 : 0) != 0, (Object)"Heroes cannot be null");
        this.heroes = heroes;
    }

    @NotNull
    public List<Raider> getRaiders() {
        return Collections.unmodifiableList(this.raiders);
    }

    public void setRaiders(List<Raider> raiders) {
        Preconditions.checkArgument((raiders != null ? 1 : 0) != 0, (Object)"Raiders cannot be null");
        this.raiders = raiders;
    }

    public int getId() {
        return this.id;
    }

    @NotNull
    public BossBar getBossBar() {
        return this.bossBar;
    }

    @NotNull
    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }
}

