/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.AsyncCatcher;
import be.seeseemelk.mockbukkit.ChunkCoordinate;
import be.seeseemelk.mockbukkit.ChunkMock;
import be.seeseemelk.mockbukkit.ChunkSnapshotMock;
import be.seeseemelk.mockbukkit.Coordinate;
import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.WorldBorderMock;
import be.seeseemelk.mockbukkit.block.BlockMock;
import be.seeseemelk.mockbukkit.block.data.BlockDataMock;
import be.seeseemelk.mockbukkit.entity.AllayMock;
import be.seeseemelk.mockbukkit.entity.AreaEffectCloudMock;
import be.seeseemelk.mockbukkit.entity.ArmadilloMock;
import be.seeseemelk.mockbukkit.entity.ArmorStandMock;
import be.seeseemelk.mockbukkit.entity.ArrowMock;
import be.seeseemelk.mockbukkit.entity.AxolotlMock;
import be.seeseemelk.mockbukkit.entity.BatMock;
import be.seeseemelk.mockbukkit.entity.BeeMock;
import be.seeseemelk.mockbukkit.entity.BlazeMock;
import be.seeseemelk.mockbukkit.entity.BlockDisplayMock;
import be.seeseemelk.mockbukkit.entity.BoatMock;
import be.seeseemelk.mockbukkit.entity.BoggedMock;
import be.seeseemelk.mockbukkit.entity.BreezeMock;
import be.seeseemelk.mockbukkit.entity.BreezeWindChargeMock;
import be.seeseemelk.mockbukkit.entity.CamelMock;
import be.seeseemelk.mockbukkit.entity.CatMock;
import be.seeseemelk.mockbukkit.entity.CaveSpiderMock;
import be.seeseemelk.mockbukkit.entity.ChestBoatMock;
import be.seeseemelk.mockbukkit.entity.ChickenMock;
import be.seeseemelk.mockbukkit.entity.CodMock;
import be.seeseemelk.mockbukkit.entity.CommandMinecartMock;
import be.seeseemelk.mockbukkit.entity.CowMock;
import be.seeseemelk.mockbukkit.entity.CreeperMock;
import be.seeseemelk.mockbukkit.entity.DolphinMock;
import be.seeseemelk.mockbukkit.entity.DonkeyMock;
import be.seeseemelk.mockbukkit.entity.DragonFireballMock;
import be.seeseemelk.mockbukkit.entity.DrownedMock;
import be.seeseemelk.mockbukkit.entity.EggMock;
import be.seeseemelk.mockbukkit.entity.ElderGuardianMock;
import be.seeseemelk.mockbukkit.entity.EnderCrystalMock;
import be.seeseemelk.mockbukkit.entity.EnderPearlMock;
import be.seeseemelk.mockbukkit.entity.EnderSignalMock;
import be.seeseemelk.mockbukkit.entity.EndermanMock;
import be.seeseemelk.mockbukkit.entity.EndermiteMock;
import be.seeseemelk.mockbukkit.entity.EntityMock;
import be.seeseemelk.mockbukkit.entity.EvokerFangsMock;
import be.seeseemelk.mockbukkit.entity.EvokerMock;
import be.seeseemelk.mockbukkit.entity.ExperienceOrbMock;
import be.seeseemelk.mockbukkit.entity.ExplosiveMinecartMock;
import be.seeseemelk.mockbukkit.entity.FallingBlockMock;
import be.seeseemelk.mockbukkit.entity.FireworkMock;
import be.seeseemelk.mockbukkit.entity.FishHookMock;
import be.seeseemelk.mockbukkit.entity.FoxMock;
import be.seeseemelk.mockbukkit.entity.FrogMock;
import be.seeseemelk.mockbukkit.entity.GhastMock;
import be.seeseemelk.mockbukkit.entity.GiantMock;
import be.seeseemelk.mockbukkit.entity.GlowItemFrameMock;
import be.seeseemelk.mockbukkit.entity.GlowSquidMock;
import be.seeseemelk.mockbukkit.entity.GoatMock;
import be.seeseemelk.mockbukkit.entity.GuardianMock;
import be.seeseemelk.mockbukkit.entity.HopperMinecartMock;
import be.seeseemelk.mockbukkit.entity.HorseMock;
import be.seeseemelk.mockbukkit.entity.HuskMock;
import be.seeseemelk.mockbukkit.entity.IllusionerMock;
import be.seeseemelk.mockbukkit.entity.InteractionMock;
import be.seeseemelk.mockbukkit.entity.IronGolemMock;
import be.seeseemelk.mockbukkit.entity.ItemDisplayMock;
import be.seeseemelk.mockbukkit.entity.ItemEntityMock;
import be.seeseemelk.mockbukkit.entity.ItemFrameMock;
import be.seeseemelk.mockbukkit.entity.LargeFireballMock;
import be.seeseemelk.mockbukkit.entity.LeashHitchMock;
import be.seeseemelk.mockbukkit.entity.LlamaMock;
import be.seeseemelk.mockbukkit.entity.LlamaSpitMock;
import be.seeseemelk.mockbukkit.entity.MagmaCubeMock;
import be.seeseemelk.mockbukkit.entity.MarkerMock;
import be.seeseemelk.mockbukkit.entity.MobMock;
import be.seeseemelk.mockbukkit.entity.MuleMock;
import be.seeseemelk.mockbukkit.entity.MushroomCowMock;
import be.seeseemelk.mockbukkit.entity.OcelotMock;
import be.seeseemelk.mockbukkit.entity.PandaMock;
import be.seeseemelk.mockbukkit.entity.ParrotMock;
import be.seeseemelk.mockbukkit.entity.PigMock;
import be.seeseemelk.mockbukkit.entity.PigZombieMock;
import be.seeseemelk.mockbukkit.entity.PillagerMock;
import be.seeseemelk.mockbukkit.entity.PolarBearMock;
import be.seeseemelk.mockbukkit.entity.PoweredMinecartMock;
import be.seeseemelk.mockbukkit.entity.PufferFishMock;
import be.seeseemelk.mockbukkit.entity.RabbitMock;
import be.seeseemelk.mockbukkit.entity.RavagerMock;
import be.seeseemelk.mockbukkit.entity.RideableMinecartMock;
import be.seeseemelk.mockbukkit.entity.SalmonMock;
import be.seeseemelk.mockbukkit.entity.SheepMock;
import be.seeseemelk.mockbukkit.entity.ShulkerMock;
import be.seeseemelk.mockbukkit.entity.SilverfishMock;
import be.seeseemelk.mockbukkit.entity.SkeletonHorseMock;
import be.seeseemelk.mockbukkit.entity.SkeletonMock;
import be.seeseemelk.mockbukkit.entity.SlimeMock;
import be.seeseemelk.mockbukkit.entity.SmallFireballMock;
import be.seeseemelk.mockbukkit.entity.SnowballMock;
import be.seeseemelk.mockbukkit.entity.SnowmanMock;
import be.seeseemelk.mockbukkit.entity.SpawnerMinecartMock;
import be.seeseemelk.mockbukkit.entity.SpectralArrowMock;
import be.seeseemelk.mockbukkit.entity.SpiderMock;
import be.seeseemelk.mockbukkit.entity.SquidMock;
import be.seeseemelk.mockbukkit.entity.StorageMinecartMock;
import be.seeseemelk.mockbukkit.entity.StrayMock;
import be.seeseemelk.mockbukkit.entity.TadpoleMock;
import be.seeseemelk.mockbukkit.entity.ThrownExpBottleMock;
import be.seeseemelk.mockbukkit.entity.ThrownPotionMock;
import be.seeseemelk.mockbukkit.entity.TridentMock;
import be.seeseemelk.mockbukkit.entity.TropicalFishMock;
import be.seeseemelk.mockbukkit.entity.TurtleMock;
import be.seeseemelk.mockbukkit.entity.VindicatorMock;
import be.seeseemelk.mockbukkit.entity.WardenMock;
import be.seeseemelk.mockbukkit.entity.WindChargeMock;
import be.seeseemelk.mockbukkit.entity.WitchMock;
import be.seeseemelk.mockbukkit.entity.WitherSkeletonMock;
import be.seeseemelk.mockbukkit.entity.WitherSkullMock;
import be.seeseemelk.mockbukkit.entity.WolfMock;
import be.seeseemelk.mockbukkit.entity.ZoglinMock;
import be.seeseemelk.mockbukkit.entity.ZombieHorseMock;
import be.seeseemelk.mockbukkit.entity.ZombieMock;
import be.seeseemelk.mockbukkit.generator.BiomeProviderMock;
import be.seeseemelk.mockbukkit.metadata.MetadataTable;
import be.seeseemelk.mockbukkit.persistence.PersistentDataContainerMock;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.papermc.paper.block.fluid.FluidData;
import io.papermc.paper.event.world.WorldGameRuleChangeEvent;
import io.papermc.paper.math.Position;
import io.papermc.paper.world.MoonPhase;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Difficulty;
import org.bukkit.Effect;
import org.bukkit.FeatureFlag;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameEvent;
import org.bukkit.GameRule;
import org.bukkit.HeightMap;
import org.bukkit.Instrument;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.Particle;
import org.bukkit.Raid;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.StructureType;
import org.bukkit.Tag;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.boss.DragonBattle;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Animals;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Armadillo;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Bogged;
import org.bukkit.entity.Breeze;
import org.bukkit.entity.BreezeWindCharge;
import org.bukkit.entity.Camel;
import org.bukkit.entity.Cat;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.ChestBoat;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cod;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Egg;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Firework;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.GlowSquid;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Husk;
import org.bukkit.entity.Illusioner;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.LeashHitch;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Marker;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Mule;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Pillager;
import org.bukkit.entity.Player;
import org.bukkit.entity.PolarBear;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Ravager;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Slime;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Squid;
import org.bukkit.entity.Stray;
import org.bukkit.entity.Tadpole;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Trident;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Turtle;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.Warden;
import org.bukkit.entity.WaterMob;
import org.bukkit.entity.WindCharge;
import org.bukkit.entity.Witch;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zoglin;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieHorse;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.entity.minecart.SpawnerMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.structure.GeneratedStructure;
import org.bukkit.generator.structure.Structure;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.util.BiomeSearchResult;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.StructureSearchResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldMock
implements World {
    private static final int SEA_LEVEL = 63;
    private final Map<Coordinate, BlockMock> blocks = new HashMap<Coordinate, BlockMock>();
    private final Map<GameRule<?>, Object> gameRules = new HashMap();
    private final MetadataTable metadataTable = new MetadataTable();
    private final Map<ChunkCoordinate, ChunkMock> loadedChunks = new HashMap<ChunkCoordinate, ChunkMock>();
    private final Map<ChunkCoordinate, ChunkMock> savedChunks = new HashMap<ChunkCoordinate, ChunkMock>();
    private final PersistentDataContainer persistentDataContainer = new PersistentDataContainerMock();
    @Nullable
    private final ServerMock server;
    private final Material defaultBlock;
    private final Biome defaultBiome;
    private final int grassHeight;
    private final int minHeight;
    private final int maxHeight;
    private WorldBorderMock worldBorder;
    private final UUID uuid = UUID.randomUUID();
    private World.Environment environment = World.Environment.NORMAL;
    private String name = "World";
    private Location spawnLocation;
    private long fullTime = 0L;
    private int weatherDuration;
    private boolean thundering;
    private int thunderDuration;
    private boolean storming;
    private int clearWeatherDuration;
    private long seed = 0L;
    @NotNull
    private WorldType worldType = WorldType.NORMAL;
    private final BiomeProviderMock biomeProviderMock = new BiomeProviderMock();
    @NotNull
    private final Map<Coordinate, Biome> biomes = new HashMap<Coordinate, Biome>();
    @NotNull
    private Difficulty difficulty = Difficulty.NORMAL;
    private boolean allowAnimals = true;
    private boolean allowMonsters = true;
    private boolean pvp;
    private boolean hardcore;
    private boolean getKeepSpawnInMemory = true;
    private final Object2LongOpenHashMap<SpawnCategory> ticksPerSpawn = new Object2LongOpenHashMap();
    private final Object2IntOpenHashMap<SpawnCategory> spawnLimits = new Object2IntOpenHashMap();

    public WorldMock(Material defaultBlock, int minHeight, int maxHeight, int grassHeight) {
        this(defaultBlock, Biome.PLAINS, minHeight, maxHeight, grassHeight);
    }

    public WorldMock(Material defaultBlock, Biome defaultBiome, int minHeight, int maxHeight, int grassHeight) {
        this.defaultBlock = defaultBlock;
        this.defaultBiome = defaultBiome;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.grassHeight = grassHeight;
        this.server = MockBukkit.getMock();
        if (this.server != null) {
            this.pvp = this.server.getServerConfiguration().isPvpEnabled();
            this.ticksPerSpawn.putAll(this.server.getServerConfiguration().getTicksPerSpawn());
            this.spawnLimits.putAll(this.server.getServerConfiguration().getSpawnLimits());
        } else {
            this.pvp = true;
            this.ticksPerSpawn.put((Object)SpawnCategory.ANIMAL, 400L);
            this.ticksPerSpawn.put((Object)SpawnCategory.MONSTER, 1L);
            this.ticksPerSpawn.put((Object)SpawnCategory.WATER_AMBIENT, 1L);
            this.ticksPerSpawn.put((Object)SpawnCategory.WATER_UNDERGROUND_CREATURE, 1L);
            this.ticksPerSpawn.put((Object)SpawnCategory.WATER_ANIMAL, 1L);
            this.ticksPerSpawn.put((Object)SpawnCategory.AMBIENT, 1L);
            this.spawnLimits.put((Object)SpawnCategory.MONSTER, 70);
            this.spawnLimits.put((Object)SpawnCategory.ANIMAL, 10);
            this.spawnLimits.put((Object)SpawnCategory.WATER_ANIMAL, 5);
            this.spawnLimits.put((Object)SpawnCategory.WATER_AMBIENT, 20);
            this.spawnLimits.put((Object)SpawnCategory.WATER_UNDERGROUND_CREATURE, 5);
            this.spawnLimits.put((Object)SpawnCategory.AMBIENT, 15);
        }
        this.gameRules.put(GameRule.ANNOUNCE_ADVANCEMENTS, true);
        this.gameRules.put(GameRule.COMMAND_BLOCK_OUTPUT, true);
        this.gameRules.put(GameRule.DISABLE_ELYTRA_MOVEMENT_CHECK, false);
        this.gameRules.put(GameRule.DO_DAYLIGHT_CYCLE, true);
        this.gameRules.put(GameRule.DO_ENTITY_DROPS, true);
        this.gameRules.put(GameRule.DO_FIRE_TICK, true);
        this.gameRules.put(GameRule.DO_LIMITED_CRAFTING, false);
        this.gameRules.put(GameRule.DO_MOB_LOOT, true);
        this.gameRules.put(GameRule.DO_MOB_SPAWNING, true);
        this.gameRules.put(GameRule.DO_TILE_DROPS, true);
        this.gameRules.put(GameRule.DO_WEATHER_CYCLE, true);
        this.gameRules.put(GameRule.KEEP_INVENTORY, false);
        this.gameRules.put(GameRule.LOG_ADMIN_COMMANDS, true);
        this.gameRules.put(GameRule.MAX_COMMAND_CHAIN_LENGTH, 65536);
        this.gameRules.put(GameRule.MAX_ENTITY_CRAMMING, 24);
        this.gameRules.put(GameRule.MOB_GRIEFING, true);
        this.gameRules.put(GameRule.NATURAL_REGENERATION, true);
        this.gameRules.put(GameRule.RANDOM_TICK_SPEED, 3);
        this.gameRules.put(GameRule.REDUCED_DEBUG_INFO, false);
        this.gameRules.put(GameRule.SEND_COMMAND_FEEDBACK, true);
        this.gameRules.put(GameRule.SHOW_DEATH_MESSAGES, true);
        this.gameRules.put(GameRule.SPAWN_RADIUS, 10);
        this.gameRules.put(GameRule.SPECTATORS_GENERATE_CHUNKS, true);
    }

    public WorldMock(@NotNull WorldCreator creator) {
        this();
        this.name = creator.name();
        this.worldType = creator.type();
        this.seed = creator.seed();
        this.environment = creator.environment();
    }

    public WorldMock(Material defaultBlock, Biome defaultBiome, int maxHeight, int grassHeight) {
        this(defaultBlock, defaultBiome, 0, maxHeight, grassHeight);
    }

    public WorldMock(Material defaultBlock, int maxHeight, int grassHeight) {
        this(defaultBlock, 0, maxHeight, grassHeight);
    }

    public WorldMock(Material defaultBlock, int grassHeight) {
        this(defaultBlock, 128, grassHeight);
    }

    public WorldMock() {
        this(Material.GRASS_BLOCK, 4);
    }

    @NotNull
    public BlockMock createBlock(@NotNull Coordinate c) {
        if (c.y >= this.maxHeight) {
            throw new ArrayIndexOutOfBoundsException("Y larger than max height");
        }
        if (c.y < this.minHeight) {
            throw new ArrayIndexOutOfBoundsException("Y smaller than min height");
        }
        Location location = new Location((World)this, (double)c.x, (double)c.y, (double)c.z);
        BlockMock block = c.y == this.minHeight ? new BlockMock(Material.BEDROCK, location) : (c.y <= this.grassHeight ? new BlockMock(this.defaultBlock, location) : new BlockMock(location));
        this.blocks.put(c, block);
        return block;
    }

    public boolean isVoidDamageEnabled() {
        throw new UnimplementedOperationException();
    }

    public void setVoidDamageEnabled(boolean b) {
        throw new UnimplementedOperationException();
    }

    public float getVoidDamageAmount() {
        throw new UnimplementedOperationException();
    }

    public void setVoidDamageAmount(float v) {
        throw new UnimplementedOperationException();
    }

    public double getVoidDamageMinBuildHeightOffset() {
        throw new UnimplementedOperationException();
    }

    public void setVoidDamageMinBuildHeightOffset(double v) {
        throw new UnimplementedOperationException();
    }

    public int getEntityCount() {
        throw new UnimplementedOperationException();
    }

    public int getTileEntityCount() {
        throw new UnimplementedOperationException();
    }

    public int getTickableTileEntityCount() {
        throw new UnimplementedOperationException();
    }

    public int getChunkCount() {
        return this.loadedChunks.size();
    }

    public int getPlayerCount() {
        return this.getPlayers().size();
    }

    public boolean hasStructureAt(@NotNull Position position, @NotNull Structure structure) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public MoonPhase getMoonPhase() {
        throw new UnimplementedOperationException();
    }

    public boolean lineOfSightExists(@NotNull Location from, @NotNull Location to) {
        throw new UnimplementedOperationException();
    }

    public boolean hasCollisionsIn(@NotNull BoundingBox boundingBox) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BlockMock getBlockAt(int x, int y, int z) {
        return this.getBlockAt(new Coordinate(x, y, z));
    }

    @NotNull
    public BlockMock getBlockAt(@NotNull Coordinate coordinate) {
        if (this.blocks.containsKey(coordinate)) {
            return this.blocks.get(coordinate);
        }
        return this.createBlock(coordinate);
    }

    @NotNull
    public BlockMock getBlockAt(@NotNull Location location) {
        return this.getBlockAt(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Deprecated(since="1.18")
    @NotNull
    public Block getBlockAtKey(long key) {
        return this.getBlockAt(this.getLocationAtKey(key));
    }

    @NotNull
    public Location getLocationAtKey(long key) {
        return super.getLocationAtKey(key);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @NotNull
    public UUID getUID() {
        return this.uuid;
    }

    @NotNull
    public Location getSpawnLocation() {
        if (this.spawnLocation == null) {
            this.setSpawnLocation(0, this.grassHeight + 1, 0);
        }
        return this.spawnLocation;
    }

    public boolean setSpawnLocation(@NotNull Location location) {
        return this.setSpawnLocation(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public boolean setSpawnLocation(int x, int y, int z) {
        if (this.spawnLocation == null) {
            this.spawnLocation = new Location((World)this, (double)x, (double)y, (double)z);
        } else {
            this.spawnLocation.setX((double)x);
            this.spawnLocation.setY((double)y);
            this.spawnLocation.setZ((double)z);
        }
        return true;
    }

    @NotNull
    public List<Entity> getEntities() {
        return this.server.getEntities().stream().filter(entity -> entity.getWorld() == this).filter(EntityMock::isValid).collect(Collectors.toList());
    }

    @NotNull
    public ChunkMock getChunkAt(int x, int z) {
        return this.getChunkAt(x, z, false);
    }

    @NotNull
    public ChunkMock getChunkAt(int x, int z, boolean generate) {
        return this.getChunkAt(new ChunkCoordinate(x, z));
    }

    @NotNull
    public ChunkMock getChunkAt(@NotNull ChunkCoordinate coordinate) {
        ChunkMock chunk = this.loadedChunks.get(coordinate);
        if (chunk == null) {
            chunk = this.savedChunks.get(coordinate);
            if (chunk == null) {
                chunk = new ChunkMock(this, coordinate.getX(), coordinate.getZ());
            }
            this.loadedChunks.put(coordinate, chunk);
        }
        return chunk;
    }

    public void sendPluginMessage(@NotNull Plugin source, @NotNull String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)this.server.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        for (Player player : this.getPlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    @NotNull
    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (Player player : this.getPlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    public void setMetadata(@NotNull String metadataKey, @NotNull MetadataValue newMetadataValue) {
        this.metadataTable.setMetadata(metadataKey, newMetadataValue);
    }

    @NotNull
    public List<MetadataValue> getMetadata(@NotNull String metadataKey) {
        return this.metadataTable.getMetadata(metadataKey);
    }

    public boolean hasMetadata(@NotNull String metadataKey) {
        return this.metadataTable.hasMetadata(metadataKey);
    }

    public void removeMetadata(@NotNull String metadataKey, @NotNull Plugin owningPlugin) {
        this.metadataTable.removeMetadata(metadataKey, owningPlugin);
    }

    public void clearMetadata(Plugin plugin) {
        this.metadataTable.clearMetadata(plugin);
    }

    public int getHighestBlockYAt(int x, int z) {
        return this.getHighestBlockYAt(x, z, HeightMap.MOTION_BLOCKING);
    }

    public int getHighestBlockYAt(@NotNull Location location) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ());
    }

    @NotNull
    public Block getHighestBlockAt(int x, int z) {
        return this.getHighestBlockAt(x, z, HeightMap.MOTION_BLOCKING);
    }

    @NotNull
    public Block getHighestBlockAt(Location location) {
        return this.getHighestBlockAt(location, HeightMap.MOTION_BLOCKING);
    }

    @NotNull
    public Chunk getChunkAt(@NotNull Location location) {
        return this.getChunkAt(location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    @NotNull
    public Chunk getChunkAt(@NotNull Block block) {
        return this.getChunkAt(block.getLocation());
    }

    public boolean isChunkLoaded(Chunk chunk) {
        return this.isChunkLoaded(chunk.getX(), chunk.getZ());
    }

    public Chunk @NotNull [] getLoadedChunks() {
        return this.loadedChunks.values().toArray(new Chunk[0]);
    }

    public void loadChunk(@NotNull Chunk chunk) {
        this.loadChunk(chunk.getX(), chunk.getZ());
    }

    public boolean isChunkLoaded(int x, int z) {
        ChunkCoordinate coordinate = new ChunkCoordinate(x, z);
        return this.loadedChunks.containsKey(coordinate);
    }

    @Deprecated(since="1.14")
    public boolean isChunkInUse(int x, int z) {
        throw new UnimplementedOperationException();
    }

    public void loadChunk(int x, int z) {
        this.loadChunk(x, z, true);
    }

    public boolean loadChunk(int x, int z, boolean generate) {
        AsyncCatcher.catchOp("chunk load");
        this.getChunkAt(x, z, generate);
        return true;
    }

    public boolean unloadChunk(@NotNull Chunk chunk) {
        return this.unloadChunk(chunk.getX(), chunk.getZ());
    }

    public boolean unloadChunk(int x, int z) {
        return this.unloadChunk(x, z, true);
    }

    public boolean unloadChunk(int x, int z, boolean save) {
        AsyncCatcher.catchOp("chunk unload");
        ChunkCoordinate chunkCoordinate = new ChunkCoordinate(x, z);
        ChunkMock chunk = this.loadedChunks.remove(chunkCoordinate);
        if (chunk == null) {
            return true;
        }
        if (save) {
            this.savedChunks.put(chunkCoordinate, chunk);
        }
        return true;
    }

    public boolean unloadChunkRequest(int x, int z) {
        AsyncCatcher.catchOp("chunk unload");
        throw new UnimplementedOperationException();
    }

    @Deprecated(since="1.13")
    public boolean regenerateChunk(int x, int z) {
        AsyncCatcher.catchOp("chunk regenerate");
        throw new UnimplementedOperationException();
    }

    @Deprecated(since="1.8")
    public boolean refreshChunk(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Collection<Player> getPlayersSeeingChunk(@NotNull Chunk chunk) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Collection<Player> getPlayersSeeingChunk(int i, int i1) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Item dropItem(@NotNull Location loc, @NotNull ItemStack item) {
        return this.dropItem(loc, item, null);
    }

    @NotNull
    public Item dropItem(@NotNull Location location, @NotNull ItemStack item, @Nullable Consumer<? super Item> function) {
        Preconditions.checkNotNull((Object)location, (Object)"The provided location must not be null.");
        Preconditions.checkNotNull((Object)item, (Object)"Cannot drop items that are null.");
        Preconditions.checkArgument((!item.getType().isAir() ? 1 : 0) != 0, (Object)"Cannot drop air.");
        ItemEntityMock entity = new ItemEntityMock(this.server, UUID.randomUUID(), item);
        entity.setLocation(location);
        if (function != null) {
            function.accept(entity);
        }
        this.server.registerEntity(entity);
        this.callSpawnEvent(entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return entity;
    }

    @NotNull
    public Item dropItemNaturally(@NotNull Location loc, @NotNull ItemStack item) {
        return this.dropItemNaturally(loc, item, null);
    }

    @NotNull
    public Item dropItemNaturally(@NotNull Location location, @NotNull ItemStack item, @Nullable Consumer<? super Item> function) {
        Preconditions.checkNotNull((Object)location, (Object)"The provided location must not be null.");
        ThreadLocalRandom random = ThreadLocalRandom.current();
        double xs = (double)(((Random)random).nextFloat() * 0.5f) + 0.25;
        double ys = (double)(((Random)random).nextFloat() * 0.5f) + 0.25;
        double zs = (double)(((Random)random).nextFloat() * 0.5f) + 0.25;
        Location loc = location.clone();
        loc.setX(loc.getX() + xs);
        loc.setY(loc.getY() + ys);
        loc.setZ(loc.getZ() + zs);
        return this.dropItem(loc, item, function);
    }

    @NotNull
    public Arrow spawnArrow(Location location, Vector direction, float speed, float spread) {
        throw new UnimplementedOperationException();
    }

    public boolean generateTree(Location location, TreeType type) {
        throw new UnimplementedOperationException();
    }

    @Deprecated(since="1.17")
    public boolean generateTree(Location loc, TreeType type, BlockChangeDelegate delegate) {
        throw new UnimplementedOperationException();
    }

    public boolean generateTree(Location location, Random random, TreeType type, Predicate<? super BlockState> statePredicate) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public <T extends Entity> T spawn(@NotNull Location location, @NotNull Class<T> clazz) throws IllegalArgumentException {
        return this.spawn(location, clazz, null, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    @NotNull
    public <T extends Entity> T spawn(@NotNull Location location, @NotNull Class<T> clazz, boolean randomizeData, @Nullable Consumer<? super T> function) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, CreatureSpawnEvent.SpawnReason.CUSTOM, randomizeData, true);
    }

    @NotNull
    public <T extends Entity> T spawn(@NotNull Location location, @NotNull Class<T> clazz, @Nullable Consumer<? super T> function, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, reason, true, true);
    }

    @NotNull
    public <T extends Entity> T spawn(@Nullable Location location, @Nullable Class<T> clazz, @Nullable Consumer<? super T> function, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull CreatureSpawnEvent.SpawnReason reason, boolean randomizeData, boolean callSpawnEvent) {
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null");
        Preconditions.checkNotNull(clazz, (Object)"Class cannot be null");
        Preconditions.checkNotNull((Object)reason, (Object)"Reason cannot be null");
        EntityMock entity = this.mockEntity(location, clazz, randomizeData);
        entity.setLocation(location);
        entity.setSpawnReason(reason);
        if (entity instanceof MobMock) {
            MobMock mob = (MobMock)entity;
            mob.finalizeSpawn();
        }
        if (entity instanceof Monster && this.getDifficulty() == Difficulty.PEACEFUL) {
            entity.remove();
        }
        if (function != null) {
            function.accept(entity);
        }
        this.server.registerEntity(entity);
        if (callSpawnEvent) {
            this.callSpawnEvent(entity, reason);
        }
        return (T)entity;
    }

    @NotNull
    public Entity spawnEntity(@NotNull Location loc, @NotNull EntityType type) {
        return this.spawn(loc, type.getEntityClass());
    }

    @NotNull
    public Entity spawnEntity(@NotNull Location loc, @NotNull EntityType type, boolean randomizeData) {
        return this.spawn(loc, type.getEntityClass(), randomizeData, null);
    }

    @NotNull
    private <T extends Entity> EntityMock mockEntity(@NotNull Location location, @NotNull Class<T> clazz, boolean randomizeData) {
        @NotNull EntityMock entity = this.mockEntity(clazz);
        entity.setLocation(location);
        return entity;
    }

    @NotNull
    private <T extends Entity> EntityMock mockEntity(@NotNull Class<T> clazz) {
        AsyncCatcher.catchOp("entity add");
        if (clazz == ArmorStand.class) {
            return new ArmorStandMock(this.server, UUID.randomUUID());
        }
        if (clazz == ExperienceOrb.class) {
            return new ExperienceOrbMock(this.server, UUID.randomUUID());
        }
        if (clazz == Firework.class) {
            return new FireworkMock(this.server, UUID.randomUUID());
        }
        if (clazz == Item.class) {
            throw new IllegalArgumentException("Items must be spawned using World#dropItem(...)");
        }
        if (clazz == FishHook.class) {
            return new FishHookMock(this.server, UUID.randomUUID());
        }
        if (clazz == Player.class) {
            throw new IllegalArgumentException("Player Entities cannot be spawned, use ServerMock#addPlayer(...)");
        }
        if (clazz == Drowned.class) {
            return new DrownedMock(this.server, UUID.randomUUID());
        }
        if (clazz == Zombie.class) {
            return new ZombieMock(this.server, UUID.randomUUID());
        }
        if (clazz == Enderman.class) {
            return new EndermanMock(this.server, UUID.randomUUID());
        }
        if (clazz == Horse.class) {
            return new HorseMock(this.server, UUID.randomUUID());
        }
        if (clazz == Sheep.class) {
            return new SheepMock(this.server, UUID.randomUUID());
        }
        if (clazz == Allay.class) {
            return new AllayMock(this.server, UUID.randomUUID());
        }
        if (clazz == Warden.class) {
            return new WardenMock(this.server, UUID.randomUUID());
        }
        if (clazz == Donkey.class) {
            return new DonkeyMock(this.server, UUID.randomUUID());
        }
        if (clazz == Llama.class) {
            return new LlamaMock(this.server, UUID.randomUUID());
        }
        if (clazz == Mule.class) {
            return new MuleMock(this.server, UUID.randomUUID());
        }
        if (clazz == SkeletonHorse.class) {
            return new SkeletonHorseMock(this.server, UUID.randomUUID());
        }
        if (clazz == ZombieHorse.class) {
            return new ZombieHorseMock(this.server, UUID.randomUUID());
        }
        if (clazz == Cow.class) {
            return new CowMock(this.server, UUID.randomUUID());
        }
        if (clazz == Chicken.class) {
            return new ChickenMock(this.server, UUID.randomUUID());
        }
        if (clazz == Skeleton.class) {
            return new SkeletonMock(this.server, UUID.randomUUID());
        }
        if (clazz == Stray.class) {
            return new StrayMock(this.server, UUID.randomUUID());
        }
        if (clazz == WitherSkeleton.class) {
            return new WitherSkeletonMock(this.server, UUID.randomUUID());
        }
        if (clazz == Spider.class) {
            return new SpiderMock(this.server, UUID.randomUUID());
        }
        if (clazz == Blaze.class) {
            return new BlazeMock(this.server, UUID.randomUUID());
        }
        if (clazz == CaveSpider.class) {
            return new CaveSpiderMock(this.server, UUID.randomUUID());
        }
        if (clazz == Giant.class) {
            return new GiantMock(this.server, UUID.randomUUID());
        }
        if (clazz == Axolotl.class) {
            return new AxolotlMock(this.server, UUID.randomUUID());
        }
        if (clazz == Bat.class) {
            return new BatMock(this.server, UUID.randomUUID());
        }
        if (clazz == Cat.class) {
            return new CatMock(this.server, UUID.randomUUID());
        }
        if (clazz == Frog.class) {
            return new FrogMock(this.server, UUID.randomUUID());
        }
        if (clazz == Fox.class) {
            return new FoxMock(this.server, UUID.randomUUID());
        }
        if (clazz == Ghast.class) {
            return new GhastMock(this.server, UUID.randomUUID());
        }
        if (clazz == MushroomCow.class) {
            return new MushroomCowMock(this.server, UUID.randomUUID());
        }
        if (clazz == Tadpole.class) {
            return new TadpoleMock(this.server, UUID.randomUUID());
        }
        if (clazz == Cod.class) {
            return new CodMock(this.server, UUID.randomUUID());
        }
        if (clazz == TropicalFish.class) {
            return new TropicalFishMock(this.server, UUID.randomUUID());
        }
        if (clazz == Salmon.class) {
            return new SalmonMock(this.server, UUID.randomUUID());
        }
        if (clazz == PufferFish.class) {
            return new PufferFishMock(this.server, UUID.randomUUID());
        }
        if (clazz == Bee.class) {
            return new BeeMock(this.server, UUID.randomUUID());
        }
        if (clazz == Creeper.class) {
            return new CreeperMock(this.server, UUID.randomUUID());
        }
        if (clazz == Wolf.class) {
            return new WolfMock(this.server, UUID.randomUUID());
        }
        if (clazz == Goat.class) {
            return new GoatMock(this.server, UUID.randomUUID());
        }
        if (clazz == Egg.class) {
            return new EggMock(this.server, UUID.randomUUID());
        }
        if (clazz == Pig.class) {
            return new PigMock(this.server, UUID.randomUUID());
        }
        if (clazz == ElderGuardian.class) {
            return new ElderGuardianMock(this.server, UUID.randomUUID());
        }
        if (clazz == Guardian.class) {
            return new GuardianMock(this.server, UUID.randomUUID());
        }
        if (clazz == PolarBear.class) {
            return new PolarBearMock(this.server, UUID.randomUUID());
        }
        if (clazz == SmallFireball.class) {
            return new SmallFireballMock(this.server, UUID.randomUUID());
        }
        if (clazz == LargeFireball.class) {
            return new LargeFireballMock(this.server, UUID.randomUUID());
        }
        if (clazz == DragonFireball.class) {
            return new DragonFireballMock(this.server, UUID.randomUUID());
        }
        if (clazz == WitherSkull.class) {
            return new WitherSkullMock(this.server, UUID.randomUUID());
        }
        if (clazz == PoweredMinecart.class) {
            return new PoweredMinecartMock(this.server, UUID.randomUUID());
        }
        if (clazz == Camel.class) {
            return new CamelMock(this.server, UUID.randomUUID());
        }
        if (clazz == CommandMinecart.class) {
            return new CommandMinecartMock(this.server, UUID.randomUUID());
        }
        if (clazz == ExplosiveMinecart.class) {
            return new ExplosiveMinecartMock(this.server, UUID.randomUUID());
        }
        if (clazz == HopperMinecart.class) {
            return new HopperMinecartMock(this.server, UUID.randomUUID());
        }
        if (clazz == SpawnerMinecart.class) {
            return new SpawnerMinecartMock(this.server, UUID.randomUUID());
        }
        if (clazz == RideableMinecart.class) {
            return new RideableMinecartMock(this.server, UUID.randomUUID());
        }
        if (clazz == StorageMinecart.class) {
            return new StorageMinecartMock(this.server, UUID.randomUUID());
        }
        if (clazz == AreaEffectCloud.class) {
            return new AreaEffectCloudMock(this.server, UUID.randomUUID());
        }
        if (clazz == Boat.class) {
            return new BoatMock(this.server, UUID.randomUUID());
        }
        if (clazz == ChestBoat.class) {
            return new ChestBoatMock(this.server, UUID.randomUUID());
        }
        if (clazz == EnderPearl.class) {
            return new EnderPearlMock(this.server, UUID.randomUUID());
        }
        if (clazz == Panda.class) {
            return new PandaMock(this.server, UUID.randomUUID());
        }
        if (clazz == Rabbit.class) {
            return new RabbitMock(this.server, UUID.randomUUID());
        }
        if (clazz == Slime.class) {
            return new SlimeMock(this.server, UUID.randomUUID());
        }
        if (clazz == Ocelot.class) {
            return new OcelotMock(this.server, UUID.randomUUID());
        }
        if (clazz == Parrot.class) {
            return new ParrotMock(this.server, UUID.randomUUID());
        }
        if (clazz == Squid.class) {
            return new SquidMock(this.server, UUID.randomUUID());
        }
        if (clazz == GlowSquid.class) {
            return new GlowSquidMock(this.server, UUID.randomUUID());
        }
        if (clazz == LlamaSpit.class) {
            return new LlamaSpitMock(this.server, UUID.randomUUID());
        }
        if (clazz == Dolphin.class) {
            return new DolphinMock(this.server, UUID.randomUUID());
        }
        if (clazz == MagmaCube.class) {
            return new MagmaCubeMock(this.server, UUID.randomUUID());
        }
        if (clazz == Endermite.class) {
            return new EndermiteMock(this.server, UUID.randomUUID());
        }
        if (clazz == Silverfish.class) {
            return new SilverfishMock(this.server, UUID.randomUUID());
        }
        if (clazz == Turtle.class) {
            return new TurtleMock(this.server, UUID.randomUUID());
        }
        if (clazz == ThrownExpBottle.class) {
            return new ThrownExpBottleMock(this.server, UUID.randomUUID());
        }
        if (clazz == Snowball.class) {
            return new SnowballMock(this.server, UUID.randomUUID());
        }
        if (clazz == LeashHitch.class) {
            return new LeashHitchMock(this.server, UUID.randomUUID());
        }
        if (clazz == PigZombie.class) {
            return new PigZombieMock(this.server, UUID.randomUUID());
        }
        if (clazz == BlockDisplay.class) {
            return new BlockDisplayMock(this.server, UUID.randomUUID());
        }
        if (clazz == ItemDisplay.class) {
            return new ItemDisplayMock(this.server, UUID.randomUUID());
        }
        if (clazz == Arrow.class) {
            return new ArrowMock(this.server, UUID.randomUUID());
        }
        if (clazz == SpectralArrow.class) {
            return new SpectralArrowMock(this.server, UUID.randomUUID());
        }
        if (clazz == Trident.class) {
            return new TridentMock(this.server, UUID.randomUUID());
        }
        if (clazz == Marker.class) {
            return new MarkerMock(this.server, UUID.randomUUID());
        }
        if (clazz == EnderCrystal.class) {
            return new EnderCrystalMock(this.server, UUID.randomUUID());
        }
        if (clazz == Pillager.class) {
            return new PillagerMock(this.server, UUID.randomUUID());
        }
        if (clazz == Witch.class) {
            return new WitchMock(this.server, UUID.randomUUID());
        }
        if (clazz == Ravager.class) {
            return new RavagerMock(this.server, UUID.randomUUID());
        }
        if (clazz == Zoglin.class) {
            return new ZoglinMock(this.server, UUID.randomUUID());
        }
        if (clazz == Vindicator.class) {
            return new VindicatorMock(this.server, UUID.randomUUID());
        }
        if (clazz == Evoker.class) {
            return new EvokerMock(this.server, UUID.randomUUID());
        }
        if (clazz == EvokerFangs.class) {
            return new EvokerFangsMock(this.server, UUID.randomUUID());
        }
        if (clazz == Illusioner.class) {
            return new IllusionerMock(this.server, UUID.randomUUID());
        }
        if (clazz == Interaction.class) {
            return new InteractionMock(this.server, UUID.randomUUID());
        }
        if (clazz == IronGolem.class) {
            return new IronGolemMock(this.server, UUID.randomUUID());
        }
        if (clazz == Snowman.class) {
            return new SnowmanMock(this.server, UUID.randomUUID());
        }
        if (clazz == Shulker.class) {
            return new ShulkerMock(this.server, UUID.randomUUID());
        }
        if (clazz == ItemFrame.class) {
            return new ItemFrameMock(this.server, UUID.randomUUID());
        }
        if (clazz == GlowItemFrame.class) {
            return new GlowItemFrameMock(this.server, UUID.randomUUID());
        }
        if (clazz == FallingBlock.class) {
            return new FallingBlockMock(this.server, UUID.randomUUID());
        }
        if (clazz == ThrownPotion.class) {
            return new ThrownPotionMock(this.server, UUID.randomUUID());
        }
        if (clazz == Armadillo.class) {
            return new ArmadilloMock(this.server, UUID.randomUUID());
        }
        if (clazz == EnderSignal.class) {
            return new EnderSignalMock(this.server, UUID.randomUUID());
        }
        if (clazz == Husk.class) {
            return new HuskMock(this.server, UUID.randomUUID());
        }
        if (clazz == Bogged.class) {
            return new BoggedMock(this.server, UUID.randomUUID());
        }
        if (clazz == Breeze.class) {
            return new BreezeMock(this.server, UUID.randomUUID());
        }
        if (clazz == BreezeWindCharge.class) {
            return new BreezeWindChargeMock(this.server, UUID.randomUUID());
        }
        if (clazz == WindCharge.class) {
            return new WindChargeMock(this.server, UUID.randomUUID());
        }
        throw new UnimplementedOperationException();
    }

    /*
     * Unable to fully structure code
     */
    private void callSpawnEvent(EntityMock entity, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull CreatureSpawnEvent.SpawnReason reason) {
        if (!(entity instanceof LivingEntity)) ** GOTO lbl-1000
        living = (LivingEntity)entity;
        if (!(entity instanceof Player)) {
            isAnimal = entity instanceof Animals != false || entity instanceof WaterMob != false || entity instanceof Golem != false;
            v0 = isMonster = entity instanceof Monster != false || entity instanceof Ghast != false || entity instanceof Slime != false;
            if (reason != CreatureSpawnEvent.SpawnReason.CUSTOM && (isAnimal && !this.getAllowAnimals() || isMonster && !this.getAllowMonsters())) {
                entity.remove();
                return;
            }
            success = new CreatureSpawnEvent(living, reason).callEvent();
        } else if (entity instanceof Item) {
            item = (Item)entity;
            success = new ItemSpawnEvent(item).callEvent();
        } else {
            success = entity instanceof Player != false ? false : (entity instanceof Projectile != false ? new ProjectileLaunchEvent((Entity)entity).callEvent() : new EntitySpawnEvent((Entity)entity).callEvent());
        }
        if (!success || !entity.isValid()) {
            vehicle = entity.getVehicle();
            if (vehicle != null) {
                vehicle.remove();
            }
            for (Entity passenger : entity.getTransitivePassengers()) {
                passenger.remove();
            }
            entity.remove();
        }
    }

    @NotNull
    public LightningStrike strikeLightning(Location loc) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public LightningStrike strikeLightningEffect(Location loc) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Location findLightningRod(@NotNull Location location) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Location findLightningTarget(@NotNull Location location) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public List<LivingEntity> getLivingEntities() {
        return this.getEntities().stream().filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).collect(Collectors.toList());
    }

    @SafeVarargs
    @NotNull
    public final <T extends Entity> Collection<T> getEntitiesByClass(Class<T> ... classes) {
        ArrayList<T> entities = new ArrayList<T>();
        for (Class<T> clazz : classes) {
            entities.addAll(this.getEntitiesByClass(clazz));
        }
        return entities;
    }

    @NotNull
    public <T extends Entity> Collection<T> getEntitiesByClass(@NotNull Class<T> cls) {
        return this.getEntities().stream().filter(entity -> cls.isAssignableFrom(entity.getClass())).map(cls::cast).collect(Collectors.toList());
    }

    @NotNull
    public Collection<Entity> getEntitiesByClasses(Class<?> ... classes) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Class<?> clazz : classes) {
            entities.addAll(this.getEntities().stream().filter(entity -> clazz.isAssignableFrom(entity.getClass())).toList());
        }
        return entities;
    }

    @NotNull
    public <T extends Entity> T createEntity(@NotNull Location location, @NotNull Class<T> aClass) {
        EntityMock entity = this.mockEntity(location, aClass, false);
        Preconditions.checkState((boolean)aClass.isInstance(entity), (String)"Entity {} is not an instance of {}.", (Object)entity.getClass().getName(), (Object)aClass.getName());
        return (T)((Entity)aClass.cast(entity));
    }

    @NotNull
    public CompletableFuture<Chunk> getChunkAtAsync(int x, int z, boolean gen, boolean urgent) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public List<Player> getPlayers() {
        return Bukkit.getOnlinePlayers().stream().filter(p -> p.getWorld() == this).collect(Collectors.toList());
    }

    @NotNull
    public Collection<Entity> getNearbyEntities(Location location, double x, double y, double z) {
        return this.getNearbyEntities(location, x, y, z, null);
    }

    @Nullable
    public Entity getEntity(@NotNull UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        return this.getEntities().stream().filter(entity -> entity.getUniqueId().equals(uuid)).findFirst().orElse(null);
    }

    public long getTime() {
        return this.getFullTime() % 24000L;
    }

    public void setTime(long time) {
        long base = this.getFullTime() - this.getFullTime() % 24000L;
        this.setFullTime(base + time % 24000L);
    }

    public long getFullTime() {
        return this.fullTime;
    }

    public void setFullTime(long time) {
        TimeSkipEvent event = new TimeSkipEvent((World)this, TimeSkipEvent.SkipReason.CUSTOM, time - this.getFullTime());
        this.server.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.fullTime += event.getSkipAmount();
        }
    }

    public boolean isDayTime() {
        return false;
    }

    public boolean hasStorm() {
        return this.storming;
    }

    public void setStorm(boolean hasStorm) {
        if (this.storming == hasStorm) {
            return;
        }
        WeatherChangeEvent weather = new WeatherChangeEvent((World)this, hasStorm, WeatherChangeEvent.Cause.PLUGIN);
        Bukkit.getServer().getPluginManager().callEvent((Event)weather);
        if (weather.isCancelled()) {
            return;
        }
        this.storming = hasStorm;
        this.setWeatherDuration(0);
        this.setClearWeatherDuration(0);
    }

    public int getWeatherDuration() {
        return this.weatherDuration;
    }

    public void setWeatherDuration(int duration) {
        this.weatherDuration = duration;
    }

    public boolean isThundering() {
        return this.thundering;
    }

    public void setThundering(boolean thundering) {
        if (this.thundering == thundering) {
            return;
        }
        ThunderChangeEvent thunder = new ThunderChangeEvent((World)this, thundering, ThunderChangeEvent.Cause.PLUGIN);
        Bukkit.getServer().getPluginManager().callEvent((Event)thunder);
        if (thunder.isCancelled()) {
            return;
        }
        this.thundering = thundering;
        this.setThunderDuration(0);
        this.setClearWeatherDuration(0);
    }

    public int getThunderDuration() {
        return this.thunderDuration;
    }

    public void setThunderDuration(int duration) {
        this.thunderDuration = duration;
    }

    public boolean isClearWeather() {
        return !this.hasStorm() && !this.isThundering();
    }

    public int getClearWeatherDuration() {
        return this.clearWeatherDuration;
    }

    public void setClearWeatherDuration(int duration) {
        this.clearWeatherDuration = duration;
    }

    public boolean createExplosion(double x, double y, double z, float power) {
        throw new UnimplementedOperationException();
    }

    public boolean createExplosion(double x, double y, double z, float power, boolean setFire) {
        throw new UnimplementedOperationException();
    }

    public boolean createExplosion(double x, double y, double z, float power, boolean setFire, boolean breakBlocks) {
        throw new UnimplementedOperationException();
    }

    public boolean createExplosion(@NotNull Location loc, float power) {
        throw new UnimplementedOperationException();
    }

    public boolean createExplosion(@NotNull Location loc, float power, boolean setFire) {
        throw new UnimplementedOperationException();
    }

    public boolean createExplosion(Entity source, @NotNull Location loc, float power, boolean setFire, boolean breakBlocks, boolean excludeSourceFromDamage) {
        throw new UnimplementedOperationException();
    }

    public boolean createExplosion(@Nullable Entity source, @NotNull Location loc, float power, boolean setFire, boolean breakBlocks) {
        return false;
    }

    @NotNull
    public World.Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(World.Environment environment) {
        this.environment = environment;
    }

    public long getSeed() {
        return this.seed;
    }

    public boolean getPVP() {
        return this.pvp;
    }

    public void setPVP(boolean pvp) {
        this.pvp = pvp;
    }

    public ChunkGenerator getGenerator() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public BiomeProvider getBiomeProvider() {
        return this.biomeProviderMock;
    }

    public void save() {
        AsyncCatcher.catchOp("world save");
        throw new UnimplementedOperationException();
    }

    @NotNull
    public List<BlockPopulator> getPopulators() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public <T extends LivingEntity> T spawn(@NotNull Location location, @NotNull Class<T> clazz, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull CreatureSpawnEvent.SpawnReason spawnReason, boolean randomizeData, @Nullable Consumer<? super T> function) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public FallingBlock spawnFallingBlock(@NotNull Location location, @NotNull MaterialData data) throws IllegalArgumentException {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"MaterialData cannot be null");
        return this.spawnFallingBlock(location, data.getItemType(), data.getData());
    }

    @Deprecated(since="1.7.5")
    @NotNull
    public FallingBlock spawnFallingBlock(@NotNull Location location, @NotNull Material material, byte data) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isBlock(), (String)"Material.%s must be a block", (Object)material);
        FallingBlock fallingBlock = (FallingBlock)this.spawn(location, FallingBlock.class, CreatureSpawnEvent.SpawnReason.CUSTOM);
        BlockDataMock blockData = new BlockDataMock(material);
        fallingBlock.setBlockData((BlockData)blockData);
        return fallingBlock;
    }

    @NotNull
    public FallingBlock spawnFallingBlock(@NotNull Location location, @NotNull BlockData data) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"BlockData cannot be null");
        FallingBlock fallingBlock = (FallingBlock)this.spawn(location, FallingBlock.class, CreatureSpawnEvent.SpawnReason.CUSTOM);
        fallingBlock.setBlockData(data);
        return fallingBlock;
    }

    public void playEffect(@NotNull Location location, @NotNull Effect effect, int data) {
        this.playEffect(location, effect, data, 64);
    }

    public void playEffect(@NotNull Location location, @NotNull Effect effect, int data, int radius) {
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)effect, (Object)"Effect cannot be null");
        Preconditions.checkNotNull((Object)location.getWorld(), (Object)"World cannot be null");
    }

    public <T> void playEffect(@NotNull Location location, @NotNull Effect effect, T data) {
        this.playEffect(location, effect, data, 64);
    }

    public <T> void playEffect(@NotNull Location location, @NotNull Effect effect, @Nullable T data, int radius) {
        if (data != null) {
            Preconditions.checkArgument((effect.getData() != null && effect.getData().isAssignableFrom(data.getClass()) ? 1 : 0) != 0, (Object)"Wrong kind of data for this effect!");
        } else {
            Preconditions.checkArgument((effect.getData() == null || effect == Effect.ELECTRIC_SPARK ? 1 : 0) != 0, (Object)"Wrong kind of data for this effect!");
        }
    }

    @NotNull
    public ChunkSnapshotMock getEmptyChunkSnapshot(int chunkX, int chunkZ, boolean includeBiome, boolean includeBiomeTempRain) {
        int size = 256 * Math.abs(this.getMaxHeight() - this.getMinHeight());
        ImmutableMap.Builder chunkBlockData = ImmutableMap.builderWithExpectedSize((int)size);
        ImmutableMap.Builder chunkBiomes = ImmutableMap.builderWithExpectedSize((int)size);
        for (int x = 0; x < 16; ++x) {
            for (int y = this.getMinHeight(); y < this.getMaxHeight(); ++y) {
                for (int z = 0; z < 16; ++z) {
                    Coordinate coord = new Coordinate(x, y, z);
                    chunkBlockData.put((Object)coord, (Object)new BlockDataMock(Material.AIR));
                    if (!includeBiome && !includeBiomeTempRain) continue;
                    chunkBiomes.put((Object)coord, (Object)Biome.PLAINS);
                }
            }
        }
        return new ChunkSnapshotMock(chunkX, chunkZ, this.getMinHeight(), this.getMaxHeight(), this.getName(), this.getFullTime(), (Map<Coordinate, BlockData>)chunkBlockData.build(), (Map<Coordinate, Biome>)(includeBiome || includeBiomeTempRain ? chunkBiomes.build() : null));
    }

    public void setSpawnFlags(boolean allowMonsters, boolean allowAnimals) {
        this.allowMonsters = allowMonsters;
        this.allowAnimals = allowAnimals;
    }

    public boolean getAllowAnimals() {
        return this.allowAnimals;
    }

    public boolean getAllowMonsters() {
        return this.allowMonsters;
    }

    @Deprecated(since="1.15")
    @NotNull
    public Biome getBiome(int x, int z) {
        return this.getBiome(x, 0, z);
    }

    @Deprecated(since="1.15")
    public void setBiome(int x, int z, @NotNull Biome bio) {
        for (int y = this.getMinHeight(); y < this.getMaxHeight(); ++y) {
            this.setBiome(x, y, z, bio);
        }
    }

    @Deprecated(since="1.15")
    public double getTemperature(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @Deprecated(since="1.15")
    public double getHumidity(int x, int z) {
        throw new UnimplementedOperationException();
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    @NotNull
    public BiomeProvider vanillaBiomeProvider() {
        throw new UnimplementedOperationException();
    }

    public int getSeaLevel() {
        return 63;
    }

    public boolean getKeepSpawnInMemory() {
        return this.getKeepSpawnInMemory;
    }

    public void setKeepSpawnInMemory(boolean keepLoaded) {
        this.getKeepSpawnInMemory = keepLoaded;
    }

    public boolean isAutoSave() {
        throw new UnimplementedOperationException();
    }

    public void setAutoSave(boolean value) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(@NotNull Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    @NotNull
    public File getWorldFolder() {
        throw new UnimplementedOperationException();
    }

    @Deprecated(since="1.16")
    public WorldType getWorldType() {
        return this.worldType;
    }

    public boolean canGenerateStructures() {
        throw new UnimplementedOperationException();
    }

    @Deprecated(since="1.18")
    public long getTicksPerAnimalSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.ANIMAL);
    }

    @Deprecated(since="1.18")
    public void setTicksPerAnimalSpawns(int ticksPerAnimalSpawns) {
        this.setTicksPerSpawns(SpawnCategory.ANIMAL, ticksPerAnimalSpawns);
    }

    @Deprecated(since="1.18")
    public long getTicksPerMonsterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.MONSTER);
    }

    @Deprecated(since="1.18")
    public void setTicksPerMonsterSpawns(int ticksPerMonsterSpawns) {
        this.setTicksPerSpawns(SpawnCategory.MONSTER, ticksPerMonsterSpawns);
    }

    @Deprecated(since="1.18")
    public int getMonsterSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.MONSTER);
    }

    @Deprecated(since="1.18")
    public void setMonsterSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.MONSTER, limit);
    }

    @Deprecated(since="1.18")
    public int getAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.ANIMAL);
    }

    @Deprecated(since="1.18")
    public void setAnimalSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.ANIMAL, limit);
    }

    @Deprecated(since="1.18")
    public int getWaterAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_ANIMAL);
    }

    @Deprecated(since="1.18")
    public void setWaterAnimalSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.WATER_ANIMAL, limit);
    }

    @Deprecated(since="1.18")
    public int getWaterUndergroundCreatureSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Deprecated(since="1.18")
    public void setWaterUndergroundCreatureSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.WATER_UNDERGROUND_CREATURE, limit);
    }

    @Deprecated(since="1.18")
    public int getAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.AMBIENT);
    }

    @Deprecated(since="1.18")
    public void setAmbientSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.AMBIENT, limit);
    }

    public void playSound(@NotNull Location location, @NotNull Sound sound, float volume, float pitch) {
        this.playSound(location, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(@NotNull Location location, @NotNull String sound, float volume, float pitch) {
        this.playSound(location, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(@NotNull Location location, @NotNull Sound sound, @NotNull SoundCategory category, float volume, float pitch) {
        for (Player player : this.getPlayers()) {
            player.playSound(location, sound, category, volume, pitch);
        }
    }

    public void playSound(@NotNull Location location, @NotNull String sound, @NotNull SoundCategory category, float volume, float pitch) {
        for (Player player : this.getPlayers()) {
            player.playSound(location, sound, category, volume, pitch);
        }
    }

    public void playSound(Entity entity, Sound sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(@NotNull Entity entity, @NotNull String sound, float volume, float pitch) {
        throw new UnimplementedOperationException();
    }

    public void playSound(@NotNull Entity entity, @NotNull String sound, @NotNull SoundCategory category, float volume, float pitch) {
        throw new UnimplementedOperationException();
    }

    public void playSound(@Nullable Entity entity, @Nullable Sound sound, @Nullable SoundCategory category, float volume, float pitch) {
        if (entity == null || entity.getWorld() != this || sound == null || category == null) {
            return;
        }
        for (Player player : this.getPlayers()) {
            player.playSound(entity, sound, category, volume, pitch);
        }
    }

    public String @NotNull [] getGameRules() {
        return this.gameRules.values().stream().map(Object::toString).toList().toArray(new String[0]);
    }

    @Deprecated(since="1.13")
    public String getGameRuleValue(@Nullable String rule) {
        if (rule == null) {
            return null;
        }
        GameRule gameRule = GameRule.getByName((String)rule);
        if (gameRule == null) {
            return null;
        }
        return this.getGameRuleValue(gameRule).toString();
    }

    @Deprecated(since="1.13")
    public boolean setGameRuleValue(@Nullable String rule, @NotNull String value) {
        if (rule == null) {
            return false;
        }
        GameRule gameRule = GameRule.getByName((String)rule);
        if (gameRule == null) {
            return false;
        }
        if (gameRule.getType().equals(Boolean.class) && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false"))) {
            WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent((World)this, null, gameRule, value);
            if (!event.callEvent()) {
                return false;
            }
            return this.setGameRule(gameRule, value.equalsIgnoreCase("true"));
        }
        if (gameRule.getType().equals(Integer.class)) {
            try {
                int intValue = Integer.parseInt(value);
                WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent((World)this, null, gameRule, value);
                if (!event.callEvent()) {
                    return false;
                }
                return this.setGameRule(gameRule, intValue);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public boolean isGameRule(@Nullable String rule) {
        return rule != null && GameRule.getByName((String)rule) != null;
    }

    @NotNull
    public WorldBorderMock getWorldBorder() {
        if (this.worldBorder == null) {
            this.worldBorder = new WorldBorderMock(this);
        }
        return this.worldBorder;
    }

    public void spawnParticle(Particle particle, Location location, int count) {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, T data) {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, T data) {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(@NotNull Particle particle, @Nullable List<Player> receivers, @Nullable Player source, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, @Nullable T data, boolean force) {
        throw new UnimplementedOperationException();
    }

    public <T> T getGameRuleValue(@NotNull GameRule<T> rule) {
        return rule.getType().cast(this.gameRules.get(rule));
    }

    public <T> T getGameRuleDefault(GameRule<T> rule) {
        throw new UnimplementedOperationException();
    }

    public <T> boolean setGameRule(GameRule<T> rule, T newValue) {
        this.gameRules.put(rule, newValue);
        return true;
    }

    public boolean isChunkGenerated(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Collection<Entity> getNearbyEntities(Location location, double x, double y, double z, Predicate<? super Entity> filter) {
        return this.getNearbyEntities(BoundingBox.of((Location)location, (double)x, (double)y, (double)z), filter);
    }

    @NotNull
    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox) {
        return this.getNearbyEntities(boundingBox, null);
    }

    @NotNull
    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox, Predicate<? super Entity> filter) {
        return this.getEntities().stream().filter(entity -> filter == null || filter.test((Entity)entity)).filter(entity -> boundingBox.contains(entity.getLocation().toVector())).collect(Collectors.toSet());
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance) {
        throw new UnimplementedOperationException();
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize) {
        throw new UnimplementedOperationException();
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, Predicate<? super Entity> filter) {
        throw new UnimplementedOperationException();
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize, Predicate<? super Entity> filter) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public BiomeSearchResult locateNearestBiome(@NotNull Location origin, int radius, int horizontalInterval, int verticalInterval, Biome ... biomes) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public BiomeSearchResult locateNearestBiome(@NotNull Location origin, int radius, Biome ... biomes) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public RayTraceResult rayTrace(@NotNull Position start, @NotNull Vector direction, double maxDistance, @NotNull FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, double raySize, @Nullable Predicate<? super Entity> filter, @Nullable Predicate<? super Block> canCollide) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public RayTraceResult rayTraceBlocks(@NotNull Position start, @NotNull Vector direction, double maxDistance, @NotNull FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, @Nullable Predicate<? super Block> canCollide) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public RayTraceResult rayTraceEntities(@NotNull Position start, @NotNull Vector direction, double maxDistance, double raySize, @Nullable Predicate<? super Entity> filter) {
        throw new UnimplementedOperationException();
    }

    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance) {
        throw new UnimplementedOperationException();
    }

    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode) {
        throw new UnimplementedOperationException();
    }

    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks) {
        throw new UnimplementedOperationException();
    }

    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, double raySize, Predicate<? super Entity> filter) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Deprecated(since="1.19")
    public Location locateNearestStructure(Location origin, StructureType structureType, int radius, boolean findUnexplored) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public StructureSearchResult locateNearestStructure(@NotNull Location origin, @NotNull org.bukkit.generator.structure.StructureType structureType, int radius, boolean findUnexplored) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public StructureSearchResult locateNearestStructure(@NotNull Location origin, @NotNull Structure structure, int radius, boolean findUnexplored) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Location locateNearestBiome(@NotNull Location origin, @NotNull Biome biome, int radius) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Location locateNearestBiome(@NotNull Location origin, @NotNull Biome biome, int radius, int step) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public <T extends Entity> T addEntity(@NotNull T t) {
        throw new UnimplementedOperationException();
    }

    public double getCoordinateScale() {
        throw new UnimplementedOperationException();
    }

    public boolean isFixedTime() {
        return this.environment == World.Environment.THE_END || this.environment == World.Environment.NETHER;
    }

    @NotNull
    public Collection<Material> getInfiniburn() {
        throw new UnimplementedOperationException();
    }

    public void sendGameEvent(@Nullable Entity sourceEntity, @NotNull GameEvent gameEvent, @NotNull Vector position) {
        throw new UnimplementedOperationException();
    }

    public boolean isChunkForceLoaded(int x, int z) {
        throw new UnimplementedOperationException();
    }

    public void setChunkForceLoaded(int x, int z, boolean forced) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Collection<Chunk> getForceLoadedChunks() {
        throw new UnimplementedOperationException();
    }

    public boolean addPluginChunkTicket(int x, int z, Plugin plugin) {
        throw new UnimplementedOperationException();
    }

    public boolean removePluginChunkTicket(int x, int z, Plugin plugin) {
        throw new UnimplementedOperationException();
    }

    public void removePluginChunkTickets(Plugin plugin) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Collection<Plugin> getPluginChunkTickets(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Map<Plugin, Collection<Chunk>> getPluginChunkTickets() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Collection<Chunk> getIntersectingChunks(@NotNull BoundingBox box) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public <T extends AbstractArrow> T spawnArrow(Location location, Vector direction, float speed, float spread, Class<T> clazz) {
        throw new UnimplementedOperationException();
    }

    public Raid locateNearestRaid(Location location, int radius) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Raid getRaid(int id) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public List<Raid> getRaids() {
        throw new UnimplementedOperationException();
    }

    public boolean createExplosion(double x, double y, double z, float power, boolean setFire, boolean breakBlocks, Entity source) {
        throw new UnimplementedOperationException();
    }

    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks) {
        throw new UnimplementedOperationException();
    }

    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks, Entity source) {
        throw new UnimplementedOperationException();
    }

    public int getHighestBlockYAt(int x, int z, @NotNull HeightMap heightMap) {
        Preconditions.checkNotNull((Object)heightMap);
        return this.getHighestBlockYAt(x, z, (Block block) -> this.isOfHeightMap((Block)block, heightMap));
    }

    private int getHighestBlockYAt(int x, int z, Function<Block, Boolean> filter) {
        for (int y = this.getMaxHeight() - 1; y >= this.getMinHeight(); --y) {
            BlockMock block = this.getBlockAt(x, y, z);
            if (!filter.apply(block).booleanValue()) continue;
            return block.getY();
        }
        return this.getMinHeight() - 1;
    }

    private boolean isOfHeightMap(Block block, HeightMap heightMap) {
        return switch (heightMap) {
            default -> throw new MatchException(null, null);
            case HeightMap.MOTION_BLOCKING -> {
                Waterlogged waterlogged;
                boolean isWaterLogged;
                BlockData var5_3 = block.getBlockData();
                boolean v0 = isWaterLogged = var5_3 instanceof Waterlogged && (waterlogged = (Waterlogged)var5_3).isWaterlogged();
                if (block.isSolid() || isWaterLogged || block.isLiquid()) {
                    yield true;
                }
                yield false;
            }
            case HeightMap.MOTION_BLOCKING_NO_LEAVES -> {
                Waterlogged waterlogged;
                boolean isWaterLogged;
                BlockData var5_4 = block.getBlockData();
                boolean v2 = isWaterLogged = var5_4 instanceof Waterlogged && (waterlogged = (Waterlogged)var5_4).isWaterlogged();
                if ((block.isSolid() || isWaterLogged || block.isLiquid()) && !Tag.LEAVES.isTagged((Keyed)block.getType())) {
                    yield true;
                }
                yield false;
            }
            case HeightMap.OCEAN_FLOOR -> block.isSolid();
            case HeightMap.OCEAN_FLOOR_WG -> {
                if (block.getY() <= this.grassHeight && this.defaultBlock.isSolid() || block.getY() == 0) {
                    yield true;
                }
                yield false;
            }
            case HeightMap.WORLD_SURFACE_WG -> {
                if (block.getY() <= this.grassHeight && !this.defaultBlock.isAir() || block.getY() == 0) {
                    yield true;
                }
                yield false;
            }
            case HeightMap.WORLD_SURFACE -> !block.getType().isAir();
        };
    }

    public int getHighestBlockYAt(Location location, @NotNull HeightMap heightMap) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ(), heightMap);
    }

    @NotNull
    public Block getHighestBlockAt(int x, int z, @NotNull HeightMap heightMap) {
        return this.getBlockAt(x, this.getHighestBlockYAt(x, z), z);
    }

    @NotNull
    public Block getHighestBlockAt(Location location, @NotNull HeightMap heightMap) {
        return this.getBlockAt(location.getBlockX(), this.getHighestBlockYAt(location), location.getBlockZ());
    }

    @NotNull
    public Biome getBiome(@NotNull Location location) {
        return this.getBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @NotNull
    public Biome getBiome(int x, int y, int z) {
        return this.biomes.getOrDefault(new Coordinate(x, y, z), this.defaultBiome);
    }

    @NotNull
    public Biome getComputedBiome(int x, int y, int z) {
        throw new UnimplementedOperationException();
    }

    public void setBiome(@NotNull Location location, @NotNull Biome biome) {
        this.setBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ(), biome);
    }

    public void setBiome(int x, int y, int z, @NotNull Biome bio) {
        Preconditions.checkArgument((bio != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot set the biome to %s", (Object)bio);
        this.biomes.put(new Coordinate(x, y, z), bio);
    }

    @NotNull
    protected Map<Coordinate, Biome> getBiomeMap() {
        return new HashMap<Coordinate, Biome>(this.biomes);
    }

    public Biome getDefaultBiome() {
        return this.defaultBiome;
    }

    @NotNull
    public BlockState getBlockState(@NotNull Location location) {
        BlockMock block = this.getBlockAt(location);
        return block.getState();
    }

    @NotNull
    public BlockState getBlockState(int x, int y, int z) {
        BlockMock block = this.getBlockAt(x, y, z);
        return block.getState();
    }

    @NotNull
    public FluidData getFluidData(int i, int i1, int i2) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BlockData getBlockData(@NotNull Location location) {
        BlockMock block = this.getBlockAt(location);
        return block.getBlockData();
    }

    @NotNull
    public BlockData getBlockData(int x, int y, int z) {
        BlockMock block = this.getBlockAt(x, y, z);
        return block.getBlockData();
    }

    @NotNull
    public Material getType(@NotNull Location location) {
        BlockMock block = this.getBlockAt(location);
        return block.getType();
    }

    @NotNull
    public Material getType(int x, int y, int z) {
        BlockMock block = this.getBlockAt(x, y, z);
        return block.getType();
    }

    public void setBlockData(@NotNull Location location, @NotNull BlockData blockData) {
        BlockMock block = this.getBlockAt(location);
        block.setBlockData(blockData);
    }

    public void setBlockData(int x, int y, int z, @NotNull BlockData blockData) {
        BlockMock block = this.getBlockAt(x, y, z);
        block.setBlockData(blockData);
    }

    public void setType(@NotNull Location location, @NotNull Material material) {
        BlockMock block = this.getBlockAt(location);
        block.setType(material);
    }

    public void setType(int x, int y, int z, @NotNull Material material) {
        BlockMock block = this.getBlockAt(x, y, z);
        block.setType(material);
    }

    public boolean generateTree(@NotNull Location location, @NotNull Random random, @NotNull TreeType type) {
        throw new UnimplementedOperationException();
    }

    public boolean generateTree(@NotNull Location location, @NotNull Random random, @NotNull TreeType type, @Nullable Consumer<? super BlockState> stateConsumer) {
        throw new UnimplementedOperationException();
    }

    public double getTemperature(int x, int y, int z) {
        throw new UnimplementedOperationException();
    }

    public double getHumidity(int x, int y, int z) {
        throw new UnimplementedOperationException();
    }

    public int getLogicalHeight() {
        return switch (this.environment) {
            default -> throw new MatchException(null, null);
            case World.Environment.NETHER, World.Environment.THE_END -> 256;
            case World.Environment.NORMAL -> 384;
            case World.Environment.CUSTOM -> throw new UnimplementedOperationException("We don't have support for Datapacks");
        };
    }

    public boolean isNatural() {
        return switch (this.environment) {
            case World.Environment.NETHER, World.Environment.THE_END -> false;
            default -> true;
        };
    }

    public boolean isBedWorks() {
        return switch (this.environment) {
            case World.Environment.NETHER, World.Environment.THE_END -> false;
            default -> true;
        };
    }

    public boolean hasSkyLight() {
        return switch (this.environment) {
            case World.Environment.NETHER, World.Environment.THE_END -> false;
            default -> true;
        };
    }

    public boolean hasCeiling() {
        return this.environment == World.Environment.NETHER;
    }

    public boolean isPiglinSafe() {
        return this.environment == World.Environment.NETHER;
    }

    public boolean isRespawnAnchorWorks() {
        return this.environment == World.Environment.NETHER;
    }

    public boolean hasRaids() {
        return this.environment != World.Environment.NETHER;
    }

    public boolean isUltraWarm() {
        return this.environment == World.Environment.NETHER;
    }

    public boolean isHardcore() {
        return this.hardcore;
    }

    public void setHardcore(boolean hardcore) {
        this.hardcore = hardcore;
    }

    @Deprecated(since="1.18")
    public long getTicksPerWaterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_ANIMAL);
    }

    @Deprecated(since="1.18")
    public void setTicksPerWaterSpawns(int ticksPerWaterSpawns) {
        this.setTicksPerSpawns(SpawnCategory.WATER_ANIMAL, ticksPerWaterSpawns);
    }

    @Deprecated(since="1.18")
    public long getTicksPerAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.AMBIENT);
    }

    @Deprecated(since="1.18")
    public void setTicksPerAmbientSpawns(int ticksPerAmbientSpawns) {
        this.setTicksPerSpawns(SpawnCategory.AMBIENT, ticksPerAmbientSpawns);
    }

    public DragonBattle getEnderDragonBattle() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Set<FeatureFlag> getFeatureFlags() {
        throw new UnimplementedOperationException();
    }

    public boolean setSpawnLocation(int x, int y, int z, float angle) {
        throw new UnimplementedOperationException();
    }

    @Deprecated(since="1.18")
    public long getTicksPerWaterAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_AMBIENT);
    }

    @Deprecated(since="1.18")
    public void setTicksPerWaterAmbientSpawns(int ticksPerAmbientSpawns) {
        this.setTicksPerSpawns(SpawnCategory.WATER_AMBIENT, ticksPerAmbientSpawns);
    }

    @Deprecated(since="1.18")
    public long getTicksPerWaterUndergroundCreatureSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Deprecated(since="1.18")
    public void setTicksPerWaterUndergroundCreatureSpawns(int ticksPerWaterUndergroundCreatureSpawns) {
        this.setTicksPerSpawns(SpawnCategory.WATER_UNDERGROUND_CREATURE, ticksPerWaterUndergroundCreatureSpawns);
    }

    @Deprecated(since="1.18")
    public int getWaterAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_AMBIENT);
    }

    @Deprecated(since="1.18")
    public void setWaterAmbientSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.WATER_AMBIENT, limit);
    }

    public int getViewDistance() {
        throw new UnimplementedOperationException();
    }

    public void setViewDistance(int viewDistance) {
        throw new UnimplementedOperationException();
    }

    public void setSimulationDistance(int simulationDistance) {
        throw new UnimplementedOperationException();
    }

    @Deprecated(since="1.18")
    public int getNoTickViewDistance() {
        throw new UnimplementedOperationException();
    }

    @Deprecated(since="1.18")
    public void setNoTickViewDistance(int viewDistance) {
        throw new UnimplementedOperationException();
    }

    public int getSendViewDistance() {
        throw new UnimplementedOperationException();
    }

    public void setSendViewDistance(int viewDistance) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Collection<GeneratedStructure> getStructures(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Collection<GeneratedStructure> getStructures(int x, int z, @NotNull Structure structure) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public World.Spigot spigot() {
        throw new UnimplementedOperationException();
    }

    public long getGameTime() {
        throw new UnimplementedOperationException();
    }

    public int getSimulationDistance() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    public long getTicksPerSpawns(@NotNull SpawnCategory spawnCategory) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((spawnCategory != null && spawnCategory != SpawnCategory.MISC ? 1 : 0) != 0, (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        return this.ticksPerSpawn.getLong((Object)spawnCategory);
    }

    public void setTicksPerSpawns(@NotNull SpawnCategory spawnCategory, int ticksPerCategorySpawn) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((spawnCategory != null && spawnCategory != SpawnCategory.MISC ? 1 : 0) != 0, (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        this.ticksPerSpawn.put((Object)spawnCategory, (long)ticksPerCategorySpawn);
    }

    public int getSpawnLimit(@NotNull SpawnCategory spawnCategory) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((spawnCategory != SpawnCategory.MISC ? 1 : 0) != 0, (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        return this.getSpawnLimitUnsafe(spawnCategory);
    }

    public final int getSpawnLimitUnsafe(SpawnCategory spawnCategory) {
        int limit = this.spawnLimits.getOrDefault((Object)spawnCategory, -1);
        if (limit < 0) {
            limit = this.server.getSpawnLimit(spawnCategory);
        }
        return limit;
    }

    public void setSpawnLimit(@NotNull SpawnCategory spawnCategory, int limit) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((spawnCategory != SpawnCategory.MISC ? 1 : 0) != 0, (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        this.spawnLimits.put((Object)spawnCategory, limit);
    }

    public void playNote(@NotNull Location loc, @NotNull Instrument instrument, @NotNull Note note) {
        throw new UnimplementedOperationException();
    }

    public void playSound(@NotNull Entity entity, @NotNull String sound, @NotNull SoundCategory category, float volume, float pitch, long seed) {
        throw new UnimplementedOperationException();
    }

    public void playSound(@NotNull Entity entity, @NotNull Sound sound, @NotNull SoundCategory category, float volume, float pitch, long seed) {
        throw new UnimplementedOperationException();
    }

    public void playSound(@NotNull Location location, @NotNull String sound, @NotNull SoundCategory category, float volume, float pitch, long seed) {
        throw new UnimplementedOperationException();
    }

    public void playSound(@NotNull Location location, @NotNull Sound sound, @NotNull SoundCategory category, float volume, float pitch, long seed) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public NamespacedKey getKey() {
        throw new UnimplementedOperationException();
    }
}

