/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.adventure;

import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.adventure.JsonBackedLanguage;
import be.seeseemelk.mockbukkit.adventure.Language;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class Languages {
    private static Language instance = Languages.loadLanguage(Language.LanguageType.ENGLISH);

    public static Language getInstance() {
        return instance;
    }

    public static void setInstance(Language instance) {
        Preconditions.checkNotNull((Object)instance);
        Languages.instance = instance;
    }

    public static Language loadLanguage(Language.LanguageType language) {
        Language language2;
        block9: {
            String resourceName = "/translations/" + language.getResourceName();
            InputStream inputStream = MockBukkit.class.getResourceAsStream(resourceName);
            try {
                if (inputStream == null) {
                    throw new IllegalStateException("Could not find internal resource: " + resourceName);
                }
                language2 = Languages.loadLanguage(inputStream);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return language2;
    }

    public static Language loadLanguage(InputStream inputStream) {
        JsonElement jsonElement = JsonParser.parseReader((Reader)new InputStreamReader(inputStream));
        return new JsonBackedLanguage(jsonElement.getAsJsonObject());
    }

    private Languages() {
        throw new UnsupportedOperationException("Utility class");
    }
}

