/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.adventure;

import be.seeseemelk.mockbukkit.adventure.Language;
import be.seeseemelk.mockbukkit.adventure.Languages;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.TranslationRegistry;
import net.kyori.adventure.translation.Translator;
import org.jetbrains.annotations.NotNull;

public class PlainTextComponentProviderImpl
implements PlainTextComponentSerializer.Provider {
    private static final Pattern LOCALIZATION_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?s");
    private static final ComponentFlattener BASIC_COMPONENT_FLATTENER = (ComponentFlattener)((ComponentFlattener.Builder)ComponentFlattener.basic().toBuilder()).complexMapper(TranslatableComponent.class, PlainTextComponentProviderImpl::processTranslatable).build();

    @NotNull
    public PlainTextComponentSerializer plainTextSimple() {
        return (PlainTextComponentSerializer)PlainTextComponentSerializer.builder().flattener(BASIC_COMPONENT_FLATTENER).build();
    }

    @NotNull
    public Consumer<PlainTextComponentSerializer.Builder> plainText() {
        return builder -> builder.flattener(BASIC_COMPONENT_FLATTENER);
    }

    private static void processTranslatable(TranslatableComponent translatable, Consumer<Component> consumer) {
        try {
            Language language = Languages.getInstance();
            if (!language.has(translatable.key())) {
                for (Translator source : GlobalTranslator.translator().sources()) {
                    TranslationRegistry registry;
                    if (!(source instanceof TranslationRegistry) || !(registry = (TranslationRegistry)source).contains(translatable.key())) continue;
                    consumer.accept(GlobalTranslator.render((Component)translatable, (Locale)Locale.US));
                    return;
                }
            }
            String fallback = translatable.fallback();
            String translated = Languages.getInstance().getOrDefault(translatable.key(), fallback);
            List argumentList = translatable.arguments();
            Matcher matcher = LOCALIZATION_PATTERN.matcher(translated);
            int argPosition = 0;
            int lastIndex = 0;
            while (matcher.find()) {
                if (lastIndex < matcher.start()) {
                    consumer.accept((Component)Component.text((String)translated.substring(lastIndex, matcher.start())));
                }
                lastIndex = matcher.end();
                argPosition = PlainTextComponentProviderImpl.dealWithTranslatableArguments(matcher, consumer, argumentList, argPosition);
            }
            if (lastIndex < translated.length()) {
                consumer.accept((Component)Component.text((String)translated.substring(lastIndex)));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static int dealWithTranslatableArguments(Matcher matcher, Consumer<Component> consumer, List<TranslationArgument> argumentList, int argPosition) {
        int idx;
        String argIndex = matcher.group(1);
        if (argIndex != null) {
            try {
                int idx2 = Integer.parseInt(argIndex) - 1;
                if (idx2 < argumentList.size()) {
                    consumer.accept(argumentList.get(idx2).asComponent());
                }
            }
            catch (NumberFormatException idx2) {}
        } else if ((idx = argPosition++) < argumentList.size()) {
            consumer.accept(argumentList.get(idx).asComponent());
        }
        return argPosition;
    }
}

