/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.block.data.BlockDataMock;
import be.seeseemelk.mockbukkit.block.state.BlockStateMock;
import be.seeseemelk.mockbukkit.metadata.MetadataTable;
import be.seeseemelk.mockbukkit.tags.internal.InternalTag;
import com.destroystokyo.paper.block.BlockSoundGroup;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundGroup;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.bukkit.util.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;

public class BlockMock
implements Block {
    private final MetadataTable metadataTable = new MetadataTable();
    private final Location location;
    private BlockStateMock state;
    private Material material;
    private byte data;
    private BlockData blockData;
    private byte lightFromSky = (byte)15;
    private byte lightFromBlocks = 0;

    public BlockMock() {
        this(Material.AIR);
    }

    public BlockMock(@NotNull Location location) {
        this(Material.AIR, location);
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null");
    }

    public BlockMock(@NotNull Material material) {
        this(material, null);
    }

    public BlockMock(@NotNull Material material, @Nullable Location location) {
        Preconditions.checkNotNull((Object)material, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isBlock(), (Object)"Material has to be a block");
        this.material = material;
        this.location = location;
        this.state = BlockStateMock.mockState(this);
        this.blockData = BlockDataMock.mock(material);
    }

    public void setMetadata(String metadataKey, @NotNull MetadataValue newMetadataValue) {
        this.metadataTable.setMetadata(metadataKey, newMetadataValue);
    }

    @NotNull
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.metadataTable.getMetadata(metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.metadataTable.hasMetadata(metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.metadataTable.removeMetadata(metadataKey, owningPlugin);
    }

    @Deprecated(since="1.6.2")
    public byte getData() {
        return this.data;
    }

    @NotNull
    public Block getRelative(int modX, int modY, int modZ) {
        int x = this.location.getBlockX() + modX;
        int y = this.location.getBlockY() + modY;
        int z = this.location.getBlockZ() + modZ;
        return this.location.getWorld().getBlockAt(x, y, z);
    }

    @NotNull
    public Block getRelative(@NotNull BlockFace face) {
        return this.getRelative(face, 1);
    }

    @NotNull
    public Block getRelative(@NotNull BlockFace face, int distance) {
        Preconditions.checkNotNull((Object)face, (Object)"Face cannot be null");
        return this.getRelative(face.getModX() * distance, face.getModY() * distance, face.getModZ() * distance);
    }

    public void assertType(@NotNull Material material) {
        if (this.material != material) {
            Assertions.fail((String)String.format("Block material type is <%s>, but <%s> was expected.", this.material, material));
        }
    }

    @NotNull
    public Material getType() {
        return this.material;
    }

    public byte getLightLevel() {
        return (byte)Math.max(this.getLightFromSky(), this.getLightFromBlocks());
    }

    public byte getLightFromSky() {
        return this.lightFromSky;
    }

    public void setLightFromSky(byte lightFromSky) {
        Preconditions.checkArgument((lightFromSky >= 0 && lightFromSky <= 15 ? 1 : 0) != 0, (Object)"Light level should be between 0 and 15.");
        this.lightFromSky = lightFromSky;
    }

    public byte getLightFromBlocks() {
        return this.lightFromBlocks;
    }

    public void setLightFromBlocks(byte lightFromBlocks) {
        Preconditions.checkArgument((lightFromBlocks >= 0 && lightFromBlocks <= 15 ? 1 : 0) != 0, (Object)"Light level should be between 0 and 15.");
        this.lightFromBlocks = lightFromBlocks;
    }

    @NotNull
    public World getWorld() {
        return this.location.getWorld();
    }

    public int getX() {
        return this.location.getBlockX();
    }

    public int getY() {
        return this.location.getBlockY();
    }

    public int getZ() {
        return this.location.getBlockZ();
    }

    @Deprecated(since="1.18")
    public long getBlockKey() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Location getLocation() {
        return this.location;
    }

    public Location getLocation(@Nullable Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX(this.location.getX());
            loc.setY(this.location.getY());
            loc.setZ(this.location.getZ());
            loc.setYaw(0.0f);
            loc.setPitch(0.0f);
        }
        return loc;
    }

    @NotNull
    public Chunk getChunk() {
        return this.location.getWorld().getChunkAt((Block)this);
    }

    public void setType(@NotNull Material type) {
        Preconditions.checkNotNull((Object)type, (Object)"Type cannot be null");
        this.material = type;
        this.state = BlockStateMock.mockState(this);
        this.blockData = BlockDataMock.mock(type);
    }

    public void setType(@NotNull Material type, boolean applyPhysics) {
        this.setType(type);
    }

    public BlockFace getFace(@NotNull Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"Block cannot be null");
        for (BlockFace face : BlockFace.values()) {
            if (this.getX() + face.getModX() != block.getX() || this.getY() + face.getModY() != block.getY() || this.getZ() + face.getModZ() != block.getZ()) continue;
            return face;
        }
        return null;
    }

    @NotNull
    public BlockState getState() {
        return this.state.getSnapshot();
    }

    @NotNull
    public Biome getBiome() {
        return this.getWorld().getBiome(this.getLocation());
    }

    @NotNull
    public Biome getComputedBiome() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public float getDestroySpeed(@NotNull ItemStack itemStack) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BlockState getState(boolean useSnapshot) {
        throw new UnimplementedOperationException();
    }

    public boolean isValidTool(@NotNull ItemStack itemStack) {
        throw new UnimplementedOperationException();
    }

    public void setBiome(@NotNull Biome bio) {
        Preconditions.checkNotNull((Object)bio, (Object)"Biome cannot be null");
        this.getWorld().setBiome(this.getLocation(), bio);
    }

    public boolean isBlockPowered() {
        throw new UnimplementedOperationException();
    }

    public boolean isBlockIndirectlyPowered() {
        throw new UnimplementedOperationException();
    }

    public boolean isBlockFacePowered(@NotNull BlockFace face) {
        throw new UnimplementedOperationException();
    }

    public boolean isBlockFaceIndirectlyPowered(@NotNull BlockFace face) {
        throw new UnimplementedOperationException();
    }

    public int getBlockPower(@NotNull BlockFace face) {
        throw new UnimplementedOperationException();
    }

    public int getBlockPower() {
        throw new UnimplementedOperationException();
    }

    public boolean isEmpty() {
        return this.material.isAir();
    }

    public boolean isBurnable() {
        throw new UnimplementedOperationException();
    }

    public boolean isSolid() {
        if (InternalTag.SOLID_BLOCKS.isTagged(this.getType())) {
            return true;
        }
        if (InternalTag.NON_SOLID_BLOCKS.isTagged(this.getType())) {
            return false;
        }
        throw new UnimplementedOperationException("Block type '" + String.valueOf(this.getType()) + "' has not been implemented yet");
    }

    public boolean isCollidable() {
        throw new UnimplementedOperationException();
    }

    public boolean isReplaceable() {
        throw new UnimplementedOperationException();
    }

    public boolean isLiquid() {
        return this.material == Material.LAVA || this.material == Material.WATER || this.material == Material.BUBBLE_COLUMN;
    }

    public boolean isBuildable() {
        throw new UnimplementedOperationException();
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public BlockSoundGroup getSoundGroup() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public SoundGroup getBlockSoundGroup() {
        throw new UnimplementedOperationException();
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public String getTranslationKey() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public float getDestroySpeed(@NotNull ItemStack itemStack, boolean considerEnchants) {
        throw new UnimplementedOperationException();
    }

    public boolean breakNaturally(@NotNull ItemStack tool, boolean triggerEffect) {
        throw new UnimplementedOperationException();
    }

    public void tick() {
        throw new UnimplementedOperationException();
    }

    public void fluidTick() {
        throw new UnimplementedOperationException();
    }

    public void randomTick() {
        throw new UnimplementedOperationException();
    }

    public boolean breakNaturally(boolean triggerEffect) {
        throw new UnimplementedOperationException();
    }

    public boolean breakNaturally(@NotNull ItemStack tool, boolean triggerEffect, boolean dropExperience) {
        throw new UnimplementedOperationException();
    }

    public boolean breakNaturally(boolean triggerEffect, boolean dropExperience) {
        throw new UnimplementedOperationException();
    }

    public double getTemperature() {
        throw new UnimplementedOperationException();
    }

    public double getHumidity() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public PistonMoveReaction getPistonMoveReaction() {
        throw new UnimplementedOperationException();
    }

    public boolean breakNaturally() {
        if (this.isEmpty()) {
            return false;
        }
        this.setType(Material.AIR);
        return true;
    }

    public boolean breakNaturally(@Nullable ItemStack tool) {
        return this.breakNaturally();
    }

    @NotNull
    public Collection<ItemStack> getDrops() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Collection<ItemStack> getDrops(@Nullable ItemStack tool) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BlockData getBlockData() {
        return this.blockData;
    }

    public void setBlockData(@NotNull BlockData data) {
        this.material = data.getMaterial();
        this.blockData = data;
    }

    public void setBlockData(@NotNull BlockData data, boolean applyPhysics) {
        throw new UnimplementedOperationException();
    }

    public boolean isPassable() {
        throw new UnimplementedOperationException();
    }

    public RayTraceResult rayTrace(@NotNull Location start, @NotNull Vector direction, double maxDistance, @NotNull FluidCollisionMode fluidCollisionMode) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BoundingBox getBoundingBox() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public VoxelShape getCollisionShape() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Collection<ItemStack> getDrops(@NotNull ItemStack tool, Entity entity) {
        throw new UnimplementedOperationException();
    }

    public void setState(@NotNull BlockStateMock state) {
        Preconditions.checkNotNull((Object)state, (Object)"The BlockState cannot be null");
        this.state = state;
    }

    public boolean applyBoneMeal(@NotNull BlockFace face) {
        throw new UnimplementedOperationException();
    }

    public boolean isPreferredTool(@NotNull ItemStack tool) {
        throw new UnimplementedOperationException();
    }

    public float getBreakSpeed(@NotNull Player player) {
        throw new UnimplementedOperationException();
    }

    public boolean canPlace(@NotNull BlockData data) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public String translationKey() {
        throw new UnimplementedOperationException();
    }
}

