/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.data;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.block.data.AmethystClusterMock;
import be.seeseemelk.mockbukkit.block.data.BedMock;
import be.seeseemelk.mockbukkit.block.data.BlockDataMockRegistry;
import be.seeseemelk.mockbukkit.block.data.CampfireMock;
import be.seeseemelk.mockbukkit.block.data.SlabMock;
import be.seeseemelk.mockbukkit.block.data.StairsMock;
import be.seeseemelk.mockbukkit.block.data.SwitchMock;
import be.seeseemelk.mockbukkit.block.data.TrapDoorMock;
import be.seeseemelk.mockbukkit.block.data.WallSignMock;
import be.seeseemelk.mockbukkit.block.state.BlockStateMock;
import com.destroystokyo.paper.MaterialTags;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundGroup;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.BlockSupport;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockDataMock
implements BlockData {
    private static final String NULL_MATERIAL_EXCEPTION_MESSAGE = "Material cannot be null";
    @NotNull
    private final Material type;
    @NotNull
    private Map<String, Object> data;

    public BlockDataMock(@NotNull Material material) {
        BlockDataMock.checkMaterial(material);
        this.type = material;
        this.data = new LinkedHashMap<String, Object>();
    }

    protected void checkType(@NotNull Material material, Material ... expected) {
        Preconditions.checkArgument((boolean)Arrays.stream(expected).anyMatch(m -> material == m), (Object)("Cannot create a " + this.getClass().getSimpleName() + " from " + String.valueOf(material)));
    }

    protected void checkType(@NotNull Material material, @NotNull Tag<Material> expected) {
        Preconditions.checkArgument((boolean)expected.isTagged((Keyed)material), (Object)("Cannot create a " + this.getClass().getSimpleName() + " from " + String.valueOf(material)));
    }

    protected static void checkMaterial(@NotNull Material material) {
        Preconditions.checkNotNull((Object)material, (Object)NULL_MATERIAL_EXCEPTION_MESSAGE);
        Preconditions.checkState((boolean)material.isBlock(), (Object)("Can't create a block from " + String.valueOf(material)));
    }

    protected void checkProperty(String property) {
        Preconditions.checkState((boolean)BlockDataMockRegistry.getInstance().isValidStateForBlockWithMaterial(this.getMaterial(), property), (Object)(property + " is not a valid property for " + String.valueOf(this.getMaterial())));
    }

    protected <T> void set(@NotNull String key, @NotNull T value) {
        Preconditions.checkNotNull((Object)key, (Object)"Key cannot be null");
        Preconditions.checkNotNull(value, (Object)"Value cannot be null");
        this.checkProperty(key);
        this.data.put(key, value);
    }

    @NotNull
    protected <T> T get(@NotNull String key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key cannot be null");
        this.checkProperty(key);
        Object value = this.data.get(key);
        if (value == null) {
            value = BlockDataMockRegistry.getInstance().getDefault(this.getMaterial(), key);
        }
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)("Cannot get property " + key + " as it does not exist"));
        return (T)value;
    }

    @NotNull
    public Material getMaterial() {
        return this.type;
    }

    @NotNull
    public String getAsString() {
        return this.getAsString(false);
    }

    @NotNull
    public String getAsString(boolean hideUnspecified) {
        StringBuilder stateString = new StringBuilder(String.valueOf(this.getMaterial().getKey()) + "[");
        ArrayList<String> keysToShow = new ArrayList<String>(hideUnspecified ? this.data.keySet() : BlockDataMockRegistry.getInstance().getBlockData(this.type).keySet());
        Collections.sort(keysToShow);
        boolean isFirst = true;
        for (String key : keysToShow) {
            if (!isFirst) {
                stateString.append(',');
            }
            Object value = this.data.get(key);
            Object defaultValue = BlockDataMockRegistry.getInstance().getDefault(this.type, key);
            if (hideUnspecified && value == defaultValue) continue;
            stateString.append(key).append("=").append((value == null ? defaultValue : value).toString().toLowerCase());
            isFirst = false;
        }
        stateString.append(']');
        return stateString.toString().replace("[]", "");
    }

    @NotNull
    public BlockData merge(@NotNull BlockData data) {
        Preconditions.checkNotNull((Object)data, (Object)"Data cannot be null");
        Preconditions.checkState((this.getMaterial() == data.getMaterial() ? 1 : 0) != 0, (Object)"Materials should match exactly");
        BlockDataMock mock = this.clone();
        mock.data.putAll(((BlockDataMock)data).data);
        return mock;
    }

    @NotNull
    public SoundGroup getSoundGroup() {
        throw new UnimplementedOperationException();
    }

    public int getLightEmission() {
        throw new UnimplementedOperationException();
    }

    public boolean isOccluding() {
        throw new UnimplementedOperationException();
    }

    public boolean requiresCorrectToolForDrops() {
        throw new UnimplementedOperationException();
    }

    public boolean isSupported(@NotNull Block block) {
        throw new UnimplementedOperationException();
    }

    public boolean isSupported(@NotNull Location location) {
        throw new UnimplementedOperationException();
    }

    public boolean isFaceSturdy(@NotNull BlockFace face, @NotNull BlockSupport support) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull Location location) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Color getMapColor() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Material getPlacementMaterial() {
        throw new UnimplementedOperationException();
    }

    public void rotate(@NotNull StructureRotation rotation) {
        throw new UnimplementedOperationException();
    }

    public void mirror(@NotNull Mirror mirror) {
        throw new UnimplementedOperationException();
    }

    public void copyTo(@NotNull BlockData blockData) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BlockState createBlockState() {
        return BlockStateMock.mockState(this.getMaterial());
    }

    public float getDestroySpeed(@NotNull ItemStack itemStack, boolean considerEnchants) {
        throw new UnimplementedOperationException();
    }

    public boolean isRandomlyTicked() {
        throw new UnimplementedOperationException();
    }

    public boolean isPreferredTool(@NotNull ItemStack tool) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public PistonMoveReaction getPistonMoveReaction() {
        throw new UnimplementedOperationException();
    }

    public boolean matches(@Nullable BlockData data) {
        if (data == null || data.getMaterial() != this.getMaterial()) {
            return false;
        }
        boolean matches = this.equals(data);
        if (!matches) {
            return this.merge(data).equals((Object)this);
        }
        return matches;
    }

    public int hashCode() {
        return this.type.hashCode() * this.data.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof BlockDataMock)) return false;
        BlockDataMock mock = (BlockDataMock)obj;
        if (this.getMaterial() != mock.getMaterial()) return false;
        if (!this.data.equals(mock.data)) return false;
        return true;
    }

    @NotNull
    public BlockDataMock clone() {
        try {
            BlockDataMock clonedObject = (BlockDataMock)super.clone();
            clonedObject.data = new LinkedHashMap<String, Object>(clonedObject.data);
            return clonedObject;
        }
        catch (CloneNotSupportedException e) {
            return BlockDataMock.mock(this.type, this.data);
        }
    }

    @NotNull
    public static BlockDataMock mock(@NotNull Material material) {
        Preconditions.checkNotNull((Object)material, (Object)NULL_MATERIAL_EXCEPTION_MESSAGE);
        BlockDataMock mock = BlockDataMock.attemptMockByPaperMaterialTags(material);
        if (mock != null) {
            return mock;
        }
        mock = BlockDataMock.attemptMockByTag(material);
        if (mock != null) {
            return mock;
        }
        return switch (material) {
            case Material.AMETHYST_CLUSTER -> new AmethystClusterMock(material);
            case Material.LEVER -> new SwitchMock(material);
            default -> new BlockDataMock(material);
        };
    }

    @NotNull
    private static BlockDataMock mock(@NotNull Material material, @NotNull Map<String, Object> previousData) {
        Preconditions.checkNotNull(previousData, (Object)"previousData should not be null");
        BlockDataMock blockDataMock = BlockDataMock.mock(material);
        blockDataMock.data.putAll(previousData);
        return blockDataMock;
    }

    private static BlockDataMock attemptMockByPaperMaterialTags(@NotNull Material material) {
        Preconditions.checkNotNull((Object)material, (Object)NULL_MATERIAL_EXCEPTION_MESSAGE);
        if (MaterialTags.BEDS.isTagged(material)) {
            return new BedMock(material);
        }
        return null;
    }

    private static BlockDataMock attemptMockByTag(@NotNull Material material) {
        Preconditions.checkNotNull((Object)material, (Object)NULL_MATERIAL_EXCEPTION_MESSAGE);
        if (Tag.SLABS.isTagged((Keyed)material)) {
            return new SlabMock(material);
        }
        if (Tag.STAIRS.isTagged((Keyed)material)) {
            return new StairsMock(material);
        }
        if (Tag.TRAPDOORS.isTagged((Keyed)material)) {
            return new TrapDoorMock(material);
        }
        if (Tag.CAMPFIRES.isTagged((Keyed)material)) {
            return new CampfireMock(material);
        }
        if (Tag.WALL_SIGNS.isTagged((Keyed)material)) {
            return new WallSignMock(material);
        }
        if (Tag.BUTTONS.isTagged((Keyed)material)) {
            return new SwitchMock(material);
        }
        return null;
    }
}

