/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.data;

import be.seeseemelk.mockbukkit.MockBukkit;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Map;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;

public class BlockDataMockRegistry {
    private static BlockDataMockRegistry instance = null;
    private Map<Material, Map<String, Object>> blockData = null;

    private BlockDataMockRegistry() {
        try {
            this.loadBlockData();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static BlockDataMockRegistry getInstance() {
        if (instance == null) {
            instance = new BlockDataMockRegistry();
        }
        return instance;
    }

    private void loadBlockData() throws IOException {
        InputStream stream = MockBukkit.class.getResourceAsStream("/materials/material_data.json");
        if (stream == null) {
            throw new IOException("Failed to load materials data, file not found");
        }
        try (InputStreamReader reader = new InputStreamReader(stream);){
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter(Material.class, (Object)new MaterialDeserializer());
            Gson gson = gsonBuilder.create();
            Type type = new TypeToken<Map<Material, Map<String, Object>>>(this){}.getType();
            this.blockData = (Map)gson.fromJson((Reader)reader, type);
        }
    }

    @Nullable
    public Map<String, Object> getBlockData(@NotNull Material material) {
        return this.blockData.get(material);
    }

    public boolean isValidMaterialForBlock(@NotNull Material material) {
        return material.isBlock();
    }

    public boolean isValidStateForBlockWithMaterial(@NotNull Material material, @NotNull String state) {
        Map<String, Object> tmp = this.blockData.get(material);
        if (tmp == null) {
            return false;
        }
        return tmp.get(state) != null;
    }

    @Nullable
    public Object getDefault(@NotNull Material material, @NotNull String state) {
        Map<String, Object> bd = this.getBlockData(material);
        if (bd == null) {
            return null;
        }
        return bd.get(state);
    }

    private static class MaterialDeserializer
    implements JsonDeserializer<Material> {
        private MaterialDeserializer() {
        }

        public Material deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            String minecraftId = json.getAsString();
            Material tmp = Material.matchMaterial((String)minecraftId);
            if (tmp == null) {
                throw new IllegalArgumentException("No corresponding Material enum found for " + minecraftId);
            }
            return tmp;
        }
    }
}

