/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.data;

import be.seeseemelk.mockbukkit.block.data.BlockDataMock;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.type.Stairs;
import org.jetbrains.annotations.NotNull;

public class StairsMock
extends BlockDataMock
implements Stairs {
    public StairsMock(@NotNull Material type) {
        super(type);
        this.checkType(type, (Tag<Material>)Tag.STAIRS);
        this.setShape(Stairs.Shape.STRAIGHT);
        this.setWaterlogged(false);
        this.setFacing(BlockFace.NORTH);
        this.setHalf(Bisected.Half.BOTTOM);
    }

    @NotNull
    public Stairs.Shape getShape() {
        return (Stairs.Shape)this.get("shape");
    }

    public void setShape(@NotNull Stairs.Shape shape) {
        Preconditions.checkNotNull((Object)"Shape cannot be null");
        this.set("shape", shape);
    }

    @NotNull
    public Bisected.Half getHalf() {
        return (Bisected.Half)this.get("half");
    }

    public void setHalf(@NotNull Bisected.Half half) {
        Preconditions.checkNotNull((Object)half, (Object)"Half cannot be null");
        this.set("half", half);
    }

    @NotNull
    public BlockFace getFacing() {
        return (BlockFace)this.get("facing");
    }

    public void setFacing(@NotNull BlockFace facing) {
        Preconditions.checkNotNull((Object)facing, (Object)"BlockFace cannot be null");
        Preconditions.checkArgument((boolean)this.getFaces().contains(facing), (Object)("Invalid face. Must be one of " + String.valueOf(this.getFaces())));
        this.set("facing", facing);
    }

    @NotNull
    public Set<BlockFace> getFaces() {
        return Set.of(BlockFace.NORTH, BlockFace.SOUTH, BlockFace.WEST, BlockFace.EAST);
    }

    public boolean isWaterlogged() {
        return (Boolean)this.get("waterlogged");
    }

    public void setWaterlogged(boolean waterlogged) {
        this.set("waterlogged", waterlogged);
    }
}

