/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.data;

import be.seeseemelk.mockbukkit.block.data.BlockDataMock;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.type.TrapDoor;
import org.jetbrains.annotations.NotNull;

public class TrapDoorMock
extends BlockDataMock
implements TrapDoor {
    public TrapDoorMock(@NotNull Material type) {
        super(type);
        this.checkType(type, (Tag<Material>)Tag.TRAPDOORS);
        this.setHalf(Bisected.Half.BOTTOM);
        this.setOpen(false);
        this.setPowered(false);
        this.setWaterlogged(false);
        this.setFacing(BlockFace.NORTH);
    }

    @NotNull
    public Bisected.Half getHalf() {
        return (Bisected.Half)this.get("half");
    }

    public void setHalf(@NotNull Bisected.Half half) {
        Preconditions.checkNotNull((Object)half, (Object)"Half cannot be null");
        this.set("half", half);
    }

    @NotNull
    public BlockFace getFacing() {
        return (BlockFace)this.get("facing");
    }

    public void setFacing(@NotNull BlockFace facing) {
        Preconditions.checkNotNull((Object)facing, (Object)"BlockFace cannot be null");
        Preconditions.checkArgument((boolean)this.getFaces().contains(facing), (Object)("Invalid face. Must be one of " + String.valueOf(this.getFaces())));
        this.set("facing", facing);
    }

    @NotNull
    public Set<BlockFace> getFaces() {
        return Set.of(BlockFace.NORTH, BlockFace.SOUTH, BlockFace.WEST, BlockFace.EAST);
    }

    public boolean isOpen() {
        return (Boolean)this.get("open");
    }

    public void setOpen(boolean open) {
        this.set("open", open);
    }

    public boolean isPowered() {
        return (Boolean)this.get("powered");
    }

    public void setPowered(boolean powered) {
        this.set("powered", powered);
    }

    public boolean isWaterlogged() {
        return (Boolean)this.get("waterlogged");
    }

    public void setWaterlogged(boolean waterlogged) {
        this.set("waterlogged", waterlogged);
    }
}

